/*
 * Decompiled with CFR 0.152.
 */
package jme3test.blender.config;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JFrame;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;

public class AnimationsTable
extends JTable {
    private static final long serialVersionUID = 1978778634957586330L;

    public AnimationsTable() {
        super(new AnimationsTableModel(new Object[]{null, "Object name", "Animation name", "Start", "Stop"}));
        this.getTableHeader().setReorderingAllowed(false);
        this.setSelectionMode(0);
        CellRenderer cellRenderer = new CellRenderer();
        this.setDefaultRenderer(Object.class, cellRenderer);
        this.getModel().addTableModelListener(cellRenderer);
        this.getColumnModel().getColumn(0).setCellEditor(new RadioButtonCellEditor());
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.setLayout(new BorderLayout());
        frame.setDefaultCloseOperation(2);
        Random random = new Random(System.currentTimeMillis());
        AnimationsTable table = new AnimationsTable();
        int objectsCount = random.nextInt(5) + 1;
        for (int i = 1; i <= objectsCount; ++i) {
            int animsCount = random.nextInt(7) + 1;
            for (int j = 1; j <= animsCount; ++j) {
                ((DefaultTableModel)table.getModel()).addRow(new Object[]{Boolean.FALSE, "Obiekt" + i, "Animacja" + j, "Start" + j, "Stop" + j});
            }
        }
        ((DefaultTableModel)table.getModel()).addRow(new Object[]{Boolean.FALSE, "Obiekt1", "xxx", "xxx", "xxx"});
        JScrollPane jScrollPane = new JScrollPane(table, 20, 30);
        frame.add((Component)jScrollPane, "Center");
        frame.pack();
        frame.setVisible(true);
    }

    private static final class RadioButtonCellEditor
    extends DefaultCellEditor {
        private static final long serialVersionUID = 7697027333456874718L;
        private JRadioButton jRadioButton = new JRadioButton();

        public RadioButtonCellEditor() {
            super(new JTextField());
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.jRadioButton.setSelected((Boolean)value);
            return this.jRadioButton;
        }

        public Object getCellEditorValue() {
            return this.jRadioButton.isSelected();
        }
    }

    private static final class CellRenderer
    extends DefaultTableCellRenderer
    implements TableModelListener {
        private static final long serialVersionUID = 3759759133199203533L;
        private Map<String, Integer> objectIndex = new HashMap<String, Integer>();
        private Color color = new Color(240, 240, 240);
        private JRadioButton jRadioButton = new JRadioButton();

        private CellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component component;
            Object objectName = table.getModel().getValueAt(row, 1);
            if (column == 0) {
                this.jRadioButton.setSelected((Boolean)value);
                component = this.jRadioButton;
            } else {
                component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
            Integer index = this.objectIndex.get(objectName);
            if (index != null) {
                if (index % 2 == 1) {
                    component.setBackground(this.color);
                } else {
                    component.setBackground(Color.WHITE);
                }
            }
            return component;
        }

        public void tableChanged(TableModelEvent evt) {
            if (evt.getType() == 1) {
                DefaultTableModel model = (DefaultTableModel)evt.getSource();
                for (int i = evt.getFirstRow(); i <= evt.getLastRow(); ++i) {
                    String objectName = (String)model.getValueAt(i, 1);
                    if (this.objectIndex.containsKey(objectName)) continue;
                    this.objectIndex.put(objectName, this.objectIndex.size());
                }
            }
        }
    }

    private static final class AnimationsTableModel
    extends DefaultTableModel {
        private static final long serialVersionUID = 8285912542455513806L;

        public AnimationsTableModel(Object[] columnNames) {
            super(columnNames, 0);
        }

        public boolean isCellEditable(int row, int column) {
            return true;
        }

        public void addRow(Vector rowData) {
            String objectName = (String)rowData.get(1);
            int index = 0;
            boolean objectFound = false;
            for (int i = 0; i < this.getRowCount(); ++i) {
                String name = (String)this.getValueAt(i, 1);
                if (!name.equals(objectName)) continue;
                index = i;
                objectFound = true;
            }
            if (objectFound) {
                this.insertRow(index + 1, rowData);
            } else {
                super.addRow(rowData);
            }
        }
    }
}

