/*
 * Decompiled with CFR 0.152.
 */
package jme3test.blender.scene;

import com.jme3.animation.Bone;
import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Line;
import com.jme3.scene.shape.Sphere;

public class VisibleBone
extends Node {
    private Vector3f globalPosition;

    public VisibleBone(Bone bone, Vector3f parentLocation, Quaternion parentRotation, AssetManager assetManager) {
        Material redMat = new Material(assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        redMat.setColor("Color", ColorRGBA.Red);
        Material whiteMat = new Material(assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        whiteMat.setColor("Color", ColorRGBA.White);
        Geometry g = new Geometry(bone.getName(), (Mesh)new Sphere(9, 9, 0.01f));
        this.globalPosition = bone.getLocalPosition().add(parentLocation);
        g.setLocalTranslation(this.globalPosition);
        g.setLocalRotation(bone.getLocalRotation().mult(parentRotation));
        g.setMaterial(redMat);
        this.attachChild((Spatial)g);
        if (bone.getChildren() != null) {
            for (Bone child : bone.getChildren()) {
                VisibleBone vb = new VisibleBone(child, bone.getLocalPosition(), bone.getLocalRotation(), assetManager);
                this.attachChild((Spatial)vb);
                Line line = new Line(this.globalPosition, vb.globalPosition);
                line.setLineWidth(2.0f);
                Geometry geom = new Geometry("", (Mesh)line);
                geom.setMaterial(whiteMat);
                this.attachChild((Spatial)geom);
            }
        }
    }
}

