/*
 * Decompiled with CFR 0.152.
 */
package jme3test.bullet;

import com.jme3.bullet.PhysicsSpace;
import com.jme3.bullet.PhysicsTickListener;
import com.jme3.bullet.collision.PhysicsCollisionObject;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.control.PhysicsControl;
import com.jme3.bullet.objects.PhysicsVehicle;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Vector3f;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import java.io.IOException;

public class PhysicsHoverControl
extends PhysicsVehicle
implements PhysicsControl,
PhysicsTickListener {
    protected Spatial spatial;
    protected boolean enabled = true;
    protected PhysicsSpace space = null;
    protected float steeringValue = 0.0f;
    protected float accelerationValue = 0.0f;
    protected int xw = 3;
    protected int zw = 5;
    protected int yw = 2;
    protected Vector3f HOVER_HEIGHT_LF_START = new Vector3f((float)this.xw, 1.0f, (float)this.zw);
    protected Vector3f HOVER_HEIGHT_RF_START = new Vector3f((float)(-this.xw), 1.0f, (float)this.zw);
    protected Vector3f HOVER_HEIGHT_LR_START = new Vector3f((float)this.xw, 1.0f, (float)(-this.zw));
    protected Vector3f HOVER_HEIGHT_RR_START = new Vector3f((float)(-this.xw), 1.0f, (float)(-this.zw));
    protected Vector3f HOVER_HEIGHT_LF = new Vector3f((float)this.xw, (float)(-this.yw), (float)this.zw);
    protected Vector3f HOVER_HEIGHT_RF = new Vector3f((float)(-this.xw), (float)(-this.yw), (float)this.zw);
    protected Vector3f HOVER_HEIGHT_LR = new Vector3f((float)this.xw, (float)(-this.yw), (float)(-this.zw));
    protected Vector3f HOVER_HEIGHT_RR = new Vector3f((float)(-this.xw), (float)(-this.yw), (float)(-this.zw));
    protected Vector3f tempVect1 = new Vector3f(0.0f, 0.0f, 0.0f);
    protected Vector3f tempVect2 = new Vector3f(0.0f, 0.0f, 0.0f);
    protected Vector3f tempVect3 = new Vector3f(0.0f, 0.0f, 0.0f);

    public PhysicsHoverControl() {
    }

    public PhysicsHoverControl(CollisionShape shape) {
        super(shape);
        this.createWheels();
    }

    public PhysicsHoverControl(CollisionShape shape, float mass) {
        super(shape, mass);
        this.createWheels();
    }

    public Control cloneForSpatial(Spatial spatial) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setSpatial(Spatial spatial) {
        this.spatial = spatial;
        this.setUserObject(spatial);
        if (spatial == null) {
            return;
        }
        this.setPhysicsLocation(spatial.getWorldTranslation());
        this.setPhysicsRotation(spatial.getWorldRotation().toRotationMatrix());
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    private void createWheels() {
        this.addWheel(this.HOVER_HEIGHT_LF_START, new Vector3f(0.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 0.0f, 0.0f), this.yw, this.yw, false);
        this.addWheel(this.HOVER_HEIGHT_RF_START, new Vector3f(0.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 0.0f, 0.0f), this.yw, this.yw, false);
        this.addWheel(this.HOVER_HEIGHT_LR_START, new Vector3f(0.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 0.0f, 0.0f), this.yw, this.yw, false);
        this.addWheel(this.HOVER_HEIGHT_RR_START, new Vector3f(0.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 0.0f, 0.0f), this.yw, this.yw, false);
        for (int i = 0; i < 4; ++i) {
            this.getWheel(i).setFrictionSlip(0.001f);
        }
    }

    public void prePhysicsTick(PhysicsSpace space, float f) {
        Vector3f angVel = this.getAngularVelocity();
        float rotationVelocity = angVel.getY();
        Vector3f dir = this.getForwardVector(this.tempVect2).multLocal(1.0f, 0.0f, 1.0f).normalizeLocal();
        this.getLinearVelocity(this.tempVect3);
        Vector3f linearVelocity = this.tempVect3.multLocal(1.0f, 0.0f, 1.0f);
        if (this.steeringValue != 0.0f) {
            if (rotationVelocity < 1.0f && rotationVelocity > -1.0f) {
                this.applyTorque(this.tempVect1.set(0.0f, this.steeringValue, 0.0f));
            }
        } else if (rotationVelocity > 0.2f) {
            this.applyTorque(this.tempVect1.set(0.0f, -this.mass * 20.0f, 0.0f));
        } else if (rotationVelocity < -0.2f) {
            this.applyTorque(this.tempVect1.set(0.0f, this.mass * 20.0f, 0.0f));
        }
        if (this.accelerationValue > 0.0f) {
            float d = dir.dot(linearVelocity.normalize());
            Vector3f counter = dir.project(linearVelocity).normalizeLocal().negateLocal().multLocal(1.0f - d);
            this.applyForce(counter.multLocal(this.mass * 10.0f), Vector3f.ZERO);
            if (linearVelocity.length() < 30.0f) {
                this.applyForce(dir.multLocal(this.accelerationValue), Vector3f.ZERO);
            }
        } else if (linearVelocity.length() > 1.0E-4f) {
            linearVelocity.normalizeLocal().negateLocal();
            this.applyForce(linearVelocity.mult(this.mass * 10.0f), Vector3f.ZERO);
        }
    }

    public void physicsTick(PhysicsSpace space, float f) {
    }

    public void update(float tpf) {
        if (this.enabled && this.spatial != null) {
            this.getMotionState().applyTransform(this.spatial);
        }
    }

    public void render(RenderManager rm, ViewPort vp) {
        if (this.enabled && this.space != null && this.space.getDebugManager() != null) {
            if (this.debugShape == null) {
                this.attachDebugShape(this.space.getDebugManager());
            }
            this.debugShape.setLocalTranslation(this.motionState.getWorldLocation());
            this.debugShape.setLocalRotation(this.motionState.getWorldRotation());
            this.debugShape.updateLogicalState(0.0f);
            this.debugShape.updateGeometricState();
            rm.renderScene(this.debugShape, vp);
        }
    }

    public void setPhysicsSpace(PhysicsSpace space) {
        if (space == null) {
            if (this.space != null) {
                this.space.removeCollisionObject((PhysicsCollisionObject)this);
                this.space.removeTickListener((PhysicsTickListener)this);
            }
            this.space = space;
        } else {
            space.addCollisionObject((PhysicsCollisionObject)this);
            space.addTickListener((PhysicsTickListener)this);
        }
        this.space = space;
    }

    public PhysicsSpace getPhysicsSpace() {
        return this.space;
    }

    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule oc = ex.getCapsule((Savable)this);
        oc.write(this.enabled, "enabled", true);
        oc.write((Savable)this.spatial, "spatial", null);
    }

    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule ic = im.getCapsule((Savable)this);
        this.enabled = ic.readBoolean("enabled", true);
        this.spatial = (Spatial)ic.readSavable("spatial", null);
    }

    public void steer(float steeringValue) {
        this.steeringValue = steeringValue * this.getMass();
    }

    public void accelerate(float accelerationValue) {
        this.accelerationValue = accelerationValue * this.getMass();
    }
}

