/*
 * Decompiled with CFR 0.152.
 */
package jme3test.bullet;

import com.jme3.animation.AnimChannel;
import com.jme3.animation.AnimControl;
import com.jme3.animation.AnimEventListener;
import com.jme3.animation.Bone;
import com.jme3.animation.LoopMode;
import com.jme3.app.SimpleApplication;
import com.jme3.app.state.AppState;
import com.jme3.asset.TextureKey;
import com.jme3.bullet.BulletAppState;
import com.jme3.bullet.PhysicsSpace;
import com.jme3.bullet.collision.PhysicsCollisionEvent;
import com.jme3.bullet.collision.PhysicsCollisionObject;
import com.jme3.bullet.collision.RagdollCollisionListener;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.collision.shapes.SphereCollisionShape;
import com.jme3.bullet.control.KinematicRagdollControl;
import com.jme3.bullet.control.RigidBodyControl;
import com.jme3.font.BitmapText;
import com.jme3.input.controls.ActionListener;
import com.jme3.input.controls.InputListener;
import com.jme3.input.controls.KeyTrigger;
import com.jme3.input.controls.MouseButtonTrigger;
import com.jme3.input.controls.Trigger;
import com.jme3.light.DirectionalLight;
import com.jme3.light.Light;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import com.jme3.scene.debug.SkeletonDebugger;
import com.jme3.scene.shape.Sphere;
import com.jme3.texture.Texture;
import jme3test.bullet.BombControl;
import jme3test.bullet.PhysicsTestHelper;

public class TestBoneRagdoll
extends SimpleApplication
implements RagdollCollisionListener,
AnimEventListener {
    private BulletAppState bulletAppState;
    Material matBullet;
    Node model;
    KinematicRagdollControl ragdoll;
    float bulletSize = 1.0f;
    Material mat;
    Material mat3;
    private Sphere bullet;
    private SphereCollisionShape bulletCollisionShape;
    float elTime = 0.0f;
    boolean forward = true;
    AnimControl animControl;
    AnimChannel animChannel;
    Vector3f direction = new Vector3f(0.0f, 0.0f, 1.0f);
    Quaternion rotate = new Quaternion().fromAngleAxis(0.3926991f, Vector3f.UNIT_Y);
    boolean dance = true;

    public static void main(String[] args) {
        TestBoneRagdoll app = new TestBoneRagdoll();
        app.start();
    }

    public void simpleInitApp() {
        this.initCrossHairs();
        this.initMaterial();
        this.cam.setLocation(new Vector3f(0.26924422f, 6.646658f, 22.265987f));
        this.cam.setRotation(new Quaternion(-2.302544E-4f, 0.99302495f, -0.117888905f, -0.0019395084f));
        this.bulletAppState = new BulletAppState();
        this.bulletAppState.setEnabled(true);
        this.stateManager.attach((AppState)this.bulletAppState);
        this.bullet = new Sphere(32, 32, 1.0f, true, false);
        this.bullet.setTextureMode(Sphere.TextureMode.Projected);
        this.bulletCollisionShape = new SphereCollisionShape(1.0f);
        PhysicsTestHelper.createPhysicsTestWorld(this.rootNode, this.assetManager, this.bulletAppState.getPhysicsSpace());
        this.setupLight();
        this.model = (Node)this.assetManager.loadModel("Models/Sinbad/Sinbad.mesh.xml");
        AnimControl control = (AnimControl)this.model.getControl(AnimControl.class);
        SkeletonDebugger skeletonDebug = new SkeletonDebugger("skeleton", control.getSkeleton());
        Material mat2 = new Material(this.getAssetManager(), "Common/MatDefs/Misc/Unshaded.j3md");
        mat2.getAdditionalRenderState().setWireframe(true);
        mat2.setColor("Color", ColorRGBA.Green);
        mat2.getAdditionalRenderState().setDepthTest(false);
        skeletonDebug.setMaterial(mat2);
        skeletonDebug.setLocalTranslation(this.model.getLocalTranslation());
        this.ragdoll = new KinematicRagdollControl(0.5f);
        this.setupSinbad(this.ragdoll);
        this.ragdoll.addCollisionListener((RagdollCollisionListener)this);
        this.model.addControl((Control)this.ragdoll);
        float eighth_pi = 0.3926991f;
        this.ragdoll.setJointLimit("Waist", eighth_pi, eighth_pi, eighth_pi, eighth_pi, eighth_pi, eighth_pi);
        this.ragdoll.setJointLimit("Chest", eighth_pi, eighth_pi, 0.0f, 0.0f, eighth_pi, eighth_pi);
        this.getPhysicsSpace().add((Object)this.ragdoll);
        this.speed = 1.3f;
        this.rootNode.attachChild((Spatial)this.model);
        this.flyCam.setMoveSpeed(50.0f);
        this.animChannel = control.createChannel();
        this.animChannel.setAnim("Dance");
        control.addListener((AnimEventListener)this);
        this.inputManager.addListener((InputListener)new ActionListener(){

            public void onAction(String name, boolean isPressed, float tpf) {
                RigidBodyControl bulletNode;
                Geometry bulletg;
                if (name.equals("toggle") && isPressed) {
                    Vector3f v = new Vector3f();
                    v.set(TestBoneRagdoll.this.model.getLocalTranslation());
                    v.y = 0.0f;
                    TestBoneRagdoll.this.model.setLocalTranslation(v);
                    Quaternion q = new Quaternion();
                    float[] angles = new float[3];
                    TestBoneRagdoll.this.model.getLocalRotation().toAngles(angles);
                    q.fromAngleAxis(angles[1], Vector3f.UNIT_Y);
                    TestBoneRagdoll.this.model.setLocalRotation(q);
                    if (angles[0] < 0.0f) {
                        TestBoneRagdoll.this.animChannel.setAnim("StandUpBack");
                        TestBoneRagdoll.this.ragdoll.blendToKinematicMode(0.5f);
                    } else {
                        TestBoneRagdoll.this.animChannel.setAnim("StandUpFront");
                        TestBoneRagdoll.this.ragdoll.blendToKinematicMode(0.5f);
                    }
                }
                if (name.equals("bullet+") && isPressed) {
                    TestBoneRagdoll.this.bulletSize += 0.1f;
                }
                if (name.equals("bullet-") && isPressed) {
                    TestBoneRagdoll.this.bulletSize -= 0.1f;
                }
                if (name.equals("stop") && isPressed) {
                    TestBoneRagdoll.this.ragdoll.setEnabled(!TestBoneRagdoll.this.ragdoll.isEnabled());
                    TestBoneRagdoll.this.ragdoll.setRagdollMode();
                }
                if (name.equals("shoot") && !isPressed) {
                    bulletg = new Geometry("bullet", (Mesh)TestBoneRagdoll.this.bullet);
                    bulletg.setMaterial(TestBoneRagdoll.this.matBullet);
                    bulletg.setLocalTranslation(TestBoneRagdoll.this.cam.getLocation());
                    bulletg.setLocalScale(TestBoneRagdoll.this.bulletSize);
                    TestBoneRagdoll.this.bulletCollisionShape = new SphereCollisionShape(TestBoneRagdoll.this.bulletSize);
                    bulletNode = new RigidBodyControl((CollisionShape)TestBoneRagdoll.this.bulletCollisionShape, TestBoneRagdoll.this.bulletSize * 10.0f);
                    bulletNode.setCcdMotionThreshold(0.001f);
                    bulletNode.setLinearVelocity(TestBoneRagdoll.this.cam.getDirection().mult(80.0f));
                    bulletg.addControl((Control)bulletNode);
                    TestBoneRagdoll.this.rootNode.attachChild((Spatial)bulletg);
                    TestBoneRagdoll.this.getPhysicsSpace().add((Object)bulletNode);
                }
                if (name.equals("boom") && !isPressed) {
                    bulletg = new Geometry("bullet", (Mesh)TestBoneRagdoll.this.bullet);
                    bulletg.setMaterial(TestBoneRagdoll.this.matBullet);
                    bulletg.setLocalTranslation(TestBoneRagdoll.this.cam.getLocation());
                    bulletg.setLocalScale(TestBoneRagdoll.this.bulletSize);
                    TestBoneRagdoll.this.bulletCollisionShape = new SphereCollisionShape(TestBoneRagdoll.this.bulletSize);
                    bulletNode = new BombControl(TestBoneRagdoll.this.assetManager, (CollisionShape)TestBoneRagdoll.this.bulletCollisionShape, 1.0f);
                    bulletNode.setForceFactor(8.0f);
                    bulletNode.setExplosionRadius(20.0f);
                    bulletNode.setCcdMotionThreshold(0.001f);
                    bulletNode.setLinearVelocity(TestBoneRagdoll.this.cam.getDirection().mult(180.0f));
                    bulletg.addControl((Control)bulletNode);
                    TestBoneRagdoll.this.rootNode.attachChild((Spatial)bulletg);
                    TestBoneRagdoll.this.getPhysicsSpace().add((Object)bulletNode);
                }
            }
        }, new String[]{"toggle", "shoot", "stop", "bullet+", "bullet-", "boom"});
        this.inputManager.addMapping("toggle", new Trigger[]{new KeyTrigger(57)});
        this.inputManager.addMapping("shoot", new Trigger[]{new MouseButtonTrigger(0)});
        this.inputManager.addMapping("boom", new Trigger[]{new MouseButtonTrigger(1)});
        this.inputManager.addMapping("stop", new Trigger[]{new KeyTrigger(35)});
        this.inputManager.addMapping("bullet-", new Trigger[]{new KeyTrigger(51)});
        this.inputManager.addMapping("bullet+", new Trigger[]{new KeyTrigger(52)});
    }

    private void setupLight() {
        DirectionalLight dl = new DirectionalLight();
        dl.setDirection(new Vector3f(-0.1f, -0.7f, -1.0f).normalizeLocal());
        dl.setColor(new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f));
        this.rootNode.addLight((Light)dl);
    }

    private PhysicsSpace getPhysicsSpace() {
        return this.bulletAppState.getPhysicsSpace();
    }

    public void initMaterial() {
        this.matBullet = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        TextureKey key2 = new TextureKey("Textures/Terrain/Rock/Rock.PNG");
        key2.setGenerateMips(true);
        Texture tex2 = this.assetManager.loadTexture(key2);
        this.matBullet.setTexture("ColorMap", tex2);
    }

    protected void initCrossHairs() {
        this.guiFont = this.assetManager.loadFont("Interface/Fonts/Default.fnt");
        BitmapText ch = new BitmapText(this.guiFont, false);
        ch.setSize((float)(this.guiFont.getCharSet().getRenderedSize() * 2));
        ch.setText("+");
        ch.setLocalTranslation((float)(this.settings.getWidth() / 2 - this.guiFont.getCharSet().getRenderedSize() / 3 * 2), (float)(this.settings.getHeight() / 2) + ch.getLineHeight() / 2.0f, 0.0f);
        this.guiNode.attachChild((Spatial)ch);
    }

    public void collide(Bone bone, PhysicsCollisionObject object, PhysicsCollisionEvent event) {
        Geometry geom;
        if (object.getUserObject() != null && object.getUserObject() instanceof Geometry && "Floor".equals((geom = (Geometry)object.getUserObject()).getName())) {
            return;
        }
        this.ragdoll.setRagdollMode();
    }

    private void setupSinbad(KinematicRagdollControl ragdoll) {
        ragdoll.addBoneName("Ulna.L");
        ragdoll.addBoneName("Ulna.R");
        ragdoll.addBoneName("Chest");
        ragdoll.addBoneName("Foot.L");
        ragdoll.addBoneName("Foot.R");
        ragdoll.addBoneName("Hand.R");
        ragdoll.addBoneName("Hand.L");
        ragdoll.addBoneName("Neck");
        ragdoll.addBoneName("Root");
        ragdoll.addBoneName("Stomach");
        ragdoll.addBoneName("Waist");
        ragdoll.addBoneName("Humerus.L");
        ragdoll.addBoneName("Humerus.R");
        ragdoll.addBoneName("Thigh.L");
        ragdoll.addBoneName("Thigh.R");
        ragdoll.addBoneName("Calf.L");
        ragdoll.addBoneName("Calf.R");
        ragdoll.addBoneName("Clavicle.L");
        ragdoll.addBoneName("Clavicle.R");
    }

    public void simpleUpdate(float tpf) {
    }

    public void onAnimCycleDone(AnimControl control, AnimChannel channel, String animName) {
        if (channel.getAnimationName().equals("StandUpBack") || channel.getAnimationName().equals("StandUpFront")) {
            channel.setLoopMode(LoopMode.DontLoop);
            channel.setAnim("IdleTop", 5.0f);
            channel.setLoopMode(LoopMode.Loop);
        }
    }

    public void onAnimChange(AnimControl control, AnimChannel channel, String animName) {
    }
}

