/*
 * Decompiled with CFR 0.152.
 */
package jme3test.bullet;

import com.jme3.app.SimpleApplication;
import com.jme3.app.state.AppState;
import com.jme3.asset.TextureKey;
import com.jme3.bullet.BulletAppState;
import com.jme3.bullet.PhysicsSpace;
import com.jme3.bullet.collision.shapes.BoxCollisionShape;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.collision.shapes.SphereCollisionShape;
import com.jme3.bullet.control.RigidBodyControl;
import com.jme3.font.BitmapText;
import com.jme3.input.controls.ActionListener;
import com.jme3.input.controls.InputListener;
import com.jme3.input.controls.KeyTrigger;
import com.jme3.input.controls.MouseButtonTrigger;
import com.jme3.input.controls.Trigger;
import com.jme3.material.Material;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.post.SceneProcessor;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import com.jme3.scene.shape.Box;
import com.jme3.scene.shape.Sphere;
import com.jme3.shadow.BasicShadowRenderer;
import com.jme3.texture.Texture;
import jme3test.bullet.BombControl;

public class TestBrickWall
extends SimpleApplication {
    static float bLength = 0.48f;
    static float bWidth = 0.24f;
    static float bHeight = 0.12f;
    Material mat;
    Material mat2;
    Material mat3;
    BasicShadowRenderer bsr;
    private static Sphere bullet;
    private static Box brick;
    private static SphereCollisionShape bulletCollisionShape;
    private BulletAppState bulletAppState;
    private ActionListener actionListener = new ActionListener(){

        public void onAction(String name, boolean keyPressed, float tpf) {
            if (name.equals("shoot") && !keyPressed) {
                Geometry bulletg = new Geometry("bullet", (Mesh)bullet);
                bulletg.setMaterial(TestBrickWall.this.mat2);
                bulletg.setShadowMode(RenderQueue.ShadowMode.CastAndReceive);
                bulletg.setLocalTranslation(TestBrickWall.this.cam.getLocation());
                SphereCollisionShape bulletCollisionShape = new SphereCollisionShape(0.4f);
                BombControl bulletNode = new BombControl(TestBrickWall.this.assetManager, (CollisionShape)bulletCollisionShape, 1.0f);
                bulletNode.setLinearVelocity(TestBrickWall.this.cam.getDirection().mult(25.0f));
                bulletg.addControl((Control)bulletNode);
                TestBrickWall.this.rootNode.attachChild((Spatial)bulletg);
                TestBrickWall.this.getPhysicsSpace().add((Object)bulletNode);
            }
            if (name.equals("gc") && !keyPressed) {
                System.gc();
            }
        }
    };

    public static void main(String[] args) {
        TestBrickWall f = new TestBrickWall();
        f.start();
    }

    public void simpleInitApp() {
        this.bulletAppState = new BulletAppState();
        this.bulletAppState.setThreadingType(BulletAppState.ThreadingType.PARALLEL);
        this.stateManager.attach((AppState)this.bulletAppState);
        bullet = new Sphere(32, 32, 0.4f, true, false);
        bullet.setTextureMode(Sphere.TextureMode.Projected);
        bulletCollisionShape = new SphereCollisionShape(0.4f);
        brick = new Box(Vector3f.ZERO, bLength, bHeight, bWidth);
        brick.scaleTextureCoordinates(new Vector2f(1.0f, 0.5f));
        this.initMaterial();
        this.initWall();
        this.initFloor();
        this.initCrossHairs();
        this.cam.setLocation(new Vector3f(0.0f, 6.0f, 6.0f));
        this.cam.lookAt(Vector3f.ZERO, new Vector3f(0.0f, 1.0f, 0.0f));
        this.cam.setFrustumFar(15.0f);
        this.inputManager.addMapping("shoot", new Trigger[]{new MouseButtonTrigger(0)});
        this.inputManager.addListener((InputListener)this.actionListener, new String[]{"shoot"});
        this.inputManager.addMapping("gc", new Trigger[]{new KeyTrigger(45)});
        this.inputManager.addListener((InputListener)this.actionListener, new String[]{"gc"});
        this.rootNode.setShadowMode(RenderQueue.ShadowMode.Off);
        this.bsr = new BasicShadowRenderer(this.assetManager, 256);
        this.bsr.setDirection(new Vector3f(-1.0f, -1.0f, -1.0f).normalizeLocal());
        this.viewPort.addProcessor((SceneProcessor)this.bsr);
    }

    private PhysicsSpace getPhysicsSpace() {
        return this.bulletAppState.getPhysicsSpace();
    }

    public void initWall() {
        float startpt = bLength / 4.0f;
        float height = 0.0f;
        for (int j = 0; j < 15; ++j) {
            for (int i = 0; i < 4; ++i) {
                Vector3f vt = new Vector3f((float)i * bLength * 2.0f + startpt, bHeight + height, 0.0f);
                this.addBrick(vt);
            }
            startpt = -startpt;
            height += 2.0f * bHeight;
        }
    }

    public void initFloor() {
        Box floorBox = new Box(Vector3f.ZERO, 10.0f, 0.1f, 5.0f);
        floorBox.scaleTextureCoordinates(new Vector2f(3.0f, 6.0f));
        Geometry floor = new Geometry("floor", (Mesh)floorBox);
        floor.setMaterial(this.mat3);
        floor.setShadowMode(RenderQueue.ShadowMode.Receive);
        floor.setLocalTranslation(0.0f, -0.1f, 0.0f);
        floor.addControl((Control)new RigidBodyControl((CollisionShape)new BoxCollisionShape(new Vector3f(10.0f, 0.1f, 5.0f)), 0.0f));
        this.rootNode.attachChild((Spatial)floor);
        this.getPhysicsSpace().add((Object)floor);
    }

    public void initMaterial() {
        this.mat = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        TextureKey key = new TextureKey("Textures/Terrain/BrickWall/BrickWall.jpg");
        key.setGenerateMips(true);
        Texture tex = this.assetManager.loadTexture(key);
        this.mat.setTexture("ColorMap", tex);
        this.mat2 = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        TextureKey key2 = new TextureKey("Textures/Terrain/Rock/Rock.PNG");
        key2.setGenerateMips(true);
        Texture tex2 = this.assetManager.loadTexture(key2);
        this.mat2.setTexture("ColorMap", tex2);
        this.mat3 = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        TextureKey key3 = new TextureKey("Textures/Terrain/Pond/Pond.jpg");
        key3.setGenerateMips(true);
        Texture tex3 = this.assetManager.loadTexture(key3);
        tex3.setWrap(Texture.WrapMode.Repeat);
        this.mat3.setTexture("ColorMap", tex3);
    }

    public void addBrick(Vector3f ori) {
        Geometry reBoxg = new Geometry("brick", (Mesh)brick);
        reBoxg.setMaterial(this.mat);
        reBoxg.setLocalTranslation(ori);
        reBoxg.addControl((Control)new RigidBodyControl(1.5f));
        reBoxg.setShadowMode(RenderQueue.ShadowMode.CastAndReceive);
        ((RigidBodyControl)reBoxg.getControl(RigidBodyControl.class)).setFriction(0.6f);
        this.rootNode.attachChild((Spatial)reBoxg);
        this.getPhysicsSpace().add((Object)reBoxg);
    }

    protected void initCrossHairs() {
        this.guiFont = this.assetManager.loadFont("Interface/Fonts/Default.fnt");
        BitmapText ch = new BitmapText(this.guiFont, false);
        ch.setSize((float)(this.guiFont.getCharSet().getRenderedSize() * 2));
        ch.setText("+");
        ch.setLocalTranslation((float)(this.settings.getWidth() / 2 - this.guiFont.getCharSet().getRenderedSize() / 3 * 2), (float)(this.settings.getHeight() / 2) + ch.getLineHeight() / 2.0f, 0.0f);
        this.guiNode.attachChild((Spatial)ch);
    }
}

