/*
 * Decompiled with CFR 0.152.
 */
package jme3test.bullet;

import com.jme3.app.SimpleApplication;
import com.jme3.app.state.AppState;
import com.jme3.bullet.BulletAppState;
import com.jme3.bullet.PhysicsSpace;
import com.jme3.bullet.collision.shapes.BoxCollisionShape;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.collision.shapes.CompoundCollisionShape;
import com.jme3.bullet.control.VehicleControl;
import com.jme3.input.controls.ActionListener;
import com.jme3.input.controls.InputListener;
import com.jme3.input.controls.KeyTrigger;
import com.jme3.input.controls.Trigger;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.FastMath;
import com.jme3.math.Matrix3f;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import com.jme3.scene.shape.Cylinder;
import jme3test.bullet.PhysicsTestHelper;

public class TestPhysicsCar
extends SimpleApplication
implements ActionListener {
    private BulletAppState bulletAppState;
    private VehicleControl vehicle;
    private final float accelerationForce = 1000.0f;
    private final float brakeForce = 100.0f;
    private float steeringValue = 0.0f;
    private float accelerationValue = 0.0f;
    private Vector3f jumpForce = new Vector3f(0.0f, 3000.0f, 0.0f);

    public static void main(String[] args) {
        TestPhysicsCar app = new TestPhysicsCar();
        app.start();
    }

    public void simpleInitApp() {
        this.bulletAppState = new BulletAppState();
        this.stateManager.attach((AppState)this.bulletAppState);
        this.bulletAppState.getPhysicsSpace().enableDebug(this.assetManager);
        PhysicsTestHelper.createPhysicsTestWorld(this.rootNode, this.assetManager, this.bulletAppState.getPhysicsSpace());
        this.setupKeys();
        this.buildPlayer();
    }

    private PhysicsSpace getPhysicsSpace() {
        return this.bulletAppState.getPhysicsSpace();
    }

    private void setupKeys() {
        this.inputManager.addMapping("Lefts", new Trigger[]{new KeyTrigger(35)});
        this.inputManager.addMapping("Rights", new Trigger[]{new KeyTrigger(37)});
        this.inputManager.addMapping("Ups", new Trigger[]{new KeyTrigger(22)});
        this.inputManager.addMapping("Downs", new Trigger[]{new KeyTrigger(36)});
        this.inputManager.addMapping("Space", new Trigger[]{new KeyTrigger(57)});
        this.inputManager.addMapping("Reset", new Trigger[]{new KeyTrigger(28)});
        this.inputManager.addListener((InputListener)this, new String[]{"Lefts"});
        this.inputManager.addListener((InputListener)this, new String[]{"Rights"});
        this.inputManager.addListener((InputListener)this, new String[]{"Ups"});
        this.inputManager.addListener((InputListener)this, new String[]{"Downs"});
        this.inputManager.addListener((InputListener)this, new String[]{"Space"});
        this.inputManager.addListener((InputListener)this, new String[]{"Reset"});
    }

    private void buildPlayer() {
        Material mat = new Material(this.getAssetManager(), "Common/MatDefs/Misc/Unshaded.j3md");
        mat.getAdditionalRenderState().setWireframe(true);
        mat.setColor("Color", ColorRGBA.Red);
        CompoundCollisionShape compoundShape = new CompoundCollisionShape();
        BoxCollisionShape box = new BoxCollisionShape(new Vector3f(1.2f, 0.5f, 2.4f));
        compoundShape.addChildShape((CollisionShape)box, new Vector3f(0.0f, 1.0f, 0.0f));
        Node vehicleNode = new Node("vehicleNode");
        this.vehicle = new VehicleControl((CollisionShape)compoundShape, 400.0f);
        vehicleNode.addControl((Control)this.vehicle);
        float stiffness = 60.0f;
        float compValue = 0.3f;
        float dampValue = 0.4f;
        this.vehicle.setSuspensionCompression(compValue * 2.0f * FastMath.sqrt((float)stiffness));
        this.vehicle.setSuspensionDamping(dampValue * 2.0f * FastMath.sqrt((float)stiffness));
        this.vehicle.setSuspensionStiffness(stiffness);
        this.vehicle.setMaxSuspensionForce(10000.0f);
        Vector3f wheelDirection = new Vector3f(0.0f, -1.0f, 0.0f);
        Vector3f wheelAxle = new Vector3f(-1.0f, 0.0f, 0.0f);
        float radius = 0.5f;
        float restLength = 0.3f;
        float yOff = 0.5f;
        float xOff = 1.0f;
        float zOff = 2.0f;
        Cylinder wheelMesh = new Cylinder(16, 16, radius, radius * 0.6f, true);
        Node node1 = new Node("wheel 1 node");
        Geometry wheels1 = new Geometry("wheel 1", (Mesh)wheelMesh);
        node1.attachChild((Spatial)wheels1);
        wheels1.rotate(0.0f, 1.5707964f, 0.0f);
        wheels1.setMaterial(mat);
        this.vehicle.addWheel((Spatial)node1, new Vector3f(-xOff, yOff, zOff), wheelDirection, wheelAxle, restLength, radius, true);
        Node node2 = new Node("wheel 2 node");
        Geometry wheels2 = new Geometry("wheel 2", (Mesh)wheelMesh);
        node2.attachChild((Spatial)wheels2);
        wheels2.rotate(0.0f, 1.5707964f, 0.0f);
        wheels2.setMaterial(mat);
        this.vehicle.addWheel((Spatial)node2, new Vector3f(xOff, yOff, zOff), wheelDirection, wheelAxle, restLength, radius, true);
        Node node3 = new Node("wheel 3 node");
        Geometry wheels3 = new Geometry("wheel 3", (Mesh)wheelMesh);
        node3.attachChild((Spatial)wheels3);
        wheels3.rotate(0.0f, 1.5707964f, 0.0f);
        wheels3.setMaterial(mat);
        this.vehicle.addWheel((Spatial)node3, new Vector3f(-xOff, yOff, -zOff), wheelDirection, wheelAxle, restLength, radius, false);
        Node node4 = new Node("wheel 4 node");
        Geometry wheels4 = new Geometry("wheel 4", (Mesh)wheelMesh);
        node4.attachChild((Spatial)wheels4);
        wheels4.rotate(0.0f, 1.5707964f, 0.0f);
        wheels4.setMaterial(mat);
        this.vehicle.addWheel((Spatial)node4, new Vector3f(xOff, yOff, -zOff), wheelDirection, wheelAxle, restLength, radius, false);
        vehicleNode.attachChild((Spatial)node1);
        vehicleNode.attachChild((Spatial)node2);
        vehicleNode.attachChild((Spatial)node3);
        vehicleNode.attachChild((Spatial)node4);
        this.rootNode.attachChild((Spatial)vehicleNode);
        this.getPhysicsSpace().add((Object)this.vehicle);
    }

    public void simpleUpdate(float tpf) {
        this.cam.lookAt(this.vehicle.getPhysicsLocation(), Vector3f.UNIT_Y);
    }

    public void onAction(String binding, boolean value, float tpf) {
        if (binding.equals("Lefts")) {
            this.steeringValue = value ? (this.steeringValue += 0.5f) : (this.steeringValue += -0.5f);
            this.vehicle.steer(this.steeringValue);
        } else if (binding.equals("Rights")) {
            this.steeringValue = value ? (this.steeringValue += -0.5f) : (this.steeringValue += 0.5f);
            this.vehicle.steer(this.steeringValue);
        } else if (binding.equals("Ups")) {
            this.accelerationValue = value ? (this.accelerationValue += 1000.0f) : (this.accelerationValue -= 1000.0f);
            this.vehicle.accelerate(this.accelerationValue);
        } else if (binding.equals("Downs")) {
            if (value) {
                this.vehicle.brake(100.0f);
            } else {
                this.vehicle.brake(0.0f);
            }
        } else if (binding.equals("Space")) {
            if (value) {
                this.vehicle.applyImpulse(this.jumpForce, Vector3f.ZERO);
            }
        } else if (binding.equals("Reset") && value) {
            System.out.println("Reset");
            this.vehicle.setPhysicsLocation(Vector3f.ZERO);
            this.vehicle.setPhysicsRotation(new Matrix3f());
            this.vehicle.setLinearVelocity(Vector3f.ZERO);
            this.vehicle.setAngularVelocity(Vector3f.ZERO);
            this.vehicle.resetSuspension();
        }
    }
}

