/*
 * Decompiled with CFR 0.152.
 */
package jme3test.collision;

import com.jme3.collision.Collidable;
import com.jme3.collision.CollisionResults;
import com.jme3.math.Ray;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.scene.Spatial;
import java.awt.FlowLayout;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class RayTrace {
    private BufferedImage image;
    private Camera cam;
    private Spatial scene;
    private CollisionResults results = new CollisionResults();
    private JFrame frame;
    private JLabel label;

    public RayTrace(Spatial scene, Camera cam, int width, int height) {
        this.image = new BufferedImage(width, height, 2);
        this.scene = scene;
        this.cam = cam;
    }

    public void show() {
        this.frame = new JFrame("HDR View");
        this.label = new JLabel(new ImageIcon(this.image));
        this.frame.getContentPane().add(this.label);
        this.frame.setLayout(new FlowLayout());
        this.frame.pack();
        this.frame.setVisible(true);
    }

    public void update() {
        int w = this.image.getWidth();
        int h = this.image.getHeight();
        float wr = (float)this.cam.getWidth() / (float)this.image.getWidth();
        float hr = (float)this.cam.getHeight() / (float)this.image.getHeight();
        this.scene.updateGeometricState();
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                Vector2f v = new Vector2f((float)x * wr, (float)y * hr);
                Vector3f pos = this.cam.getWorldCoordinates(v, 0.0f);
                Vector3f dir = this.cam.getWorldCoordinates(v, 0.3f);
                dir.subtractLocal(pos).normalizeLocal();
                Ray r = new Ray(pos, dir);
                this.results.clear();
                this.scene.collideWith((Collidable)r, this.results);
                if (this.results.size() > 0) {
                    this.image.setRGB(x, h - y - 1, -1);
                    continue;
                }
                this.image.setRGB(x, h - y - 1, -16777216);
            }
        }
        this.label.repaint();
    }
}

