/*
 * Decompiled with CFR 0.152.
 */
package jme3test.collision;

import com.jme3.app.SimpleApplication;
import com.jme3.collision.Collidable;
import com.jme3.collision.CollisionResult;
import com.jme3.collision.CollisionResults;
import com.jme3.light.DirectionalLight;
import com.jme3.light.Light;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Quaternion;
import com.jme3.math.Ray;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.debug.Arrow;
import com.jme3.scene.shape.Box;

public class TestMousePick
extends SimpleApplication {
    Node shootables;
    Geometry mark;

    public static void main(String[] args) {
        TestMousePick app = new TestMousePick();
        app.start();
    }

    public void simpleInitApp() {
        this.flyCam.setEnabled(false);
        this.initMark();
        this.shootables = new Node("Shootables");
        this.rootNode.attachChild((Spatial)this.shootables);
        this.shootables.attachChild((Spatial)this.makeCube("a Dragon", -2.0f, 0.0f, 1.0f));
        this.shootables.attachChild((Spatial)this.makeCube("a tin can", 1.0f, -2.0f, 0.0f));
        this.shootables.attachChild((Spatial)this.makeCube("the Sheriff", 0.0f, 1.0f, -2.0f));
        this.shootables.attachChild((Spatial)this.makeCube("the Deputy", 1.0f, 0.0f, -4.0f));
        this.shootables.attachChild((Spatial)this.makeFloor());
        this.shootables.attachChild(this.makeCharacter());
    }

    public void simpleUpdate(float tpf) {
        Vector3f origin = this.cam.getWorldCoordinates(this.inputManager.getCursorPosition(), 0.0f);
        Vector3f direction = this.cam.getWorldCoordinates(this.inputManager.getCursorPosition(), 0.3f);
        direction.subtractLocal(origin).normalizeLocal();
        Ray ray = new Ray(origin, direction);
        CollisionResults results = new CollisionResults();
        this.shootables.collideWith((Collidable)ray, results);
        if (results.size() > 0) {
            CollisionResult closest = results.getClosestCollision();
            this.mark.setLocalTranslation(closest.getContactPoint());
            Quaternion q = new Quaternion();
            q.lookAt(closest.getContactNormal(), Vector3f.UNIT_Y);
            this.mark.setLocalRotation(q);
            this.rootNode.attachChild((Spatial)this.mark);
        } else {
            this.rootNode.detachChild((Spatial)this.mark);
        }
    }

    protected Geometry makeCube(String name, float x, float y, float z) {
        Box box = new Box(new Vector3f(x, y, z), 1.0f, 1.0f, 1.0f);
        Geometry cube = new Geometry(name, (Mesh)box);
        Material mat1 = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        mat1.setColor("Color", ColorRGBA.randomColor());
        cube.setMaterial(mat1);
        return cube;
    }

    protected Geometry makeFloor() {
        Box box = new Box(new Vector3f(0.0f, -4.0f, -5.0f), 15.0f, 0.2f, 15.0f);
        Geometry floor = new Geometry("the Floor", (Mesh)box);
        Material mat1 = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        mat1.setColor("Color", ColorRGBA.Gray);
        floor.setMaterial(mat1);
        return floor;
    }

    protected void initMark() {
        Arrow arrow = new Arrow(Vector3f.UNIT_Z.mult(2.0f));
        arrow.setLineWidth(3.0f);
        this.mark = new Geometry("BOOM!", (Mesh)arrow);
        Material mark_mat = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        mark_mat.setColor("Color", ColorRGBA.Red);
        this.mark.setMaterial(mark_mat);
    }

    protected Spatial makeCharacter() {
        Spatial golem = this.assetManager.loadModel("Models/Oto/Oto.mesh.xml");
        golem.scale(0.5f);
        golem.setLocalTranslation(-1.0f, -1.5f, -0.6f);
        DirectionalLight sun = new DirectionalLight();
        sun.setDirection(new Vector3f(-0.1f, -0.7f, -1.0f).normalizeLocal());
        golem.addLight((Light)sun);
        return golem;
    }
}

