/*
 * Decompiled with CFR 0.152.
 */
package jme3test.effect;

import com.jme3.app.SimpleApplication;
import com.jme3.asset.AssetManager;
import com.jme3.light.DirectionalLight;
import com.jme3.light.Light;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.post.HDRRenderer;
import com.jme3.post.SceneProcessor;
import com.jme3.renderer.Caps;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Box;
import com.jme3.shadow.BasicShadowRenderer;
import com.jme3.texture.Texture;
import com.jme3.util.SkyFactory;
import com.jme3.util.TangentBinormalGenerator;

public class TestEverything
extends SimpleApplication {
    private BasicShadowRenderer bsr;
    private HDRRenderer hdrRender;
    private Vector3f lightDir = new Vector3f(-1.0f, -1.0f, 0.5f).normalizeLocal();

    public static void main(String[] args) {
        TestEverything app = new TestEverything();
        app.start();
    }

    public void setupHdr() {
        if (this.renderer.getCaps().contains(Caps.GLSL100)) {
            this.hdrRender = new HDRRenderer(this.assetManager, this.renderer);
            this.hdrRender.setMaxIterations(40);
            this.hdrRender.setSamples(this.settings.getSamples());
            this.hdrRender.setWhiteLevel(3.0f);
            this.hdrRender.setExposure(0.72f);
            this.hdrRender.setThrottle(1.0f);
            this.viewPort.addProcessor((SceneProcessor)this.hdrRender);
        }
    }

    public void setupBasicShadow() {
        if (this.renderer.getCaps().contains(Caps.GLSL100)) {
            this.bsr = new BasicShadowRenderer(this.assetManager, 1024);
            this.bsr.setDirection(this.lightDir);
            this.viewPort.addProcessor((SceneProcessor)this.bsr);
        }
    }

    public void setupSkyBox() {
        Texture envMap = this.renderer.getCaps().contains(Caps.FloatTexture) ? this.assetManager.loadTexture("Textures/Sky/St Peters/StPeters.hdr") : this.assetManager.loadTexture("Textures/Sky/St Peters/StPeters.jpg");
        this.rootNode.attachChild(SkyFactory.createSky((AssetManager)this.assetManager, (Texture)envMap, (Vector3f)new Vector3f(-1.0f, -1.0f, -1.0f), (boolean)true));
    }

    public void setupLighting() {
        boolean hdr = false;
        if (this.hdrRender != null) {
            hdr = this.hdrRender.isEnabled();
        }
        DirectionalLight dl = new DirectionalLight();
        dl.setDirection(this.lightDir);
        if (hdr) {
            dl.setColor(new ColorRGBA(3.0f, 3.0f, 3.0f, 1.0f));
        } else {
            dl.setColor(new ColorRGBA(0.9f, 0.9f, 0.9f, 1.0f));
        }
        this.rootNode.addLight((Light)dl);
        dl = new DirectionalLight();
        dl.setDirection(new Vector3f(1.0f, 0.0f, -1.0f).normalizeLocal());
        if (hdr) {
            dl.setColor(new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f));
        } else {
            dl.setColor(new ColorRGBA(0.4f, 0.4f, 0.4f, 1.0f));
        }
        this.rootNode.addLight((Light)dl);
    }

    public void setupFloor() {
        Material mat = this.assetManager.loadMaterial("Textures/Terrain/BrickWall/BrickWall.j3m");
        mat.getTextureParam("DiffuseMap").getTextureValue().setWrap(Texture.WrapMode.Repeat);
        mat.getTextureParam("NormalMap").getTextureValue().setWrap(Texture.WrapMode.Repeat);
        mat.getTextureParam("ParallaxMap").getTextureValue().setWrap(Texture.WrapMode.Repeat);
        Box floor = new Box(Vector3f.ZERO, 50.0f, 1.0f, 50.0f);
        TangentBinormalGenerator.generate((Mesh)floor);
        floor.scaleTextureCoordinates(new Vector2f(5.0f, 5.0f));
        Geometry floorGeom = new Geometry("Floor", (Mesh)floor);
        floorGeom.setMaterial(mat);
        floorGeom.setShadowMode(RenderQueue.ShadowMode.Receive);
        this.rootNode.attachChild((Spatial)floorGeom);
    }

    public void setupRobotGuy() {
        Node model = (Node)this.assetManager.loadModel("Models/Oto/Oto.mesh.xml");
        Material mat = this.assetManager.loadMaterial("Models/Oto/Oto.j3m");
        model.getChild(0).setMaterial(mat);
        model.setLocalTranslation(30.0f, 10.5f, 30.0f);
        model.setLocalScale(2.0f);
        model.setShadowMode(RenderQueue.ShadowMode.CastAndReceive);
        this.rootNode.attachChild((Spatial)model);
    }

    public void setupSignpost() {
        Spatial signpost = this.assetManager.loadModel("Models/Sign Post/Sign Post.mesh.xml");
        Material mat = this.assetManager.loadMaterial("Models/Sign Post/Sign Post.j3m");
        signpost.setMaterial(mat);
        signpost.rotate(0.0f, 1.5707964f, 0.0f);
        signpost.setLocalTranslation(12.0f, 3.5f, 30.0f);
        signpost.setLocalScale(4.0f);
        signpost.setShadowMode(RenderQueue.ShadowMode.CastAndReceive);
        this.rootNode.attachChild(signpost);
    }

    public void simpleInitApp() {
        this.cam.setLocation(new Vector3f(-32.295086f, 54.80136f, 79.59805f));
        this.cam.setRotation(new Quaternion(0.074364014f, 0.92519957f, -0.24794696f, 0.27748522f));
        this.cam.update();
        this.cam.setFrustumFar(300.0f);
        this.flyCam.setMoveSpeed(30.0f);
        this.rootNode.setCullHint(Spatial.CullHint.Never);
        this.setupBasicShadow();
        this.setupHdr();
        this.setupLighting();
        this.setupSkyBox();
        this.setupFloor();
        this.setupSignpost();
    }
}

