/*
 * Decompiled with CFR 0.152.
 */
package jme3test.input.combomoves;

import java.util.Arrays;
import java.util.HashSet;
import jme3test.input.combomoves.ComboMove;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComboMoveExecution {
    private static final float TIME_LIMIT = 0.3f;
    private ComboMove moveDef;
    private int state;
    private float moveTime;
    private boolean finalState = false;
    private String debugString = "";

    public ComboMoveExecution(ComboMove move) {
        this.moveDef = move;
    }

    private boolean isStateSatisfied(HashSet<String> pressedMappings, float time, ComboMove.ComboMoveState state) {
        if (state.getTimeElapsed() != -1.0f && this.moveTime + state.getTimeElapsed() >= time) {
            return false;
        }
        for (String mapping : state.getPressedMappings()) {
            if (pressedMappings.contains(mapping)) continue;
            return false;
        }
        for (String mapping : state.getUnpressedMappings()) {
            if (!pressedMappings.contains(mapping)) continue;
            return false;
        }
        return true;
    }

    public String getDebugString() {
        return this.debugString;
    }

    public void updateExpiration(float time) {
        if (!this.finalState && this.moveTime > 0.0f && this.moveTime + 0.3f < time) {
            this.state = 0;
            this.moveTime = 0.0f;
            this.finalState = false;
            this.debugString = "";
        }
    }

    public boolean updateState(HashSet<String> pressedMappings, float time) {
        ComboMove.ComboMoveState currentState = this.moveDef.getState(this.state);
        if (this.isStateSatisfied(pressedMappings, time, currentState)) {
            ++this.state;
            this.moveTime = time;
            if (this.state >= this.moveDef.getNumStates()) {
                this.finalState = false;
                this.state = 0;
                this.moveTime = time + 0.5f;
                this.debugString = this.debugString + ", -CASTING " + this.moveDef.getMoveName().toUpperCase() + "-";
                return true;
            }
            if (currentState.getPressedMappings().length > 0) {
                if (!this.debugString.equals("")) {
                    this.debugString = this.debugString + ", ";
                }
                this.debugString = this.debugString + Arrays.toString(currentState.getPressedMappings()).replace(", ", "+");
            }
            if (this.moveDef.useFinalState() && this.state == this.moveDef.getNumStates() - 1) {
                this.finalState = true;
            }
        }
        return false;
    }
}

