/*
 * Decompiled with CFR 0.152.
 */
package jme3test.light;

import com.jme3.app.SimpleApplication;
import com.jme3.asset.AssetManager;
import com.jme3.asset.TextureKey;
import com.jme3.input.ChaseCamera;
import com.jme3.material.Material;
import com.jme3.math.Vector3f;
import com.jme3.post.Filter;
import com.jme3.post.FilterPostProcessor;
import com.jme3.post.SceneProcessor;
import com.jme3.post.filters.BloomFilter;
import com.jme3.scene.Geometry;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import com.jme3.texture.Texture;
import com.jme3.util.SkyFactory;

public class TestEnvironmentMapping
extends SimpleApplication {
    public static void main(String[] args) {
        TestEnvironmentMapping app = new TestEnvironmentMapping();
        app.start();
    }

    public void simpleInitApp() {
        Node buggy = (Node)this.assetManager.loadModel("Models/Buggy/Buggy.j3o");
        TextureKey key = new TextureKey("Textures/Sky/Bright/BrightSky.dds", true);
        key.setGenerateMips(true);
        key.setAsCube(true);
        Texture tex = this.assetManager.loadTexture(key);
        for (Spatial geom : buggy.getChildren()) {
            if (!(geom instanceof Geometry)) continue;
            Material m = ((Geometry)geom).getMaterial();
            m.setTexture("EnvMap", tex);
            m.setVector3("FresnelParams", new Vector3f(0.05f, 0.18f, 0.11f));
        }
        this.flyCam.setEnabled(false);
        ChaseCamera chaseCam = new ChaseCamera(this.cam, this.inputManager);
        chaseCam.setLookAtOffset(new Vector3f(0.0f, 0.5f, -1.0f));
        buggy.addControl((Control)chaseCam);
        this.rootNode.attachChild((Spatial)buggy);
        this.rootNode.attachChild(SkyFactory.createSky((AssetManager)this.assetManager, (Texture)tex, (boolean)false));
        FilterPostProcessor fpp = new FilterPostProcessor(this.assetManager);
        BloomFilter bf = new BloomFilter(BloomFilter.GlowMode.Objects);
        bf.setBloomIntensity(2.3f);
        bf.setExposurePower(0.6f);
        fpp.addFilter((Filter)bf);
        this.viewPort.addProcessor((SceneProcessor)fpp);
    }
}

