/*
 * Decompiled with CFR 0.152.
 */
package jme3test.light;

import com.jme3.app.SimpleApplication;
import com.jme3.light.AmbientLight;
import com.jme3.light.Light;
import com.jme3.light.SpotLight;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.FastMath;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Box;
import com.jme3.scene.shape.Sphere;
import com.jme3.texture.Texture;
import com.jme3.util.TangentBinormalGenerator;

public class TestSpotLight
extends SimpleApplication {
    private Vector3f lightTarget = new Vector3f(12.0f, 3.5f, 30.0f);
    SpotLight spot;
    Geometry lightMdl;
    float angle;

    public static void main(String[] args) {
        TestSpotLight app = new TestSpotLight();
        app.start();
    }

    public void setupLighting() {
        AmbientLight al = new AmbientLight();
        al.setColor(ColorRGBA.White.mult(0.8f));
        this.rootNode.addLight((Light)al);
        this.spot = new SpotLight();
        this.spot.setSpotRange(1000.0f);
        this.spot.setSpotInnerAngle(0.08726646f);
        this.spot.setSpotOuterAngle(0.17453292f);
        this.spot.setPosition(new Vector3f(77.70334f, 34.013165f, 27.1017f));
        this.spot.setDirection(this.lightTarget.subtract(this.spot.getPosition()));
        this.spot.setColor(ColorRGBA.White.mult(2.0f));
        this.rootNode.addLight((Light)this.spot);
        this.lightMdl = new Geometry("Light", (Mesh)new Sphere(10, 10, 0.1f));
        this.lightMdl.setMaterial(this.assetManager.loadMaterial("Common/Materials/RedColor.j3m"));
        this.lightMdl.setLocalTranslation(new Vector3f(77.70334f, 34.013165f, 27.1017f));
        this.lightMdl.setLocalScale(5.0f);
        this.rootNode.attachChild((Spatial)this.lightMdl);
    }

    public void setupFloor() {
        Material mat = this.assetManager.loadMaterial("Textures/Terrain/Pond/Pond.j3m");
        mat.getTextureParam("DiffuseMap").getTextureValue().setWrap(Texture.WrapMode.Repeat);
        mat.getTextureParam("NormalMap").getTextureValue().setWrap(Texture.WrapMode.Repeat);
        mat.setFloat("Shininess", 3.0f);
        Box floor = new Box(Vector3f.ZERO, 50.0f, 1.0f, 50.0f);
        TangentBinormalGenerator.generate((Mesh)floor);
        floor.scaleTextureCoordinates(new Vector2f(5.0f, 5.0f));
        Geometry floorGeom = new Geometry("Floor", (Mesh)floor);
        floorGeom.setMaterial(mat);
        floorGeom.setShadowMode(RenderQueue.ShadowMode.Receive);
        this.rootNode.attachChild((Spatial)floorGeom);
    }

    public void setupSignpost() {
        Spatial signpost = this.assetManager.loadModel("Models/Sign Post/Sign Post.mesh.xml");
        Material mat = this.assetManager.loadMaterial("Models/Sign Post/Sign Post.j3m");
        signpost.setMaterial(mat);
        signpost.rotate(0.0f, 1.5707964f, 0.0f);
        signpost.setLocalTranslation(12.0f, 3.5f, 30.0f);
        signpost.setLocalScale(4.0f);
        signpost.setShadowMode(RenderQueue.ShadowMode.CastAndReceive);
        TangentBinormalGenerator.generate((Spatial)signpost);
        this.rootNode.attachChild(signpost);
    }

    public void simpleInitApp() {
        this.cam.setLocation(new Vector3f(27.492603f, 29.138166f, -13.232513f));
        this.cam.setRotation(new Quaternion(0.25168246f, -0.10547892f, 0.02760565f, 0.96164864f));
        this.flyCam.setMoveSpeed(30.0f);
        this.setupLighting();
        this.setupFloor();
        this.setupSignpost();
    }

    public void simpleUpdate(float tpf) {
        super.simpleUpdate(tpf);
        this.angle += tpf;
        this.angle %= (float)Math.PI * 2;
        this.spot.setPosition(new Vector3f(FastMath.cos((float)this.angle) * 30.0f, 34.013165f, FastMath.sin((float)this.angle) * 30.0f));
        this.lightMdl.setLocalTranslation(this.spot.getPosition());
        this.spot.setDirection(this.lightTarget.subtract(this.spot.getPosition()));
    }
}

