/*
 * Decompiled with CFR 0.152.
 */
package jme3test.material;

import com.jme3.app.SimpleApplication;
import com.jme3.asset.AssetManager;
import com.jme3.input.controls.ActionListener;
import com.jme3.input.controls.AnalogListener;
import com.jme3.input.controls.InputListener;
import com.jme3.input.controls.KeyTrigger;
import com.jme3.input.controls.Trigger;
import com.jme3.light.DirectionalLight;
import com.jme3.light.Light;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.post.Filter;
import com.jme3.post.FilterPostProcessor;
import com.jme3.post.SceneProcessor;
import com.jme3.post.filters.FXAAFilter;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.texture.Texture;
import com.jme3.util.SkyFactory;
import com.jme3.util.TangentBinormalGenerator;

public class TestParallax
extends SimpleApplication {
    private Vector3f lightDir = new Vector3f(-1.0f, -1.0f, 0.5f).normalizeLocal();
    DirectionalLight dl;
    Material mat;
    float parallaxHeigh = 0.05f;
    float time = 0.0f;
    boolean steep = false;

    public static void main(String[] args) {
        TestParallax app = new TestParallax();
        app.start();
    }

    public void setupSkyBox() {
        this.rootNode.attachChild(SkyFactory.createSky((AssetManager)this.assetManager, (String)"Scenes/Beach/FullskiesSunset0068.dds", (boolean)false));
    }

    public void setupLighting() {
        this.dl = new DirectionalLight();
        this.dl.setDirection(this.lightDir);
        this.dl.setColor(new ColorRGBA(0.9f, 0.9f, 0.9f, 1.0f));
        this.rootNode.addLight((Light)this.dl);
    }

    public void setupFloor() {
        this.mat = this.assetManager.loadMaterial("Textures/Terrain/BrickWall/BrickWall2.j3m");
        this.mat.getTextureParam("DiffuseMap").getTextureValue().setWrap(Texture.WrapMode.Repeat);
        this.mat.getTextureParam("NormalMap").getTextureValue().setWrap(Texture.WrapMode.Repeat);
        this.mat.setFloat("Shininess", 0.0f);
        Node floorGeom = (Node)this.assetManager.loadAsset("Models/WaterTest/WaterTest.mesh.xml");
        Geometry g = (Geometry)floorGeom.getChild(0);
        g.getMesh().scaleTextureCoordinates(new Vector2f(10.0f, 10.0f));
        TangentBinormalGenerator.generate((Spatial)floorGeom);
        floorGeom.setLocalTranslation(0.0f, 22.0f, 0.0f);
        floorGeom.setLocalScale(100.0f);
        floorGeom.setMaterial(this.mat);
        this.rootNode.attachChild((Spatial)floorGeom);
    }

    public void setupSignpost() {
        Spatial signpost = this.assetManager.loadModel("Models/Sign Post/Sign Post.mesh.xml");
        Material mat = this.assetManager.loadMaterial("Models/Sign Post/Sign Post.j3m");
        TangentBinormalGenerator.generate((Spatial)signpost);
        signpost.setMaterial(mat);
        signpost.rotate(0.0f, 1.5707964f, 0.0f);
        signpost.setLocalTranslation(12.0f, 23.5f, 30.0f);
        signpost.setLocalScale(4.0f);
        signpost.setShadowMode(RenderQueue.ShadowMode.CastAndReceive);
        this.rootNode.attachChild(signpost);
    }

    public void simpleInitApp() {
        this.cam.setLocation(new Vector3f(-15.445636f, 30.162928f, 60.252777f));
        this.cam.setRotation(new Quaternion(0.05173137f, 0.92363626f, -0.13454558f, 0.35513034f));
        this.flyCam.setMoveSpeed(30.0f);
        this.setupLighting();
        this.setupSkyBox();
        this.setupFloor();
        this.setupSignpost();
        this.inputManager.addListener((InputListener)new AnalogListener(){

            public void onAnalog(String name, float value, float tpf) {
                if ("heightUP".equals(name)) {
                    TestParallax.this.parallaxHeigh = (float)((double)TestParallax.this.parallaxHeigh + 1.0E-4);
                    TestParallax.this.mat.setFloat("ParallaxHeight", TestParallax.this.parallaxHeigh);
                }
                if ("heightDown".equals(name)) {
                    TestParallax.this.parallaxHeigh = (float)((double)TestParallax.this.parallaxHeigh - 1.0E-4);
                    TestParallax.this.parallaxHeigh = Math.max(TestParallax.this.parallaxHeigh, 0.0f);
                    TestParallax.this.mat.setFloat("ParallaxHeight", TestParallax.this.parallaxHeigh);
                }
            }
        }, new String[]{"heightUP", "heightDown"});
        this.inputManager.addMapping("heightUP", new Trigger[]{new KeyTrigger(23)});
        this.inputManager.addMapping("heightDown", new Trigger[]{new KeyTrigger(37)});
        this.inputManager.addListener((InputListener)new ActionListener(){

            public void onAction(String name, boolean isPressed, float tpf) {
                if (isPressed && "toggleSteep".equals(name)) {
                    TestParallax.this.steep = !TestParallax.this.steep;
                    TestParallax.this.mat.setBoolean("SteepParallax", TestParallax.this.steep);
                }
            }
        }, new String[]{"toggleSteep"});
        this.inputManager.addMapping("toggleSteep", new Trigger[]{new KeyTrigger(57)});
        FilterPostProcessor fpp = new FilterPostProcessor(this.assetManager);
        FXAAFilter fxaa = new FXAAFilter();
        fxaa.setReduceMul(0.08f);
        fpp.addFilter((Filter)fxaa);
        this.viewPort.addProcessor((SceneProcessor)fpp);
    }

    public void simpleUpdate(float tpf) {
    }
}

