/*
 * Decompiled with CFR 0.152.
 */
package jme3test.material;

import com.jme3.app.SimpleApplication;
import com.jme3.light.Light;
import com.jme3.light.PointLight;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.FastMath;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Quad;
import com.jme3.scene.shape.Sphere;
import com.jme3.util.TangentBinormalGenerator;

public class TestSimpleBumps
extends SimpleApplication {
    float angle;
    PointLight pl;
    Spatial lightMdl;

    public static void main(String[] args) {
        TestSimpleBumps app = new TestSimpleBumps();
        app.start();
    }

    public void simpleInitApp() {
        Quad quadMesh = new Quad(1.0f, 1.0f);
        Geometry sphere = new Geometry("Rock Ball", (Mesh)quadMesh);
        Material mat = this.assetManager.loadMaterial("Textures/BumpMapTest/SimpleBump.j3m");
        sphere.setMaterial(mat);
        TangentBinormalGenerator.generate((Spatial)sphere);
        this.rootNode.attachChild((Spatial)sphere);
        this.lightMdl = new Geometry("Light", (Mesh)new Sphere(10, 10, 0.1f));
        this.lightMdl.setMaterial(this.assetManager.loadMaterial("Common/Materials/RedColor.j3m"));
        this.rootNode.attachChild(this.lightMdl);
        this.pl = new PointLight();
        this.pl.setColor(ColorRGBA.White);
        this.pl.setPosition(new Vector3f(0.0f, 0.0f, 4.0f));
        this.rootNode.addLight((Light)this.pl);
    }

    public void simpleUpdate(float tpf) {
        this.angle += tpf * 0.25f;
        this.angle %= (float)Math.PI * 2;
        this.pl.setPosition(new Vector3f(FastMath.cos((float)this.angle) * 4.0f, 0.5f, FastMath.sin((float)this.angle) * 4.0f));
        this.lightMdl.setLocalTranslation(this.pl.getPosition());
    }
}

