/*
 * Decompiled with CFR 0.152.
 */
package jme3test.model.anim;

import com.jme3.animation.Bone;
import com.jme3.animation.Skeleton;
import com.jme3.animation.SkeletonControl;
import com.jme3.app.SimpleApplication;
import com.jme3.light.AmbientLight;
import com.jme3.light.DirectionalLight;
import com.jme3.light.Light;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.control.Control;
import com.jme3.scene.shape.Box;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;

public class TestCustomAnim
extends SimpleApplication {
    private Bone bone;
    private Skeleton skeleton;
    private Quaternion rotation = new Quaternion();

    public static void main(String[] args) {
        TestCustomAnim app = new TestCustomAnim();
        app.start();
    }

    public void simpleInitApp() {
        AmbientLight al = new AmbientLight();
        this.rootNode.addLight((Light)al);
        DirectionalLight dl = new DirectionalLight();
        dl.setDirection(Vector3f.UNIT_XYZ.negate());
        this.rootNode.addLight((Light)dl);
        Box box = new Box(1.0f, 1.0f, 1.0f);
        FloatBuffer weights = FloatBuffer.allocate(box.getVertexCount() * 4);
        VertexBuffer weightsBuf = new VertexBuffer(VertexBuffer.Type.BoneWeight);
        weightsBuf.setupData(VertexBuffer.Usage.CpuOnly, 4, VertexBuffer.Format.Float, (Buffer)weights);
        box.setBuffer(weightsBuf);
        ByteBuffer indices = ByteBuffer.allocate(box.getVertexCount() * 4);
        VertexBuffer indicesBuf = new VertexBuffer(VertexBuffer.Type.BoneIndex);
        indicesBuf.setupData(VertexBuffer.Usage.CpuOnly, 4, VertexBuffer.Format.UnsignedByte, (Buffer)indices);
        box.setBuffer(indicesBuf);
        box.generateBindPose(true);
        this.bone = new Bone("root");
        this.bone.setBindTransforms(Vector3f.ZERO, Quaternion.IDENTITY, Vector3f.UNIT_XYZ);
        this.bone.setUserControl(true);
        this.skeleton = new Skeleton(new Bone[]{this.bone});
        for (int i = 0; i < box.getVertexCount() * 4; i += 4) {
            indices.array()[i + 0] = 0;
            indices.array()[i + 1] = 0;
            indices.array()[i + 2] = 0;
            indices.array()[i + 3] = 0;
            weights.array()[i + 0] = 1.0f;
            weights.array()[i + 1] = 0.0f;
            weights.array()[i + 2] = 0.0f;
            weights.array()[i + 3] = 0.0f;
        }
        box.setMaxNumWeights(1);
        Geometry geom = new Geometry("box", (Mesh)box);
        geom.setMaterial(this.assetManager.loadMaterial("Textures/Terrain/BrickWall/BrickWall.j3m"));
        Node model = new Node("model");
        model.attachChild((Spatial)geom);
        SkeletonControl skeletonControl = new SkeletonControl(this.skeleton);
        model.addControl((Control)skeletonControl);
        this.rootNode.attachChild((Spatial)model);
    }

    public void simpleUpdate(float tpf) {
        Quaternion rotate = new Quaternion();
        rotate.fromAngleAxis(tpf, Vector3f.UNIT_X);
        this.rotation.multLocal(rotate);
        this.bone.setUserTransforms(Vector3f.ZERO, this.rotation, Vector3f.UNIT_XYZ);
        this.skeleton.updateWorldVectors();
    }
}

