/*
 * Decompiled with CFR 0.152.
 */
package jme3test.network;

import com.jme3.network.Client;
import com.jme3.network.Message;
import com.jme3.network.MessageListener;
import com.jme3.network.Network;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import jme3test.network.TestChatServer;

public class TestChatClient
extends JFrame {
    private Client client;
    private JEditorPane chatLog;
    private StringBuilder chatMessages = new StringBuilder();
    private JTextField nameField;
    private JTextField messageField;

    public TestChatClient(String host) throws IOException {
        super("jME3 Test Chat Client - to:" + host);
        this.setDefaultCloseOperation(2);
        this.setSize(800, 600);
        this.chatLog = new JEditorPane();
        this.chatLog.setEditable(false);
        this.chatLog.setContentType("text/html");
        this.chatLog.setText("<html><body>");
        this.getContentPane().add((Component)new JScrollPane(this.chatLog), "Center");
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(new JLabel("Name:"));
        this.nameField = new JTextField(System.getProperty("user.name", "yourname"));
        Dimension d = this.nameField.getPreferredSize();
        this.nameField.setMaximumSize(new Dimension(120, d.height + 6));
        p.add(this.nameField);
        p.add(new JLabel("  Message:"));
        this.messageField = new JTextField();
        p.add(this.messageField);
        p.add(new JButton(new SendAction(true)));
        p.add(new JButton(new SendAction(false)));
        this.getContentPane().add((Component)p, "South");
        this.client = Network.connectToServer((String)"Test Chat Server", (int)1, (String)host, (int)5110, (int)5110);
        this.client.addMessageListener((MessageListener)new ChatHandler(), new Class[]{TestChatServer.ChatMessage.class});
        this.client.start();
    }

    public static String getString(Component owner, String title, String message, String initialValue) {
        return (String)JOptionPane.showInputDialog(owner, message, title, -1, null, null, initialValue);
    }

    public static void main(String ... args) throws Exception {
        TestChatServer.initializeClasses();
        String s = TestChatClient.getString(null, "Host Info", "Enter chat host:", "localhost");
        if (s == null) {
            System.out.println("User cancelled.");
            return;
        }
        TestChatClient test = new TestChatClient(s);
        test.setVisible(true);
    }

    private class SendAction
    extends AbstractAction {
        private boolean reliable;

        public SendAction(boolean reliable) {
            super(reliable ? "TCP" : "UDP");
            this.reliable = reliable;
        }

        public void actionPerformed(ActionEvent evt) {
            String name = TestChatClient.this.nameField.getText();
            String message = TestChatClient.this.messageField.getText();
            TestChatServer.ChatMessage chat = new TestChatServer.ChatMessage(name, message);
            chat.setReliable(this.reliable);
            System.out.println("Sending:" + (Object)((Object)chat));
            TestChatClient.this.client.send((Message)chat);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ChatHandler
    implements MessageListener<Client> {
        private ChatHandler() {
        }

        public void messageReceived(Client source, Message m) {
            TestChatServer.ChatMessage chat = (TestChatServer.ChatMessage)m;
            System.out.println("Received:" + (Object)((Object)chat));
            TestChatClient.this.chatMessages.append("<font color='#00a000'>" + (m.isReliable() ? "TCP" : "UDP") + "</font>");
            TestChatClient.this.chatMessages.append(" -- <font color='#000080'><b>" + chat.getName() + "</b></font> : ");
            TestChatClient.this.chatMessages.append(chat.getMessage());
            TestChatClient.this.chatMessages.append("<br />");
            String s = "<html><body>" + TestChatClient.this.chatMessages + "</body></html>";
            TestChatClient.this.chatLog.setText(s);
            TestChatClient.this.chatLog.select(s.length(), s.length());
        }
    }
}

