/*
 * Decompiled with CFR 0.152.
 */
package jme3test.network.sync;

import com.jme3.asset.AssetManager;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import jme3test.network.sync.BoxEntity;

public class ClientBoxEntity
extends BoxEntity {
    private Vector3f prevPos = new Vector3f();

    public ClientBoxEntity(AssetManager assetManager, ColorRGBA color) {
        super(assetManager, color);
    }

    public void onRemoteCreate() {
        System.out.println("ClientBoxEntity created");
    }

    public void onRemoteDelete() {
        System.out.println("ClientBoxEntity deleted");
    }

    public void onRemoteUpdate(float latencyDelta) {
        this.prevPos.set(this.getLocalTranslation());
        this.pos.addLocal(this.vel.mult(latencyDelta));
    }

    public void interpolate(float blendAmount) {
        if (this.pos != null) {
            this.getLocalTranslation().interpolate(this.prevPos, this.pos, blendAmount);
            this.setLocalTranslation(this.getLocalTranslation());
        }
    }

    public void extrapolate(float tpf) {
        if (this.pos != null) {
            this.pos.addLocal(this.vel.mult(tpf));
            this.setLocalTranslation(this.pos);
        }
    }
}

