/*
 * Decompiled with CFR 0.152.
 */
package jme3test.post;

import com.jme3.input.InputManager;
import com.jme3.input.controls.ActionListener;
import com.jme3.input.controls.AnalogListener;
import com.jme3.input.controls.InputListener;
import com.jme3.input.controls.KeyTrigger;
import com.jme3.input.controls.Trigger;
import com.jme3.post.ssao.SSAOFilter;

public class SSAOUI {
    SSAOFilter filter;

    public SSAOUI(InputManager inputManager, SSAOFilter filter) {
        this.filter = filter;
        this.init(inputManager);
    }

    private void init(InputManager inputManager) {
        System.out.println("----------------- Water UI Debugger --------------------");
        System.out.println("-- Sample Radius : press Y to increase, H to decrease");
        System.out.println("-- AO Intensity : press U to increase, J to decrease");
        System.out.println("-- AO scale : press I to increase, K to decrease");
        System.out.println("-- AO bias : press O to increase, P to decrease");
        System.out.println("-- Toggle AO on/off : press space bar");
        System.out.println("-- Use only AO : press Num pad 0");
        System.out.println("-- Output config declaration : press P");
        System.out.println("-------------------------------------------------------");
        inputManager.addMapping("sampleRadiusUp", new Trigger[]{new KeyTrigger(21)});
        inputManager.addMapping("sampleRadiusDown", new Trigger[]{new KeyTrigger(35)});
        inputManager.addMapping("intensityUp", new Trigger[]{new KeyTrigger(22)});
        inputManager.addMapping("intensityDown", new Trigger[]{new KeyTrigger(36)});
        inputManager.addMapping("scaleUp", new Trigger[]{new KeyTrigger(23)});
        inputManager.addMapping("scaleDown", new Trigger[]{new KeyTrigger(37)});
        inputManager.addMapping("biasUp", new Trigger[]{new KeyTrigger(24)});
        inputManager.addMapping("biasDown", new Trigger[]{new KeyTrigger(38)});
        inputManager.addMapping("outputConfig", new Trigger[]{new KeyTrigger(25)});
        inputManager.addMapping("toggleUseAO", new Trigger[]{new KeyTrigger(57)});
        inputManager.addMapping("toggleUseOnlyAo", new Trigger[]{new KeyTrigger(82)});
        ActionListener acl = new ActionListener(){

            public void onAction(String name, boolean keyPressed, float tpf) {
                if (name.equals("toggleUseAO") && keyPressed) {
                    SSAOUI.this.filter.setEnabled(!SSAOUI.this.filter.isEnabled());
                    System.out.println("use AO : " + SSAOUI.this.filter.isEnabled());
                }
                if (name.equals("toggleUseOnlyAo") && keyPressed) {
                    SSAOUI.this.filter.setUseOnlyAo(!SSAOUI.this.filter.isUseOnlyAo());
                    System.out.println("use Only AO : " + SSAOUI.this.filter.isUseOnlyAo());
                }
                if (name.equals("outputConfig") && keyPressed) {
                    System.out.println("new SSAOFilter(" + SSAOUI.this.filter.getSampleRadius() + "f," + SSAOUI.this.filter.getIntensity() + "f," + SSAOUI.this.filter.getScale() + "f," + SSAOUI.this.filter.getBias() + "f);");
                }
            }
        };
        AnalogListener anl = new AnalogListener(){

            public void onAnalog(String name, float value, float tpf) {
                if (name.equals("sampleRadiusUp")) {
                    SSAOUI.this.filter.setSampleRadius(SSAOUI.this.filter.getSampleRadius() + 0.01f);
                    System.out.println("Sample Radius : " + SSAOUI.this.filter.getSampleRadius());
                }
                if (name.equals("sampleRadiusDown")) {
                    SSAOUI.this.filter.setSampleRadius(SSAOUI.this.filter.getSampleRadius() - 0.01f);
                    System.out.println("Sample Radius : " + SSAOUI.this.filter.getSampleRadius());
                }
                if (name.equals("intensityUp")) {
                    SSAOUI.this.filter.setIntensity(SSAOUI.this.filter.getIntensity() + 0.01f);
                    System.out.println("Intensity : " + SSAOUI.this.filter.getIntensity());
                }
                if (name.equals("intensityDown")) {
                    SSAOUI.this.filter.setIntensity(SSAOUI.this.filter.getIntensity() - 0.01f);
                    System.out.println("Intensity : " + SSAOUI.this.filter.getIntensity());
                }
                if (name.equals("scaleUp")) {
                    SSAOUI.this.filter.setScale(SSAOUI.this.filter.getScale() + 0.01f);
                    System.out.println("scale : " + SSAOUI.this.filter.getScale());
                }
                if (name.equals("scaleDown")) {
                    SSAOUI.this.filter.setScale(SSAOUI.this.filter.getScale() - 0.01f);
                    System.out.println("scale : " + SSAOUI.this.filter.getScale());
                }
                if (name.equals("biasUp")) {
                    SSAOUI.this.filter.setBias(SSAOUI.this.filter.getBias() + 0.001f);
                    System.out.println("bias : " + SSAOUI.this.filter.getBias());
                }
                if (name.equals("biasDown")) {
                    SSAOUI.this.filter.setBias(SSAOUI.this.filter.getBias() - 0.001f);
                    System.out.println("bias : " + SSAOUI.this.filter.getBias());
                }
            }
        };
        inputManager.addListener((InputListener)acl, new String[]{"toggleUseAO", "toggleUseOnlyAo", "outputConfig"});
        inputManager.addListener((InputListener)anl, new String[]{"sampleRadiusUp", "sampleRadiusDown", "intensityUp", "intensityDown", "scaleUp", "scaleDown", "biasUp", "biasDown"});
    }
}

