/*
 * Decompiled with CFR 0.152.
 */
package jme3test.post;

import com.jme3.app.SimpleApplication;
import com.jme3.material.Material;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.Renderer;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Sphere;
import com.jme3.texture.FrameBuffer;
import com.jme3.texture.Image;
import com.jme3.texture.Texture2D;
import com.jme3.ui.Picture;

public class TestFBOPassthrough
extends SimpleApplication {
    private Node fbNode = new Node("Framebuffer Node");
    private FrameBuffer fb;

    public static void main(String[] args) {
        TestFBOPassthrough app = new TestFBOPassthrough();
        app.start();
    }

    public void simpleInitApp() {
        int w = this.settings.getWidth();
        int h = this.settings.getHeight();
        this.fb = new FrameBuffer(w, h, 1);
        Texture2D fbTex = new Texture2D(w, h, Image.Format.RGBA8);
        this.fb.setDepthBuffer(Image.Format.Depth);
        this.fb.setColorTexture(fbTex);
        Sphere sphMesh = new Sphere(20, 20, 1.0f);
        Material solidColor = this.assetManager.loadMaterial("Common/Materials/RedColor.j3m");
        Geometry sphere = new Geometry("sphere", (Mesh)sphMesh);
        sphere.setMaterial(solidColor);
        this.fbNode.attachChild((Spatial)sphere);
        Picture p = new Picture("Picture");
        p.setPosition(0.0f, 0.0f);
        p.setWidth((float)w);
        p.setHeight((float)h);
        p.setTexture(this.assetManager, fbTex, false);
        this.rootNode.attachChild((Spatial)p);
    }

    public void simpleUpdate(float tpf) {
        this.fbNode.updateLogicalState(tpf);
        this.fbNode.updateGeometricState();
    }

    public void simpleRender(RenderManager rm) {
        Renderer r = rm.getRenderer();
        r.setFrameBuffer(this.fb);
        rm.setCamera(this.cam, false);
        r.clearBuffers(true, true, true);
        rm.renderScene((Spatial)this.fbNode, this.viewPort);
        rm.flushQueue(this.viewPort);
        r.setFrameBuffer(null);
    }
}

