/*
 * Decompiled with CFR 0.152.
 */
package jme3test.post;

import com.jme3.app.SimpleApplication;
import com.jme3.material.Material;
import com.jme3.math.Vector3f;
import com.jme3.post.HDRRenderer;
import com.jme3.post.SceneProcessor;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Box;
import com.jme3.ui.Picture;

public class TestHDR
extends SimpleApplication {
    private HDRRenderer hdrRender;
    private Picture dispQuad;

    public static void main(String[] args) {
        TestHDR app = new TestHDR();
        app.start();
    }

    public Geometry createHDRBox() {
        Box boxMesh = new Box(Vector3f.ZERO, 1.0f, 1.0f, 1.0f);
        Geometry box = new Geometry("Box", (Mesh)boxMesh);
        Material mat = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        mat.setTexture("ColorMap", this.assetManager.loadTexture("Textures/HdrTest/Memorial.hdr"));
        box.setMaterial(mat);
        return box;
    }

    public void simpleInitApp() {
        this.hdrRender = new HDRRenderer(this.assetManager, this.renderer);
        this.hdrRender.setSamples(0);
        this.hdrRender.setMaxIterations(20);
        this.hdrRender.setExposure(0.87f);
        this.hdrRender.setThrottle(0.33f);
        this.viewPort.addProcessor((SceneProcessor)this.hdrRender);
        this.rootNode.attachChild((Spatial)this.createHDRBox());
    }

    public void simpleUpdate(float tpf) {
        if (this.hdrRender.isInitialized() && this.dispQuad == null) {
            this.dispQuad = this.hdrRender.createDisplayQuad();
            this.dispQuad.setWidth(128.0f);
            this.dispQuad.setHeight(128.0f);
            this.dispQuad.setPosition(30.0f, (float)(this.cam.getHeight() - 128 - 30));
            this.guiNode.attachChild((Spatial)this.dispQuad);
        }
    }
}

