/*
 * Decompiled with CFR 0.152.
 */
package jme3test.post;

import com.jme3.app.SimpleApplication;
import com.jme3.light.Light;
import com.jme3.light.PointLight;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.FastMath;
import com.jme3.math.Matrix4f;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.post.SceneProcessor;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.texture.FrameBuffer;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.texture.Texture2D;
import com.jme3.ui.Picture;

public class TestMultiRenderTarget
extends SimpleApplication
implements SceneProcessor {
    private FrameBuffer fb;
    private Texture2D diffuseData;
    private Texture2D normalData;
    private Texture2D specularData;
    private Texture2D depthData;
    private Geometry sphere;
    private Picture display1;
    private Picture display2;
    private Picture display3;
    private Picture display4;
    private Picture display;
    private Material mat;

    public static void main(String[] args) {
        TestMultiRenderTarget app = new TestMultiRenderTarget();
        app.start();
    }

    public void simpleInitApp() {
        this.viewPort.addProcessor((SceneProcessor)this);
        this.renderManager.setForcedTechnique("GBuf");
        this.cam.setLocation(new Vector3f(4.8037705f, 4.851632f, 10.789033f));
        this.cam.setRotation(new Quaternion(-0.05143692f, 0.9483723f, -0.21131563f, -0.230846f));
        Node tank = (Node)this.assetManager.loadModel("Models/HoverTank/Tank2.mesh.xml");
        this.rootNode.attachChild((Spatial)tank);
        this.display1 = new Picture("Picture");
        this.display1.move(0.0f, 0.0f, -1.0f);
        this.display2 = (Picture)this.display1.clone();
        this.display3 = (Picture)this.display1.clone();
        this.display4 = (Picture)this.display1.clone();
        this.display = (Picture)this.display1.clone();
        ColorRGBA[] colors = new ColorRGBA[]{ColorRGBA.White, ColorRGBA.Blue, ColorRGBA.Cyan, ColorRGBA.DarkGray, ColorRGBA.Green, ColorRGBA.Magenta, ColorRGBA.Orange, ColorRGBA.Pink, ColorRGBA.Red, ColorRGBA.Yellow};
        for (int i = 0; i < 3; ++i) {
            PointLight pl = new PointLight();
            float angle = 0.31415927f * (float)i;
            pl.setPosition(new Vector3f(FastMath.cos((float)angle) * 2.0f, 0.0f, FastMath.sin((float)angle) * 2.0f));
            pl.setColor(colors[i]);
            pl.setRadius(5.0f);
            this.rootNode.addLight((Light)pl);
            this.display.addLight((Light)pl);
        }
    }

    public void initialize(RenderManager rm, ViewPort vp) {
        this.reshape(vp, vp.getCamera().getWidth(), vp.getCamera().getHeight());
        this.viewPort.setOutputFrameBuffer(this.fb);
        this.guiViewPort.setClearFlags(true, true, true);
        this.guiNode.attachChild((Spatial)this.display);
        this.guiNode.updateGeometricState();
    }

    public void reshape(ViewPort vp, int w, int h) {
        this.diffuseData = new Texture2D(w, h, Image.Format.RGBA8);
        this.normalData = new Texture2D(w, h, Image.Format.RGBA8);
        this.specularData = new Texture2D(w, h, Image.Format.RGBA8);
        this.depthData = new Texture2D(w, h, Image.Format.Depth);
        this.mat = new Material(this.assetManager, "Common/MatDefs/Light/Deferred.j3md");
        this.mat.setTexture("DiffuseData", (Texture)this.diffuseData);
        this.mat.setTexture("SpecularData", (Texture)this.specularData);
        this.mat.setTexture("NormalData", (Texture)this.normalData);
        this.mat.setTexture("DepthData", (Texture)this.depthData);
        this.display.setMaterial(this.mat);
        this.display.setPosition(0.0f, 0.0f);
        this.display.setWidth((float)w);
        this.display.setHeight((float)h);
        this.display1.setTexture(this.assetManager, this.diffuseData, false);
        this.display2.setTexture(this.assetManager, this.normalData, false);
        this.display3.setTexture(this.assetManager, this.specularData, false);
        this.display4.setTexture(this.assetManager, this.depthData, false);
        this.display1.setPosition(0.0f, 0.0f);
        this.display2.setPosition((float)(w / 2), 0.0f);
        this.display3.setPosition(0.0f, (float)(h / 2));
        this.display4.setPosition((float)(w / 2), (float)(h / 2));
        this.display1.setWidth((float)(w / 2));
        this.display1.setHeight((float)(h / 2));
        this.display2.setWidth((float)(w / 2));
        this.display2.setHeight((float)(h / 2));
        this.display3.setWidth((float)(w / 2));
        this.display3.setHeight((float)(h / 2));
        this.display4.setWidth((float)(w / 2));
        this.display4.setHeight((float)(h / 2));
        this.guiNode.updateGeometricState();
        this.fb = new FrameBuffer(w, h, 1);
        this.fb.setDepthTexture(this.depthData);
        this.fb.addColorTexture(this.diffuseData);
        this.fb.addColorTexture(this.normalData);
        this.fb.addColorTexture(this.specularData);
        this.fb.setMultiTarget(true);
    }

    public boolean isInitialized() {
        return this.diffuseData != null;
    }

    public void preFrame(float tpf) {
        Matrix4f inverseViewProj = this.cam.getViewProjectionMatrix().invert();
        this.mat.setMatrix4("ViewProjectionMatrixInverse", inverseViewProj);
    }

    public void postQueue(RenderQueue rq) {
    }

    public void postFrame(FrameBuffer out) {
    }

    public void cleanup() {
    }
}

