/*
 * Decompiled with CFR 0.152.
 */
package jme3test.stress;

import com.jme3.app.SimpleApplication;
import com.jme3.light.DirectionalLight;
import com.jme3.light.Light;
import com.jme3.material.Material;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import com.jme3.scene.control.LodControl;

public class TestLodStress
extends SimpleApplication {
    public static void main(String[] args) {
        TestLodStress app = new TestLodStress();
        app.setShowSettings(false);
        app.setPauseOnLostFocus(false);
        app.start();
    }

    public void simpleInitApp() {
        DirectionalLight dl = new DirectionalLight();
        dl.setDirection(new Vector3f(-1.0f, -1.0f, -1.0f).normalizeLocal());
        this.rootNode.addLight((Light)dl);
        Node teapotNode = (Node)this.assetManager.loadModel("Models/Teapot/Teapot.mesh.xml");
        Geometry teapot = (Geometry)teapotNode.getChild(0);
        Material mat = new Material(this.assetManager, "Common/MatDefs/Light/Lighting.j3md");
        mat.setFloat("Shininess", 16.0f);
        mat.setBoolean("VertexLighting", true);
        teapot.setMaterial(mat);
        for (int y = -10; y < 10; ++y) {
            for (int x = -10; x < 10; ++x) {
                Geometry clonePot = teapot.clone();
                clonePot.setLocalTranslation((float)x * 0.5f, 0.0f, (float)y * 0.5f);
                clonePot.setLocalScale(0.15f);
                LodControl control = new LodControl();
                clonePot.addControl((Control)control);
                this.rootNode.attachChild((Spatial)clonePot);
            }
        }
        this.cam.setLocation(new Vector3f(8.378951f, 5.4324f, 8.795956f));
        this.cam.setRotation(new Quaternion(-0.083419204f, 0.90370524f, -0.20599906f, -0.36595422f));
    }
}

