/*
 * Decompiled with CFR 0.152.
 */
package jme3test.terrain;

import com.jme3.app.SimpleApplication;
import com.jme3.app.state.AppState;
import com.jme3.app.state.ScreenshotAppState;
import com.jme3.asset.plugins.HttpZipLocator;
import com.jme3.asset.plugins.ZipLocator;
import com.jme3.bullet.BulletAppState;
import com.jme3.bullet.collision.shapes.CapsuleCollisionShape;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.collision.shapes.HeightfieldCollisionShape;
import com.jme3.bullet.control.CharacterControl;
import com.jme3.bullet.control.RigidBodyControl;
import com.jme3.input.controls.ActionListener;
import com.jme3.input.controls.InputListener;
import com.jme3.input.controls.KeyTrigger;
import com.jme3.input.controls.Trigger;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import com.jme3.terrain.Terrain;
import com.jme3.terrain.geomipmap.TerrainGrid;
import com.jme3.terrain.geomipmap.TerrainGridListener;
import com.jme3.terrain.geomipmap.TerrainLodControl;
import com.jme3.terrain.geomipmap.TerrainQuad;
import com.jme3.terrain.heightmap.HeightMapGrid;
import com.jme3.terrain.heightmap.ImageBasedHeightMapGrid;
import com.jme3.terrain.heightmap.Namer;
import com.jme3.texture.Texture;
import java.io.File;

public class TerrainGridTest
extends SimpleApplication {
    private Material mat_terrain;
    private TerrainGrid terrain;
    private float grassScale = 64.0f;
    private float dirtScale = 16.0f;
    private float rockScale = 128.0f;
    private boolean usePhysics = true;
    private boolean physicsAdded = false;
    private CharacterControl player3;
    private boolean left;
    private boolean right;
    private boolean up;
    private boolean down;
    private final ActionListener actionListener = new ActionListener(){

        public void onAction(String name, boolean keyPressed, float tpf) {
            if (name.equals("Lefts")) {
                if (keyPressed) {
                    TerrainGridTest.this.left = true;
                } else {
                    TerrainGridTest.this.left = false;
                }
            } else if (name.equals("Rights")) {
                if (keyPressed) {
                    TerrainGridTest.this.right = true;
                } else {
                    TerrainGridTest.this.right = false;
                }
            } else if (name.equals("Ups")) {
                if (keyPressed) {
                    TerrainGridTest.this.up = true;
                } else {
                    TerrainGridTest.this.up = false;
                }
            } else if (name.equals("Downs")) {
                if (keyPressed) {
                    TerrainGridTest.this.down = true;
                } else {
                    TerrainGridTest.this.down = false;
                }
            } else if (name.equals("Jumps")) {
                TerrainGridTest.this.player3.jump();
            }
        }
    };
    private final Vector3f walkDirection = new Vector3f();

    public static void main(String[] args) {
        TerrainGridTest app = new TerrainGridTest();
        app.start();
    }

    public void simpleInitApp() {
        File file = new File("mountains.zip");
        if (!file.exists()) {
            this.assetManager.registerLocator("http://jmonkeyengine.googlecode.com/files/mountains.zip", HttpZipLocator.class);
        } else {
            this.assetManager.registerLocator("mountains.zip", ZipLocator.class);
        }
        this.flyCam.setMoveSpeed(100.0f);
        ScreenshotAppState state = new ScreenshotAppState();
        this.stateManager.attach((AppState)state);
        this.mat_terrain = new Material(this.assetManager, "Common/MatDefs/Terrain/HeightBasedTerrain.j3md");
        Texture grass = this.assetManager.loadTexture("Textures/Terrain/splat/grass.jpg");
        grass.setWrap(Texture.WrapMode.Repeat);
        this.mat_terrain.setTexture("region1ColorMap", grass);
        this.mat_terrain.setVector3("region1", new Vector3f(88.0f, 200.0f, this.grassScale));
        Texture dirt = this.assetManager.loadTexture("Textures/Terrain/splat/dirt.jpg");
        dirt.setWrap(Texture.WrapMode.Repeat);
        this.mat_terrain.setTexture("region2ColorMap", dirt);
        this.mat_terrain.setVector3("region2", new Vector3f(0.0f, 90.0f, this.dirtScale));
        Texture rock = this.assetManager.loadTexture("Textures/Terrain/Rock2/rock.jpg");
        rock.setWrap(Texture.WrapMode.Repeat);
        this.mat_terrain.setTexture("region3ColorMap", rock);
        this.mat_terrain.setVector3("region3", new Vector3f(198.0f, 260.0f, this.rockScale));
        this.mat_terrain.setTexture("region4ColorMap", rock);
        this.mat_terrain.setVector3("region4", new Vector3f(198.0f, 260.0f, this.rockScale));
        this.mat_terrain.setTexture("slopeColorMap", rock);
        this.mat_terrain.setFloat("slopeTileFactor", 32.0f);
        this.mat_terrain.setFloat("terrainSize", 129.0f);
        this.terrain = new TerrainGrid("terrain", 65, 257, (HeightMapGrid)new ImageBasedHeightMapGrid(this.assetManager, new Namer(){

            public String getName(int x, int y) {
                return "Scenes/TerrainMountains/terrain_" + x + "_" + y + ".png";
            }
        }));
        this.terrain.setMaterial(this.mat_terrain);
        this.terrain.setLocalTranslation(0.0f, 0.0f, 0.0f);
        this.terrain.setLocalScale(2.0f, 1.0f, 2.0f);
        this.rootNode.attachChild((Spatial)this.terrain);
        TerrainLodControl control = new TerrainLodControl((Terrain)this.terrain, this.getCamera());
        this.terrain.addControl((Control)control);
        final BulletAppState bulletAppState = new BulletAppState();
        this.stateManager.attach((AppState)bulletAppState);
        this.getCamera().setLocation(new Vector3f(0.0f, 256.0f, 0.0f));
        this.viewPort.setBackgroundColor(new ColorRGBA(0.7f, 0.8f, 1.0f, 1.0f));
        if (this.usePhysics) {
            CapsuleCollisionShape capsuleShape = new CapsuleCollisionShape(0.5f, 1.8f, 1);
            this.player3 = new CharacterControl((CollisionShape)capsuleShape, 0.5f);
            this.player3.setJumpSpeed(20.0f);
            this.player3.setFallSpeed(10.0f);
            this.player3.setGravity(10.0f);
            this.player3.setPhysicsLocation(new Vector3f(this.cam.getLocation().x, 256.0f, this.cam.getLocation().z));
            bulletAppState.getPhysicsSpace().add((Object)this.player3);
            this.terrain.addListener("physicsStartListener", new TerrainGridListener(){

                public void gridMoved(Vector3f newCenter) {
                }

                public Material tileLoaded(Material material, Vector3f cell) {
                    return material;
                }

                public void tileAttached(Vector3f cell, TerrainQuad quad) {
                    quad.addControl((Control)new RigidBodyControl((CollisionShape)new HeightfieldCollisionShape(quad.getHeightMap(), TerrainGridTest.this.terrain.getLocalScale()), 0.0f));
                    bulletAppState.getPhysicsSpace().add((Object)quad);
                }

                public void tileDetached(Vector3f cell, TerrainQuad quad) {
                    bulletAppState.getPhysicsSpace().remove((Object)quad);
                    quad.removeControl(RigidBodyControl.class);
                }
            });
        }
        this.terrain.initialize(this.cam.getLocation());
        this.initKeys();
    }

    private void initKeys() {
        this.inputManager.addMapping("Lefts", new Trigger[]{new KeyTrigger(30)});
        this.inputManager.addMapping("Rights", new Trigger[]{new KeyTrigger(32)});
        this.inputManager.addMapping("Ups", new Trigger[]{new KeyTrigger(17)});
        this.inputManager.addMapping("Downs", new Trigger[]{new KeyTrigger(31)});
        this.inputManager.addMapping("Jumps", new Trigger[]{new KeyTrigger(57)});
        this.inputManager.addListener((InputListener)this.actionListener, new String[]{"Lefts"});
        this.inputManager.addListener((InputListener)this.actionListener, new String[]{"Rights"});
        this.inputManager.addListener((InputListener)this.actionListener, new String[]{"Ups"});
        this.inputManager.addListener((InputListener)this.actionListener, new String[]{"Downs"});
        this.inputManager.addListener((InputListener)this.actionListener, new String[]{"Jumps"});
    }

    public void simpleUpdate(float tpf) {
        Vector3f camDir = this.cam.getDirection().clone().multLocal(0.6f);
        Vector3f camLeft = this.cam.getLeft().clone().multLocal(0.4f);
        this.walkDirection.set(0.0f, 0.0f, 0.0f);
        if (this.left) {
            this.walkDirection.addLocal(camLeft);
        }
        if (this.right) {
            this.walkDirection.addLocal(camLeft.negate());
        }
        if (this.up) {
            this.walkDirection.addLocal(camDir);
        }
        if (this.down) {
            this.walkDirection.addLocal(camDir.negate());
        }
        if (this.usePhysics) {
            this.player3.setWalkDirection(this.walkDirection);
            this.cam.setLocation(this.player3.getPhysicsLocation());
        }
    }
}

