/*
 * Decompiled with CFR 0.152.
 */
package jme3test.terrain;

import com.jme3.app.SimpleApplication;
import com.jme3.asset.AssetManager;
import com.jme3.bounding.BoundingBox;
import com.jme3.bounding.BoundingVolume;
import com.jme3.font.BitmapText;
import com.jme3.input.controls.ActionListener;
import com.jme3.input.controls.InputListener;
import com.jme3.input.controls.KeyTrigger;
import com.jme3.input.controls.Trigger;
import com.jme3.light.AmbientLight;
import com.jme3.light.DirectionalLight;
import com.jme3.light.Light;
import com.jme3.light.PointLight;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import com.jme3.terrain.Terrain;
import com.jme3.terrain.geomipmap.TerrainLodControl;
import com.jme3.terrain.geomipmap.TerrainQuad;
import com.jme3.terrain.heightmap.ImageBasedHeightMap;
import com.jme3.texture.Texture;
import com.jme3.util.SkyFactory;
import java.awt.Image;
import jme3tools.converters.ImageToAwt;

public class TerrainTestAdvanced
extends SimpleApplication {
    private TerrainQuad terrain;
    Material matTerrain;
    Material matWire;
    boolean wireframe = false;
    boolean triPlanar = false;
    boolean wardiso = false;
    boolean minnaert = false;
    protected BitmapText hintText;
    PointLight pl;
    Geometry lightMdl;
    private float grassScale = 64.0f;
    private float dirtScale = 16.0f;
    private float rockScale = 128.0f;
    private ActionListener actionListener = new ActionListener(){

        public void onAction(String name, boolean pressed, float tpf) {
            if (name.equals("wireframe") && !pressed) {
                boolean bl = TerrainTestAdvanced.this.wireframe = !TerrainTestAdvanced.this.wireframe;
                if (!TerrainTestAdvanced.this.wireframe) {
                    TerrainTestAdvanced.this.terrain.setMaterial(TerrainTestAdvanced.this.matWire);
                } else {
                    TerrainTestAdvanced.this.terrain.setMaterial(TerrainTestAdvanced.this.matTerrain);
                }
            } else if (name.equals("triPlanar") && !pressed) {
                boolean bl = TerrainTestAdvanced.this.triPlanar = !TerrainTestAdvanced.this.triPlanar;
                if (TerrainTestAdvanced.this.triPlanar) {
                    TerrainTestAdvanced.this.matTerrain.setBoolean("useTriPlanarMapping", true);
                    TerrainTestAdvanced.this.matTerrain.setFloat("DiffuseMap_0_scale", 1.0f / (512.0f / TerrainTestAdvanced.this.grassScale));
                    TerrainTestAdvanced.this.matTerrain.setFloat("DiffuseMap_1_scale", 1.0f / (512.0f / TerrainTestAdvanced.this.dirtScale));
                    TerrainTestAdvanced.this.matTerrain.setFloat("DiffuseMap_2_scale", 1.0f / (512.0f / TerrainTestAdvanced.this.rockScale));
                    TerrainTestAdvanced.this.matTerrain.setFloat("DiffuseMap_3_scale", 1.0f / (512.0f / TerrainTestAdvanced.this.rockScale));
                    TerrainTestAdvanced.this.matTerrain.setFloat("DiffuseMap_4_scale", 1.0f / (512.0f / TerrainTestAdvanced.this.rockScale));
                } else {
                    TerrainTestAdvanced.this.matTerrain.setBoolean("useTriPlanarMapping", false);
                    TerrainTestAdvanced.this.matTerrain.setFloat("DiffuseMap_0_scale", TerrainTestAdvanced.this.grassScale);
                    TerrainTestAdvanced.this.matTerrain.setFloat("DiffuseMap_1_scale", TerrainTestAdvanced.this.dirtScale);
                    TerrainTestAdvanced.this.matTerrain.setFloat("DiffuseMap_2_scale", TerrainTestAdvanced.this.rockScale);
                    TerrainTestAdvanced.this.matTerrain.setFloat("DiffuseMap_3_scale", TerrainTestAdvanced.this.rockScale);
                    TerrainTestAdvanced.this.matTerrain.setFloat("DiffuseMap_4_scale", TerrainTestAdvanced.this.rockScale);
                }
            }
        }
    };

    public static void main(String[] args) {
        TerrainTestAdvanced app = new TerrainTestAdvanced();
        app.start();
    }

    public void initialize() {
        super.initialize();
        this.loadHintText();
    }

    public void simpleInitApp() {
        this.setupKeys();
        this.matTerrain = new Material(this.assetManager, "Common/MatDefs/Terrain/TerrainLighting.j3md");
        this.matTerrain.setBoolean("useTriPlanarMapping", false);
        this.matTerrain.setBoolean("WardIso", true);
        this.matTerrain.setTexture("AlphaMap", this.assetManager.loadTexture("Textures/Terrain/splat/alpha1.png"));
        this.matTerrain.setTexture("AlphaMap_1", this.assetManager.loadTexture("Textures/Terrain/splat/alpha2.png"));
        Texture heightMapImage = this.assetManager.loadTexture("Textures/Terrain/splat/mountains512.png");
        Texture grass = this.assetManager.loadTexture("Textures/Terrain/splat/grass.jpg");
        grass.setWrap(Texture.WrapMode.Repeat);
        this.matTerrain.setTexture("DiffuseMap", grass);
        this.matTerrain.setFloat("DiffuseMap_0_scale", this.grassScale);
        Texture dirt = this.assetManager.loadTexture("Textures/Terrain/splat/dirt.jpg");
        dirt.setWrap(Texture.WrapMode.Repeat);
        this.matTerrain.setTexture("DiffuseMap_1", dirt);
        this.matTerrain.setFloat("DiffuseMap_1_scale", this.dirtScale);
        Texture rock = this.assetManager.loadTexture("Textures/Terrain/splat/road.jpg");
        rock.setWrap(Texture.WrapMode.Repeat);
        this.matTerrain.setTexture("DiffuseMap_2", rock);
        this.matTerrain.setFloat("DiffuseMap_2_scale", this.rockScale);
        Texture brick = this.assetManager.loadTexture("Textures/Terrain/BrickWall/BrickWall.jpg");
        brick.setWrap(Texture.WrapMode.Repeat);
        this.matTerrain.setTexture("DiffuseMap_3", brick);
        this.matTerrain.setFloat("DiffuseMap_3_scale", this.rockScale);
        Texture riverRock = this.assetManager.loadTexture("Textures/Terrain/Pond/Pond.jpg");
        riverRock.setWrap(Texture.WrapMode.Repeat);
        this.matTerrain.setTexture("DiffuseMap_4", riverRock);
        this.matTerrain.setFloat("DiffuseMap_4_scale", this.rockScale);
        Texture normalMap0 = this.assetManager.loadTexture("Textures/Terrain/splat/grass_normal.jpg");
        normalMap0.setWrap(Texture.WrapMode.Repeat);
        Texture normalMap1 = this.assetManager.loadTexture("Textures/Terrain/splat/dirt_normal.png");
        normalMap1.setWrap(Texture.WrapMode.Repeat);
        Texture normalMap2 = this.assetManager.loadTexture("Textures/Terrain/splat/road_normal.png");
        normalMap2.setWrap(Texture.WrapMode.Repeat);
        this.matTerrain.setTexture("NormalMap", normalMap0);
        this.matTerrain.setTexture("NormalMap_1", normalMap2);
        this.matTerrain.setTexture("NormalMap_2", normalMap2);
        this.matTerrain.setTexture("NormalMap_4", normalMap2);
        this.matWire = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        this.matWire.getAdditionalRenderState().setWireframe(true);
        this.matWire.setColor("Color", ColorRGBA.Green);
        this.createSky();
        ImageBasedHeightMap heightmap = null;
        try {
            heightmap = new ImageBasedHeightMap((Image)ImageToAwt.convert((com.jme3.texture.Image)heightMapImage.getImage(), (boolean)false, (boolean)true, (int)0), 1.0f);
            heightmap.load();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.terrain = new TerrainQuad("terrain", 65, 513, heightmap.getHeightMap());
        TerrainLodControl control = new TerrainLodControl((Terrain)this.terrain, this.getCamera());
        this.terrain.addControl((Control)control);
        this.terrain.setMaterial(this.matTerrain);
        this.terrain.setModelBound((BoundingVolume)new BoundingBox());
        this.terrain.updateModelBound();
        this.terrain.setLocalTranslation(0.0f, -100.0f, 0.0f);
        this.terrain.setLocalScale(1.0f, 1.0f, 1.0f);
        this.rootNode.attachChild((Spatial)this.terrain);
        DirectionalLight light = new DirectionalLight();
        light.setDirection(new Vector3f(-0.5f, -1.0f, -0.5f).normalize());
        this.rootNode.addLight((Light)light);
        AmbientLight ambLight = new AmbientLight();
        ambLight.setColor(new ColorRGBA(1.0f, 1.0f, 0.8f, 0.2f));
        this.rootNode.addLight((Light)ambLight);
        this.cam.setLocation(new Vector3f(0.0f, 10.0f, -10.0f));
        this.cam.lookAtDirection(new Vector3f(0.0f, -1.5f, -1.0f).normalizeLocal(), Vector3f.UNIT_Y);
    }

    public void loadHintText() {
        this.hintText = new BitmapText(this.guiFont, false);
        this.hintText.setSize((float)this.guiFont.getCharSet().getRenderedSize());
        this.hintText.setLocalTranslation(0.0f, (float)this.getCamera().getHeight(), 0.0f);
        this.hintText.setText("Hit T to switch to wireframe,  P to switch to tri-planar texturing");
        this.guiNode.attachChild((Spatial)this.hintText);
    }

    private void setupKeys() {
        this.flyCam.setMoveSpeed(50.0f);
        this.inputManager.addMapping("wireframe", new Trigger[]{new KeyTrigger(20)});
        this.inputManager.addListener((InputListener)this.actionListener, new String[]{"wireframe"});
        this.inputManager.addMapping("triPlanar", new Trigger[]{new KeyTrigger(25)});
        this.inputManager.addListener((InputListener)this.actionListener, new String[]{"triPlanar"});
        this.inputManager.addMapping("WardIso", new Trigger[]{new KeyTrigger(10)});
        this.inputManager.addListener((InputListener)this.actionListener, new String[]{"WardIso"});
        this.inputManager.addMapping("Minnaert", new Trigger[]{new KeyTrigger(11)});
        this.inputManager.addListener((InputListener)this.actionListener, new String[]{"Minnaert"});
    }

    private void createSky() {
        Texture west = this.assetManager.loadTexture("Textures/Sky/Lagoon/lagoon_west.jpg");
        Texture east = this.assetManager.loadTexture("Textures/Sky/Lagoon/lagoon_east.jpg");
        Texture north = this.assetManager.loadTexture("Textures/Sky/Lagoon/lagoon_north.jpg");
        Texture south = this.assetManager.loadTexture("Textures/Sky/Lagoon/lagoon_south.jpg");
        Texture up = this.assetManager.loadTexture("Textures/Sky/Lagoon/lagoon_up.jpg");
        Texture down = this.assetManager.loadTexture("Textures/Sky/Lagoon/lagoon_down.jpg");
        Spatial sky = SkyFactory.createSky((AssetManager)this.assetManager, (Texture)west, (Texture)east, (Texture)north, (Texture)south, (Texture)up, (Texture)down);
        this.rootNode.attachChild(sky);
    }
}

