/*
 * Decompiled with CFR 0.152.
 */
package jme3test.water;

import com.jme3.app.SimpleApplication;
import com.jme3.asset.AssetManager;
import com.jme3.asset.plugins.HttpZipLocator;
import com.jme3.asset.plugins.ZipLocator;
import com.jme3.input.controls.ActionListener;
import com.jme3.input.controls.InputListener;
import com.jme3.input.controls.KeyTrigger;
import com.jme3.input.controls.Trigger;
import com.jme3.light.DirectionalLight;
import com.jme3.light.Light;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.post.Filter;
import com.jme3.post.FilterPostProcessor;
import com.jme3.post.SceneProcessor;
import com.jme3.scene.Spatial;
import com.jme3.util.SkyFactory;
import com.jme3.water.WaterFilter;
import java.io.File;

public class TestPostWaterLake
extends SimpleApplication {
    private static boolean useHttp = true;

    public static void main(String[] args) {
        TestPostWaterLake app = new TestPostWaterLake();
        app.start();
    }

    public void simpleInitApp() {
        this.flyCam.setMoveSpeed(10.0f);
        this.cam.setLocation(new Vector3f(-27.0f, 1.0f, 75.0f));
        this.rootNode.attachChild(SkyFactory.createSky((AssetManager)this.assetManager, (String)"Textures/Sky/Bright/BrightSky.dds", (boolean)false));
        File file = new File("wildhouse.zip");
        if (file.exists()) {
            useHttp = false;
        }
        if (useHttp) {
            this.assetManager.registerLocator("http://jmonkeyengine.googlecode.com/files/wildhouse.zip", HttpZipLocator.class.getName());
        } else {
            this.assetManager.registerLocator("wildhouse.zip", ZipLocator.class.getName());
        }
        Spatial scene = this.assetManager.loadModel("main.scene");
        this.rootNode.attachChild(scene);
        DirectionalLight sun = new DirectionalLight();
        Vector3f lightDir = new Vector3f(-0.37352666f, -0.50444174f, -0.7784704f);
        sun.setDirection(lightDir);
        sun.setColor(ColorRGBA.White.clone().multLocal(2.0f));
        scene.addLight((Light)sun);
        FilterPostProcessor fpp = new FilterPostProcessor(this.assetManager);
        final WaterFilter water = new WaterFilter(this.rootNode, lightDir);
        water.setWaterHeight(-20.0f);
        water.setUseFoam(false);
        water.setUseRipples(false);
        water.setDeepWaterColor(ColorRGBA.Brown);
        water.setWaterColor(ColorRGBA.Brown.mult(2.0f));
        water.setWaterTransparency(0.2f);
        water.setMaxAmplitude(0.3f);
        water.setWaveScale(0.008f);
        water.setSpeed(0.7f);
        water.setShoreHardness(1.0f);
        water.setRefractionConstant(0.2f);
        water.setShininess(0.3f);
        water.setSunScale(1.0f);
        water.setColorExtinction(new Vector3f(10.0f, 20.0f, 30.0f));
        fpp.addFilter((Filter)water);
        this.viewPort.addProcessor((SceneProcessor)fpp);
        this.inputManager.addListener((InputListener)new ActionListener(){

            public void onAction(String name, boolean isPressed, float tpf) {
                if (isPressed) {
                    if (water.isUseHQShoreline()) {
                        water.setUseHQShoreline(false);
                    } else {
                        water.setUseHQShoreline(true);
                    }
                }
            }
        }, new String[]{"HQ"});
        Trigger[] triggerArray = new Trigger[1];
        triggerArray[0] = new KeyTrigger(57);
        this.inputManager.addMapping("HQ", triggerArray);
    }
}

