/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.app.android;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import com.jme3.app.Application;
import com.jme3.font.BitmapFont;
import com.jme3.font.BitmapText;
import com.jme3.input.android.AndroidInput;
import com.jme3.input.controls.TouchListener;
import com.jme3.input.controls.TouchTrigger;
import com.jme3.input.event.TouchEvent;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.system.AppSettings;
import com.jme3.system.JmeSystem;
import com.jme3.util.FastInteger;
import java.nio.CharBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;

@Deprecated
public abstract class AndroidApplication
extends Application
implements DialogInterface.OnClickListener,
TouchListener {
    protected static final Logger logger = Logger.getLogger(AndroidApplication.class.getName());
    protected Node rootNode = new Node("Root Node");
    protected Node guiNode = new Node("Gui Node");
    protected float secondCounter = 0.0f;
    protected BitmapText fpsText;
    protected CharBuffer textBuf = CharBuffer.allocate(50);
    protected char[] fpsBuf = new char[16];
    protected BitmapFont guiFont;
    protected Activity activity;
    protected AndroidInput input;
    protected final AtomicBoolean loadingFinished;

    public AndroidApplication() {
        this(null, null);
    }

    public AndroidApplication(Activity activity, AndroidInput input) {
        this.activity = activity;
        this.input = input;
        this.loadingFinished = new AtomicBoolean(false);
    }

    @Override
    public void start() {
        System.setProperty("org.xml.sax.driver", "org.xmlpull.v1.sax2.Driver");
        if (this.settings == null) {
            this.settings = new AppSettings(true);
        }
        this.settings.putBoolean("USE_VA", true);
        this.settings.putBoolean("VERBOSE_LOGGING", false);
        this.setSettings(this.settings);
        super.start();
    }

    public Node getGuiNode() {
        return this.guiNode;
    }

    public Node getRootNode() {
        return this.rootNode;
    }

    public void loadFPSText() {
        this.guiFont = this.assetManager.loadFont("Interface/Fonts/Default.fnt");
        this.fpsText = new BitmapText(this.guiFont, false);
        this.fpsText.setLocalTranslation(0.0f, this.fpsText.getLineHeight(), 0.0f);
        this.fpsText.setText("Frames per second");
        this.guiNode.attachChild(this.fpsText);
    }

    @Override
    public void initialize() {
        this.assetManager = JmeSystem.newAssetManager(null);
        super.initialize();
        this.guiNode.setQueueBucket(RenderQueue.Bucket.Gui);
        this.guiNode.setCullHint(Spatial.CullHint.Never);
        this.loadFPSText();
        this.viewPort.attachScene(this.rootNode);
        this.guiViewPort.attachScene(this.guiNode);
        this.inputManager.addMapping("TouchEscape", new TouchTrigger(4));
        this.inputManager.addListener(this, "TouchEscape");
        this.init();
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    AndroidApplication.this.asyncload();
                }
                catch (Exception e) {
                    AndroidApplication.this.handleError("AsyncLoad failed", e);
                }
                AndroidApplication.this.loadingFinished.set(true);
            }
        });
        t.setDaemon(true);
        t.start();
    }

    @Override
    public void update() {
        super.update();
        if (this.speed == 0.0f || this.paused) {
            return;
        }
        float tpf = this.timer.getTimePerFrame() * this.speed;
        this.secondCounter += this.timer.getTimePerFrame();
        int fps = (int)this.timer.getFrameRate();
        if (this.secondCounter >= 5.0f) {
            this.textBuf.clear();
            this.textBuf.put("Frames per second: ");
            FastInteger.toCharArray(fps, this.fpsBuf);
            this.textBuf.put(this.fpsBuf);
            this.textBuf.flip();
            this.fpsText.setText(this.textBuf);
            this.secondCounter = 0.0f;
        }
        this.stateManager.update(tpf);
        this.update(tpf);
        this.rootNode.updateLogicalState(tpf);
        this.guiNode.updateLogicalState(tpf);
        this.rootNode.updateGeometricState();
        this.guiNode.updateGeometricState();
        this.stateManager.render(this.renderManager);
        this.renderManager.render(tpf);
        this.render(this.renderManager);
        this.stateManager.postRender();
    }

    public abstract void init();

    public void update(float tpf) {
    }

    public void render(RenderManager rm) {
    }

    public void asyncload() {
    }

    @Override
    public void handleError(final String errorMsg, final Throwable t) {
        String s = "";
        if (t != null && t.getStackTrace() != null) {
            for (StackTraceElement ste : t.getStackTrace()) {
                s = s + ste.getClassName() + "." + ste.getMethodName() + "(" + ste.getLineNumber() + ") ";
            }
        }
        final String sTrace = s;
        logger.severe(t != null ? t.toString() : "Failed");
        logger.severe((errorMsg != null ? errorMsg + ": " : "") + sTrace);
        this.activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                AlertDialog dialog = new AlertDialog.Builder((Context)AndroidApplication.this.activity).setTitle((CharSequence)(t != null ? (t.getMessage() != null ? t.getMessage() + ": " + t.getClass().getName() : t.getClass().getName()) : "Exception")).setPositiveButton((CharSequence)"Kill", (DialogInterface.OnClickListener)AndroidApplication.this).setMessage((CharSequence)((errorMsg != null ? errorMsg + ": " : "") + sTrace)).create();
                dialog.show();
            }
        });
    }

    public void onClick(DialogInterface dialog, int whichButton) {
        if (whichButton != -2) {
            this.stop(true);
            this.activity.finish();
        }
    }

    @Override
    public void onTouch(String name, TouchEvent evt, float tpf) {
        switch (evt.getType()) {
            case KEY_UP: {
                this.activity.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        AlertDialog dialog = new AlertDialog.Builder((Context)AndroidApplication.this.activity).setTitle((CharSequence)"Do you want to exit?").setPositiveButton((CharSequence)"Yes", (DialogInterface.OnClickListener)AndroidApplication.this).setNegativeButton((CharSequence)"No", (DialogInterface.OnClickListener)AndroidApplication.this).setMessage((CharSequence)"Use your home key to bring this app into the background or Exit to terminate it.").create();
                        dialog.show();
                    }
                });
                break;
            }
        }
    }
}

