/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.curves;

import com.jme3.math.Vector3f;
import com.jme3.scene.plugins.blender.file.DynamicArray;
import com.jme3.scene.plugins.blender.file.Structure;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BezierCurve {
    public static final int X_VALUE = 0;
    public static final int Y_VALUE = 1;
    public static final int Z_VALUE = 2;
    private int type;
    private int dimension;
    private float[][][] bezierPoints;

    public BezierCurve(int type, List<Structure> bezTriples, int dimension) {
        if (dimension != 2 && dimension != 3) {
            throw new IllegalArgumentException("The dimension of the curve should be 2 or 3!");
        }
        this.type = type;
        this.dimension = dimension;
        this.bezierPoints = new float[bezTriples.size()][3][dimension];
        int i = 0;
        for (Structure bezTriple : bezTriples) {
            DynamicArray vec = (DynamicArray)bezTriple.getFieldValue("vec");
            for (int j = 0; j < 3; ++j) {
                for (int k = 0; k < dimension; ++k) {
                    this.bezierPoints[i][j][k] = ((Number)vec.get(j, k)).floatValue();
                }
            }
            ++i;
        }
    }

    public float evaluate(int frame, int valuePart) {
        for (int i = 0; i < this.bezierPoints.length - 1; ++i) {
            if (!((float)frame >= this.bezierPoints[i][1][0]) || !((float)frame <= this.bezierPoints[i + 1][1][0])) continue;
            float t = ((float)frame - this.bezierPoints[i][1][0]) / (this.bezierPoints[i + 1][1][0] - this.bezierPoints[i][1][0]);
            float oneMinusT = 1.0f - t;
            float oneMinusT2 = oneMinusT * oneMinusT;
            float t2 = t * t;
            return this.bezierPoints[i][1][valuePart] * oneMinusT2 * oneMinusT + 3.0f * this.bezierPoints[i][2][valuePart] * t * oneMinusT2 + 3.0f * this.bezierPoints[i + 1][0][valuePart] * t2 * oneMinusT + this.bezierPoints[i + 1][1][valuePart] * t2 * t;
        }
        if ((float)frame < this.bezierPoints[0][1][0]) {
            return this.bezierPoints[0][1][1];
        }
        return this.bezierPoints[this.bezierPoints.length - 1][1][1];
    }

    public int getLastFrame() {
        return (int)this.bezierPoints[this.bezierPoints.length - 1][1][0];
    }

    public int getType() {
        return this.type;
    }

    public List<Vector3f> getControlPoints() {
        ArrayList<Vector3f> controlPoints = new ArrayList<Vector3f>(this.bezierPoints.length * 3);
        for (int i = 0; i < this.bezierPoints.length; ++i) {
            controlPoints.add(new Vector3f(this.bezierPoints[i][0][0], this.bezierPoints[i][0][1], this.bezierPoints[i][0][2]));
            controlPoints.add(new Vector3f(this.bezierPoints[i][1][0], this.bezierPoints[i][1][1], this.bezierPoints[i][1][2]));
            controlPoints.add(new Vector3f(this.bezierPoints[i][2][0], this.bezierPoints[i][2][1], this.bezierPoints[i][2][2]));
        }
        return controlPoints;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Bezier curve: ").append(this.type).append('\n');
        for (int i = 0; i < this.bezierPoints.length; ++i) {
            sb.append(this.toStringBezTriple(i)).append('\n');
        }
        return sb.toString();
    }

    private String toStringBezTriple(int tripleIndex) {
        if (this.dimension == 2) {
            return "[(" + this.bezierPoints[tripleIndex][0][0] + ", " + this.bezierPoints[tripleIndex][0][1] + ") (" + this.bezierPoints[tripleIndex][1][0] + ", " + this.bezierPoints[tripleIndex][1][1] + ") (" + this.bezierPoints[tripleIndex][2][0] + ", " + this.bezierPoints[tripleIndex][2][1] + ")]";
        }
        return "[(" + this.bezierPoints[tripleIndex][0][0] + ", " + this.bezierPoints[tripleIndex][0][1] + ", " + this.bezierPoints[tripleIndex][0][2] + ") (" + this.bezierPoints[tripleIndex][1][0] + ", " + this.bezierPoints[tripleIndex][1][1] + ", " + this.bezierPoints[tripleIndex][1][2] + ") (" + this.bezierPoints[tripleIndex][2][0] + ", " + this.bezierPoints[tripleIndex][2][1] + ", " + this.bezierPoints[tripleIndex][2][2] + ")]";
    }
}

