/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.textures;

import com.jme3.scene.plugins.blender.DataRepository;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.blender.textures.NoiseGenerator;
import com.jme3.scene.plugins.blender.textures.TextureGenerator;
import com.jme3.scene.plugins.blender.textures.TextureHelper;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.texture.Texture3D;
import com.jme3.util.BufferUtils;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public class TextureGeneratorMusgrave
extends TextureGenerator {
    public TextureGeneratorMusgrave(NoiseGenerator noiseGenerator) {
        super(noiseGenerator);
    }

    protected Texture generate(Structure tex, int width, int height, int depth, DataRepository dataRepository) {
        int stype = ((Number)tex.getFieldValue("stype")).intValue();
        float noisesize = ((Number)tex.getFieldValue("noisesize")).floatValue();
        TextureHelper.TexResult texres = new TextureHelper.TexResult();
        float[] texvec = new float[]{0.0f, 0.0f, 0.0f};
        float wDelta = 1.0f / (float)width;
        float hDelta = 1.0f / (float)height;
        float dDelta = 1.0f / (float)depth;
        int halfW = width;
        int halfH = height;
        int halfD = depth;
        TextureHelper.ColorBand colorBand = this.readColorband(tex, dataRepository);
        Image.Format format = colorBand != null ? Image.Format.RGB8 : Image.Format.Luminance8;
        int bytesPerPixel = colorBand != null ? 3 : 1;
        ByteBuffer data = BufferUtils.createByteBuffer((width <<= 1) * (height <<= 1) * (depth <<= 1) * bytesPerPixel);
        for (int i = -halfW; i < halfW; ++i) {
            texvec[0] = wDelta * (float)i / noisesize;
            for (int j = -halfH; j < halfH; ++j) {
                texvec[1] = hDelta * (float)j / noisesize;
                for (int k = -halfD; k < halfD; ++k) {
                    texvec[2] = dDelta * (float)k / noisesize;
                    switch (stype) {
                        case 0: 
                        case 3: {
                            this.noiseGenerator.mgMFractalOrfBmTex(tex, texvec, colorBand, texres, dataRepository);
                            break;
                        }
                        case 1: 
                        case 2: {
                            this.noiseGenerator.mgRidgedOrHybridMFTex(tex, texvec, colorBand, texres, dataRepository);
                            break;
                        }
                        case 4: {
                            this.noiseGenerator.mgHTerrainTex(tex, texvec, colorBand, texres, dataRepository);
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unknown type of musgrave texture: " + stype);
                        }
                    }
                    if (colorBand != null) {
                        this.noiseGenerator.doColorband(colorBand, texres, dataRepository);
                        data.put((byte)(texres.tr * 255.0f));
                        data.put((byte)(texres.tg * 255.0f));
                        data.put((byte)(texres.tb * 255.0f));
                        continue;
                    }
                    data.put((byte)(texres.tin * 255.0f));
                }
            }
        }
        ArrayList<ByteBuffer> dataArray = new ArrayList<ByteBuffer>(1);
        dataArray.add(data);
        return new Texture3D(new Image(format, width, height, depth, dataArray));
    }
}

