/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.render.image;

import de.lessvoid.nifty.ParameterizedObjectFactory;
import de.lessvoid.nifty.render.image.CompoundImageMode;
import de.lessvoid.nifty.render.image.ImageMode;
import de.lessvoid.nifty.render.image.areaprovider.AreaProvider;
import de.lessvoid.nifty.render.image.areaprovider.CachedAreaProvider;
import de.lessvoid.nifty.render.image.areaprovider.FullImageAreaProvider;
import de.lessvoid.nifty.render.image.areaprovider.SpriteAreaProvider;
import de.lessvoid.nifty.render.image.areaprovider.SubImageAreaProvider;
import de.lessvoid.nifty.render.image.renderstrategy.ClampStrategy;
import de.lessvoid.nifty.render.image.renderstrategy.NinePartResizeStrategy;
import de.lessvoid.nifty.render.image.renderstrategy.RenderStrategy;
import de.lessvoid.nifty.render.image.renderstrategy.RepeatStrategy;
import de.lessvoid.nifty.render.image.renderstrategy.ResizeStrategy;
import java.util.HashMap;
import java.util.Map;

public class ImageModeFactory {
    private static ImageModeFactory s_sharedInstance = null;
    private final ParameterizedObjectFactory<AreaProvider> m_areaProviderFactory;
    private final ParameterizedObjectFactory<RenderStrategy> m_renderStrategyFactory;

    public ImageModeFactory(Map<String, Class<? extends AreaProvider>> areaProviderMapping, String fallbackAreaProvider, Map<String, Class<? extends RenderStrategy>> renderStrategyMapping, String fallbackRenderStrategyName) {
        this.m_areaProviderFactory = new ParameterizedObjectFactory<AreaProvider>(areaProviderMapping, fallbackAreaProvider);
        this.m_renderStrategyFactory = new ParameterizedObjectFactory<RenderStrategy>(renderStrategyMapping, fallbackRenderStrategyName);
    }

    public ImageMode createImageMode(String areaProviderDescription, String renderStrategyDescription) {
        return new CompoundImageMode(new CachedAreaProvider(this.m_areaProviderFactory.create(areaProviderDescription)), this.m_renderStrategyFactory.create(renderStrategyDescription));
    }

    public static synchronized ImageModeFactory getSharedInstance() {
        if (s_sharedInstance == null) {
            HashMap<String, Class<? extends AreaProvider>> areaProviderMapping = new HashMap<String, Class<? extends AreaProvider>>();
            areaProviderMapping.put("fullimage", FullImageAreaProvider.class);
            areaProviderMapping.put("sprite", SpriteAreaProvider.class);
            areaProviderMapping.put("subimage", SubImageAreaProvider.class);
            HashMap<String, Class<? extends RenderStrategy>> renderStrategyMapping = new HashMap<String, Class<? extends RenderStrategy>>();
            renderStrategyMapping.put("clamp", ClampStrategy.class);
            renderStrategyMapping.put("nine-part", NinePartResizeStrategy.class);
            renderStrategyMapping.put("repeat", RepeatStrategy.class);
            renderStrategyMapping.put("resize", ResizeStrategy.class);
            s_sharedInstance = new ImageModeFactory(areaProviderMapping, "fullimage", renderStrategyMapping, "resize");
        }
        return s_sharedInstance;
    }
}

