/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.renderer.lwjgl.render;

import de.lessvoid.nifty.render.BlendMode;
import de.lessvoid.nifty.renderer.lwjgl.render.LwjglMouseCursor;
import de.lessvoid.nifty.renderer.lwjgl.render.LwjglRenderFont;
import de.lessvoid.nifty.renderer.lwjgl.render.LwjglRenderImage;
import de.lessvoid.nifty.renderer.lwjgl.render.io.ImageData;
import de.lessvoid.nifty.renderer.lwjgl.render.io.ImageIOImageData;
import de.lessvoid.nifty.renderer.lwjgl.render.io.TGAImageData;
import de.lessvoid.nifty.spi.render.MouseCursor;
import de.lessvoid.nifty.spi.render.RenderDevice;
import de.lessvoid.nifty.spi.render.RenderFont;
import de.lessvoid.nifty.spi.render.RenderImage;
import de.lessvoid.nifty.tools.Color;
import de.lessvoid.nifty.tools.resourceloader.ResourceLoader;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.logging.Logger;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.input.Cursor;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class LwjglRenderDevice
implements RenderDevice {
    private static Logger log = Logger.getLogger(LwjglRenderDevice.class.getName());
    private static IntBuffer viewportBuffer = BufferUtils.createIntBuffer((int)16);
    private int viewportWidth;
    private int viewportHeight;
    private long time = System.currentTimeMillis();
    private long frames = 0L;
    private long lastFrames;
    private boolean displayFPS = false;
    private boolean logFPS = false;
    private RenderFont fpsFont;
    private boolean currentTexturing = true;
    private BlendMode currentBlendMode = null;
    private boolean currentClipping = false;
    private int currentClippingX0 = 0;
    private int currentClippingY0 = 0;
    private int currentClippingX1 = 0;
    private int currentClippingY1 = 0;

    public LwjglRenderDevice() {
    }

    public LwjglRenderDevice(boolean displayFPS) {
        this();
        this.logFPS = true;
        this.displayFPS = displayFPS;
        if (this.displayFPS) {
            this.fpsFont = this.createFont("fps.fnt");
        }
    }

    public int getWidth() {
        this.getViewport();
        return this.viewportWidth;
    }

    public int getHeight() {
        this.getViewport();
        return this.viewportHeight;
    }

    private void getViewport() {
        GL11.glGetInteger((int)2978, (IntBuffer)viewportBuffer);
        this.viewportWidth = viewportBuffer.get(2);
        this.viewportHeight = viewportBuffer.get(3);
        log.info("Viewport: " + this.viewportWidth + ", " + this.viewportHeight);
    }

    public void beginFrame() {
        log.fine("beginFrame()");
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        this.setBlendMode(BlendMode.BLEND);
        GL11.glEnable((int)3553);
        this.currentTexturing = true;
        GL11.glDisable((int)3089);
        this.currentClipping = false;
        this.currentClippingX0 = 0;
        this.currentClippingY0 = 0;
        this.currentClippingX1 = 0;
        this.currentClippingY1 = 0;
    }

    public void endFrame() {
        log.fine("endFrame");
        ++this.frames;
        long diff = System.currentTimeMillis() - this.time;
        if (diff >= 1000L) {
            this.time += diff;
            this.lastFrames = this.frames;
            if (this.logFPS) {
                System.out.println("fps: " + this.frames);
            }
            this.frames = 0L;
        }
        if (this.displayFPS) {
            this.renderFont(this.fpsFont, "FPS: " + String.valueOf(this.lastFrames), 10, this.getHeight() - this.fpsFont.getHeight() - 10, Color.WHITE, 1.0f);
        }
    }

    public void clear() {
        log.fine("clear()");
        GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glClear((int)16384);
    }

    public RenderImage createImage(String filename, boolean filterLinear) {
        return new LwjglRenderImage(filename, filterLinear);
    }

    public RenderFont createFont(String filename) {
        return new LwjglRenderFont(filename, this);
    }

    public void renderQuad(int x, int y, int width, int height, Color color) {
        log.fine("renderQuad()");
        if (this.currentTexturing) {
            GL11.glDisable((int)3553);
            this.currentTexturing = false;
        }
        GL11.glColor4f((float)color.getRed(), (float)color.getGreen(), (float)color.getBlue(), (float)color.getAlpha());
        GL11.glBegin((int)7);
        GL11.glVertex2i((int)x, (int)y);
        GL11.glVertex2i((int)(x + width), (int)y);
        GL11.glVertex2i((int)(x + width), (int)(y + height));
        GL11.glVertex2i((int)x, (int)(y + height));
        GL11.glEnd();
    }

    public void renderQuad(int x, int y, int width, int height, Color topLeft, Color topRight, Color bottomRight, Color bottomLeft) {
        log.fine("renderQuad2()");
        if (this.currentTexturing) {
            GL11.glDisable((int)3553);
            this.currentTexturing = false;
        }
        GL11.glBegin((int)7);
        GL11.glColor4f((float)topLeft.getRed(), (float)topLeft.getGreen(), (float)topLeft.getBlue(), (float)topLeft.getAlpha());
        GL11.glVertex2i((int)x, (int)y);
        GL11.glColor4f((float)topRight.getRed(), (float)topRight.getGreen(), (float)topRight.getBlue(), (float)topRight.getAlpha());
        GL11.glVertex2i((int)(x + width), (int)y);
        GL11.glColor4f((float)bottomRight.getRed(), (float)bottomRight.getGreen(), (float)bottomRight.getBlue(), (float)bottomRight.getAlpha());
        GL11.glVertex2i((int)(x + width), (int)(y + height));
        GL11.glColor4f((float)bottomLeft.getRed(), (float)bottomLeft.getGreen(), (float)bottomLeft.getBlue(), (float)bottomLeft.getAlpha());
        GL11.glVertex2i((int)x, (int)(y + height));
        GL11.glEnd();
    }

    public void renderImage(RenderImage image, int x, int y, int width, int height, Color color, float scale) {
        log.fine("renderImage()");
        if (width < 0) {
            log.warning("Attempt to render image with negative width");
            return;
        }
        if (height < 0) {
            log.warning("Attempt to render image with negative height");
            return;
        }
        if (!this.currentTexturing) {
            GL11.glEnable((int)3553);
            this.currentTexturing = true;
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(x + width / 2), (float)(y + height / 2), (float)0.0f);
        GL11.glScalef((float)scale, (float)scale, (float)1.0f);
        GL11.glTranslatef((float)(-(x + width / 2)), (float)(-(y + height / 2)), (float)0.0f);
        LwjglRenderImage internalImage = (LwjglRenderImage)image;
        internalImage.bind();
        float textureWidth = internalImage.getTextureWidth();
        float textureHeight = internalImage.getTextureHeight();
        float imageWidth = internalImage.getWidth();
        float imageHeight = internalImage.getHeight();
        float u1 = imageWidth / textureWidth;
        float v1 = imageHeight / textureHeight;
        GL11.glColor4f((float)color.getRed(), (float)color.getGreen(), (float)color.getBlue(), (float)color.getAlpha());
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex2i((int)x, (int)y);
        GL11.glTexCoord2f((float)u1, (float)0.0f);
        GL11.glVertex2i((int)(x + width), (int)y);
        GL11.glTexCoord2f((float)u1, (float)v1);
        GL11.glVertex2i((int)(x + width), (int)(y + height));
        GL11.glTexCoord2f((float)0.0f, (float)v1);
        GL11.glVertex2i((int)x, (int)(y + height));
        GL11.glEnd();
        GL11.glPopMatrix();
    }

    public void renderImage(RenderImage image, int x, int y, int w, int h, int srcX, int srcY, int srcW, int srcH, Color color, float scale, int centerX, int centerY) {
        log.fine("renderImage2()");
        if (w < 0) {
            log.warning("Attempt to render image with negative width");
            return;
        }
        if (h < 0) {
            log.warning("Attempt to render image with negative height");
            return;
        }
        if (!this.currentTexturing) {
            GL11.glEnable((int)3553);
            this.currentTexturing = true;
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)centerX, (float)centerY, (float)0.0f);
        GL11.glScalef((float)scale, (float)scale, (float)1.0f);
        GL11.glTranslatef((float)(-centerX), (float)(-centerY), (float)0.0f);
        LwjglRenderImage internalImage = (LwjglRenderImage)image;
        internalImage.bind();
        float textureWidth = internalImage.getTextureWidth();
        float textureHeight = internalImage.getTextureHeight();
        float u0 = (float)srcX / textureWidth;
        float v0 = (float)srcY / textureHeight;
        float u1 = (float)(srcX + srcW) / textureWidth;
        float v1 = (float)(srcY + srcH) / textureHeight;
        GL11.glColor4f((float)color.getRed(), (float)color.getGreen(), (float)color.getBlue(), (float)color.getAlpha());
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)u0, (float)v0);
        GL11.glVertex2i((int)x, (int)y);
        GL11.glTexCoord2f((float)u1, (float)v0);
        GL11.glVertex2i((int)(x + w), (int)y);
        GL11.glTexCoord2f((float)u1, (float)v1);
        GL11.glVertex2i((int)(x + w), (int)(y + h));
        GL11.glTexCoord2f((float)u0, (float)v1);
        GL11.glVertex2i((int)x, (int)(y + h));
        GL11.glEnd();
        GL11.glPopMatrix();
    }

    public void renderFont(RenderFont font, String text, int x, int y, Color color, float fontSize) {
        log.fine("renderFont()");
        if (!this.currentTexturing) {
            GL11.glEnable((int)3553);
            this.currentTexturing = true;
        }
        this.setBlendMode(BlendMode.BLEND);
        if (color == null) {
            ((LwjglRenderFont)font).getFont().drawStringWithSize(x, y, text, fontSize);
        } else {
            ((LwjglRenderFont)font).getFont().renderWithSizeAndColor(x, y, text, fontSize, color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
        }
    }

    public void enableClip(int x0, int y0, int x1, int y1) {
        log.fine("enableClip()");
        if (this.currentClipping && this.currentClippingX0 == x0 && this.currentClippingY0 == y0 && this.currentClippingX1 == x1 && this.currentClippingY1 == y1) {
            return;
        }
        this.currentClipping = true;
        this.currentClippingX0 = x0;
        this.currentClippingY0 = y0;
        this.currentClippingX1 = x1;
        this.currentClippingY1 = y1;
        GL11.glScissor((int)x0, (int)(this.getHeight() - y1), (int)(x1 - x0), (int)(y1 - y0));
        GL11.glEnable((int)3089);
    }

    public void disableClip() {
        log.fine("disableClip()");
        if (!this.currentClipping) {
            return;
        }
        GL11.glDisable((int)3089);
        this.currentClipping = false;
        this.currentClippingX0 = 0;
        this.currentClippingY0 = 0;
        this.currentClippingX1 = 0;
        this.currentClippingY1 = 0;
    }

    public void setBlendMode(BlendMode renderMode) {
        log.fine("setBlendMode()");
        if (renderMode.equals((Object)this.currentBlendMode)) {
            return;
        }
        this.currentBlendMode = renderMode;
        if (this.currentBlendMode.equals((Object)BlendMode.BLEND)) {
            GL11.glBlendFunc((int)770, (int)771);
        } else if (this.currentBlendMode.equals((Object)BlendMode.MULIPLY)) {
            GL11.glBlendFunc((int)774, (int)0);
        }
    }

    public MouseCursor createMouseCursor(String filename, int hotspotX, int hotspotY) throws IOException {
        return new LwjglMouseCursor(this.loadMouseCursor(filename, hotspotX, hotspotY));
    }

    public void enableMouseCursor(MouseCursor mouseCursor) {
        Cursor nativeCursor = null;
        if (mouseCursor != null) {
            nativeCursor = ((LwjglMouseCursor)mouseCursor).getCursor();
        }
        try {
            Mouse.setNativeCursor(nativeCursor);
        }
        catch (LWJGLException e) {
            log.warning(e.getMessage());
        }
    }

    public void disableMouseCursor() {
        try {
            Mouse.setNativeCursor(null);
        }
        catch (LWJGLException e) {
            log.warning(e.getMessage());
        }
    }

    private Cursor loadMouseCursor(String name, int hotspotX, int hotspotY) throws IOException {
        ImageData imageLoader = this.createImageLoader(name);
        ByteBuffer imageData = imageLoader.loadMouseCursorImage(ResourceLoader.getResourceAsStream((String)name));
        imageData.rewind();
        int width = imageLoader.getWidth();
        int height = imageLoader.getHeight();
        try {
            return new Cursor(width, height, hotspotX, height - hotspotY - 1, 1, imageData.asIntBuffer(), null);
        }
        catch (LWJGLException e) {
            throw new IOException(e);
        }
    }

    private ImageData createImageLoader(String name) {
        if (name.endsWith(".tga")) {
            return new TGAImageData();
        }
        return new ImageIOImageData();
    }
}

