/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls.scrollbar;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.NiftyEvent;
import de.lessvoid.nifty.controls.AbstractController;
import de.lessvoid.nifty.controls.NextPrevHelper;
import de.lessvoid.nifty.controls.Scrollbar;
import de.lessvoid.nifty.controls.ScrollbarChangedEvent;
import de.lessvoid.nifty.controls.scrollbar.ScrollbarImpl;
import de.lessvoid.nifty.controls.scrollbar.ScrollbarView;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.input.NiftyInputEvent;
import de.lessvoid.nifty.input.NiftyMouseInputEvent;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.nifty.tools.SizeValue;
import de.lessvoid.xml.xpp3.Attributes;
import java.util.Properties;

@Deprecated
public class ScrollbarControl
extends AbstractController
implements Scrollbar {
    private ScrollbarImpl scrollbarImpl = new ScrollbarImpl();
    private ScrollbarView scrollbarView;
    private Nifty nifty;
    private Element elementBackground;
    private Element elementPosition;
    private NextPrevHelper nextPrevHelper;
    private float worldMax;
    private float worldPageSize;
    private float initial;
    private float pageStepSize;
    private float buttonStepSize;

    public void bind(Nifty nifty, Screen screen, Element element, Properties parameter, Attributes controlDefinitionAttributes) {
        super.bind(element);
        this.nifty = nifty;
        this.elementBackground = element.findElementByName("#background");
        this.elementPosition = element.findElementByName("#position");
        this.nextPrevHelper = new NextPrevHelper(element, screen.getFocusHandler());
        if ("verticalScrollbar".equals(parameter.getProperty("name"))) {
            this.scrollbarView = new ScrollbarViewVertical(this, this.elementPosition.getHeight());
        } else if ("horizontalScrollbar".equals(parameter.getProperty("name"))) {
            this.scrollbarView = new ScrollbarViewHorizontal(this, this.elementPosition.getWidth());
        }
        this.worldMax = Float.valueOf(parameter.getProperty("worldMax", "100.0")).floatValue();
        this.worldPageSize = Float.valueOf(parameter.getProperty("worldPageSize", "100.0")).floatValue();
        this.initial = Float.valueOf(parameter.getProperty("initial", "0.0")).floatValue();
        this.buttonStepSize = Float.valueOf(parameter.getProperty("buttonStepSize", "1.0")).floatValue();
        this.pageStepSize = Float.valueOf(parameter.getProperty("pageStepSize", "25.0")).floatValue();
        this.scrollbarImpl.bindToView(this.scrollbarView, this.initial, this.worldMax, this.worldPageSize, this.buttonStepSize, this.pageStepSize);
    }

    public void onStartScreen() {
    }

    public void layoutCallback() {
        this.scrollbarImpl.updateView();
    }

    public boolean inputEvent(NiftyInputEvent inputEvent) {
        if (this.nextPrevHelper.handleNextPrev(inputEvent)) {
            return true;
        }
        if (inputEvent == NiftyInputEvent.MoveCursorUp || inputEvent == NiftyInputEvent.MoveCursorLeft) {
            this.scrollbarImpl.stepDown();
            return true;
        }
        if (inputEvent == NiftyInputEvent.MoveCursorDown || inputEvent == NiftyInputEvent.MoveCursorRight) {
            this.scrollbarImpl.stepUp();
            return true;
        }
        return false;
    }

    public void upClick() {
        this.scrollbarImpl.stepDown();
    }

    public void downClick() {
        this.scrollbarImpl.stepUp();
    }

    public void click(int mouseX, int mouseY) {
        this.scrollbarImpl.interactionClick(this.scrollbarView.filter(mouseX, mouseY));
    }

    public void mouseMoveStart(int mouseX, int mouseY) {
        this.scrollbarImpl.interactionClick(this.scrollbarView.filter(mouseX, mouseY));
    }

    public void mouseMove(int mouseX, int mouseY) {
        this.scrollbarImpl.interactionMove(this.scrollbarView.filter(mouseX, mouseY));
    }

    public boolean consumeRelease() {
        return true;
    }

    public void mouseWheel(Element element, NiftyMouseInputEvent inputEvent) {
        int mouseWheel = inputEvent.getMouseWheel();
        float currentValue = this.scrollbarImpl.getValue();
        if (mouseWheel < 0) {
            this.scrollbarImpl.setValue(currentValue - this.scrollbarImpl.getButtonStepSize() * (float)mouseWheel);
        } else if (mouseWheel > 0) {
            this.scrollbarImpl.setValue(currentValue - this.scrollbarImpl.getButtonStepSize() * (float)mouseWheel);
        }
    }

    @Override
    public void setup(float value, float worldMax, float worldPageSize, float buttonStepSize, float pageStepSize) {
        this.scrollbarImpl.setup(value, worldMax, worldPageSize, buttonStepSize, pageStepSize);
    }

    @Override
    public void setValue(float value) {
        this.scrollbarImpl.setValue(value);
    }

    @Override
    public float getValue() {
        return this.scrollbarImpl.getValue();
    }

    @Override
    public void setWorldMax(float worldMax) {
        this.scrollbarImpl.setWorldMax(worldMax);
    }

    @Override
    public float getWorldMax() {
        return this.scrollbarImpl.getWorldMax();
    }

    @Override
    public void setWorldPageSize(float worldPageSize) {
        this.scrollbarImpl.setWorldPageSize(worldPageSize);
    }

    @Override
    public float getWorldPageSize() {
        return this.scrollbarImpl.getWorldPageSize();
    }

    @Override
    public void setButtonStepSize(float stepSize) {
        this.scrollbarImpl.setButtonStepSize(stepSize);
    }

    @Override
    public float getButtonStepSize() {
        return this.scrollbarImpl.getButtonStepSize();
    }

    @Override
    public void setPageStepSize(float stepSize) {
        this.scrollbarImpl.setPageStepSize(stepSize);
    }

    @Override
    public float getPageStepSize() {
        return this.scrollbarImpl.getPageStepSize();
    }

    private class ScrollbarViewHorizontal
    implements ScrollbarView {
        private Scrollbar scrollbar;
        private int minHandleSize;

        public ScrollbarViewHorizontal(Scrollbar scrollbar, int minHandleSize) {
            this.scrollbar = scrollbar;
            this.minHandleSize = minHandleSize;
        }

        @Override
        public int getAreaSize() {
            return ScrollbarControl.this.elementBackground.getWidth();
        }

        @Override
        public int getMinHandleSize() {
            return this.minHandleSize;
        }

        @Override
        public void setHandle(int pos, int size) {
            if (ScrollbarControl.this.elementBackground.getWidth() < this.minHandleSize) {
                if (ScrollbarControl.this.getElement().isVisible()) {
                    ScrollbarControl.this.elementPosition.hide();
                }
            } else {
                if (ScrollbarControl.this.getElement().isVisible()) {
                    ScrollbarControl.this.elementPosition.show();
                }
                ScrollbarControl.this.elementPosition.setConstraintX(new SizeValue(pos + "px"));
                ScrollbarControl.this.elementPosition.setConstraintWidth(new SizeValue(size + "px"));
                ScrollbarControl.this.elementBackground.layoutElements();
            }
        }

        @Override
        public void valueChanged(float value) {
            if (ScrollbarControl.this.getElement().getId() != null) {
                ScrollbarControl.this.nifty.publishEvent(ScrollbarControl.this.getElement().getId(), (NiftyEvent)new ScrollbarChangedEvent(this.scrollbar, value));
            }
        }

        @Override
        public int filter(int pixelX, int pixelY) {
            return pixelX - ScrollbarControl.this.elementBackground.getX();
        }
    }

    private class ScrollbarViewVertical
    implements ScrollbarView {
        private Scrollbar scrollbar;
        private int minHandleSize;

        public ScrollbarViewVertical(Scrollbar scrollbar, int minHandleSize) {
            this.scrollbar = scrollbar;
            this.minHandleSize = minHandleSize;
        }

        @Override
        public int getAreaSize() {
            return ScrollbarControl.this.elementBackground.getHeight();
        }

        @Override
        public int getMinHandleSize() {
            return this.minHandleSize;
        }

        @Override
        public void setHandle(int pos, int size) {
            if (ScrollbarControl.this.elementBackground.getHeight() < this.minHandleSize) {
                if (ScrollbarControl.this.getElement().isVisible()) {
                    ScrollbarControl.this.elementPosition.hide();
                }
            } else {
                if (ScrollbarControl.this.getElement().isVisible()) {
                    ScrollbarControl.this.elementPosition.show();
                }
                ScrollbarControl.this.elementPosition.setConstraintY(new SizeValue(pos + "px"));
                ScrollbarControl.this.elementPosition.setConstraintHeight(new SizeValue(size + "px"));
                ScrollbarControl.this.elementBackground.layoutElements();
            }
        }

        @Override
        public void valueChanged(float value) {
            if (ScrollbarControl.this.getElement().getId() != null) {
                ScrollbarControl.this.nifty.publishEvent(ScrollbarControl.this.getElement().getId(), (NiftyEvent)new ScrollbarChangedEvent(this.scrollbar, value));
            }
        }

        @Override
        public int filter(int pixelX, int pixelY) {
            return pixelY - ScrollbarControl.this.elementBackground.getY();
        }
    }
}

