/*
 * Decompiled with CFR 0.152.
 */
package jme3test.batching;

import com.jme3.app.SimpleApplication;
import com.jme3.light.DirectionalLight;
import com.jme3.light.Light;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.FastMath;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.BatchedGeometry;
import com.jme3.scene.Geometry;
import com.jme3.scene.GeometryBatch;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Box;
import com.jme3.util.TangentBinormalGenerator;

public class TestGeometryBatch
extends SimpleApplication {
    GeometryBatch batch;
    BatchedGeometry batchedCube1;
    BatchedGeometry batchedCube2;
    Geometry cube2;
    float time = 0.0f;
    DirectionalLight dl;

    public static void main(String[] args) {
        TestGeometryBatch app = new TestGeometryBatch();
        app.start();
    }

    public void simpleInitApp() {
        this.batch = new GeometryBatch("MyBatch");
        Box boxshape4 = new Box(Vector3f.ZERO, 1.0f, 1.0f, 1.0f);
        Geometry cube = new Geometry("cube1", (Mesh)boxshape4);
        Material mat = this.assetManager.loadMaterial("Textures/Terrain/Pond/Pond.j3m");
        Box box = new Box(Vector3f.ZERO, 1.0f, 1.0f, 1.0f);
        this.cube2 = new Geometry("cube2", (Mesh)box);
        cube.setLocalTranslation(3.0f, 0.0f, 0.0f);
        this.cube2.setLocalTranslation(0.0f, 3.0f, 0.0f);
        TangentBinormalGenerator.generate((Spatial)cube);
        TangentBinormalGenerator.generate((Spatial)this.cube2);
        this.batch.batch(new Geometry[]{cube, this.cube2});
        this.batchedCube1 = (BatchedGeometry)this.batch.getChild("cube1");
        this.batchedCube2 = (BatchedGeometry)this.batch.getChild("cube2");
        this.batch.setMaterial(mat);
        this.rootNode.attachChild((Spatial)this.batch);
        this.dl = new DirectionalLight();
        this.dl.setColor(ColorRGBA.White.mult(2.0f));
        this.dl.setDirection(new Vector3f(1.0f, -1.0f, -1.0f));
        this.rootNode.addLight((Light)this.dl);
        this.flyCam.setMoveSpeed(10.0f);
    }

    public void simpleUpdate(float tpf) {
        this.time += tpf;
        this.dl.setDirection(this.cam.getDirection());
        this.batchedCube2.setLocalTranslation(FastMath.sin((float)(-this.time)) * 3.0f, FastMath.cos((float)this.time) * 3.0f, 0.0f);
        this.batchedCube2.setLocalRotation(new Quaternion().fromAngleAxis(this.time, Vector3f.UNIT_Z));
        this.batchedCube2.setLocalScale(Math.max(FastMath.sin((float)this.time), 0.5f));
        this.batch.setLocalRotation(new Quaternion().fromAngleAxis(this.time, Vector3f.UNIT_Z));
    }
}

