/*
 * Decompiled with CFR 0.152.
 */
package jme3test.bullet;

import com.jme3.asset.AssetManager;
import com.jme3.bullet.PhysicsSpace;
import com.jme3.bullet.PhysicsTickListener;
import com.jme3.bullet.collision.PhysicsCollisionEvent;
import com.jme3.bullet.collision.PhysicsCollisionListener;
import com.jme3.bullet.collision.PhysicsCollisionObject;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.collision.shapes.SphereCollisionShape;
import com.jme3.bullet.control.RigidBodyControl;
import com.jme3.bullet.objects.PhysicsGhostObject;
import com.jme3.bullet.objects.PhysicsRigidBody;
import com.jme3.effect.ParticleEmitter;
import com.jme3.effect.ParticleMesh;
import com.jme3.effect.shapes.EmitterShape;
import com.jme3.effect.shapes.EmitterSphereShape;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.scene.Spatial;
import java.io.IOException;

public class BombControl
extends RigidBodyControl
implements PhysicsCollisionListener,
PhysicsTickListener {
    private float explosionRadius = 10.0f;
    private PhysicsGhostObject ghostObject;
    private Vector3f vector = new Vector3f();
    private Vector3f vector2 = new Vector3f();
    private float forceFactor = 1.0f;
    private ParticleEmitter effect;
    private float fxTime = 0.5f;
    private float maxTime = 4.0f;
    private float curTime = -1.0f;
    private float timer;

    public BombControl(CollisionShape shape, float mass) {
        super(shape, mass);
        this.createGhostObject();
    }

    public BombControl(AssetManager manager, CollisionShape shape, float mass) {
        super(shape, mass);
        this.createGhostObject();
        this.prepareEffect(manager);
    }

    public void setPhysicsSpace(PhysicsSpace space) {
        super.setPhysicsSpace(space);
        if (space != null) {
            space.addCollisionListener((PhysicsCollisionListener)this);
        }
    }

    private void prepareEffect(AssetManager assetManager) {
        int COUNT_FACTOR = 1;
        float COUNT_FACTOR_F = 1.0f;
        this.effect = new ParticleEmitter("Flame", ParticleMesh.Type.Triangle, 32 * COUNT_FACTOR);
        this.effect.setSelectRandomImage(true);
        this.effect.setStartColor(new ColorRGBA(1.0f, 0.4f, 0.05f, 1.0f / COUNT_FACTOR_F));
        this.effect.setEndColor(new ColorRGBA(0.4f, 0.22f, 0.12f, 0.0f));
        this.effect.setStartSize(1.3f);
        this.effect.setEndSize(2.0f);
        this.effect.setShape((EmitterShape)new EmitterSphereShape(Vector3f.ZERO, 1.0f));
        this.effect.setParticlesPerSec(0.0f);
        this.effect.setGravity(0.0f, -5.0f, 0.0f);
        this.effect.setLowLife(0.4f);
        this.effect.setHighLife(0.5f);
        this.effect.setInitialVelocity(new Vector3f(0.0f, 7.0f, 0.0f));
        this.effect.setVelocityVariation(1.0f);
        this.effect.setImagesX(2);
        this.effect.setImagesY(2);
        Material mat = new Material(assetManager, "Common/MatDefs/Misc/Particle.j3md");
        mat.setTexture("Texture", assetManager.loadTexture("Effects/Explosion/flame.png"));
        this.effect.setMaterial(mat);
    }

    protected void createGhostObject() {
        this.ghostObject = new PhysicsGhostObject((CollisionShape)new SphereCollisionShape(this.explosionRadius));
    }

    public void collision(PhysicsCollisionEvent event) {
        if (this.space == null) {
            return;
        }
        if (event.getObjectA() == this || event.getObjectB() == this) {
            this.space.add((Object)this.ghostObject);
            this.ghostObject.setPhysicsLocation(this.getPhysicsLocation(this.vector));
            this.space.addTickListener((PhysicsTickListener)this);
            if (this.effect != null && this.spatial.getParent() != null) {
                this.curTime = 0.0f;
                this.effect.setLocalTranslation(this.spatial.getLocalTranslation());
                this.spatial.getParent().attachChild((Spatial)this.effect);
                this.effect.emitAllParticles();
            }
            this.space.remove((Object)this);
            this.spatial.removeFromParent();
        }
    }

    public void prePhysicsTick(PhysicsSpace space, float f) {
        space.removeCollisionListener((PhysicsCollisionListener)this);
    }

    public void physicsTick(PhysicsSpace space, float f) {
        for (PhysicsCollisionObject physicsCollisionObject : this.ghostObject.getOverlappingObjects()) {
            if (!(physicsCollisionObject instanceof PhysicsRigidBody)) continue;
            PhysicsRigidBody rBody = (PhysicsRigidBody)physicsCollisionObject;
            rBody.getPhysicsLocation(this.vector2);
            this.vector2.subtractLocal(this.vector);
            float force = this.explosionRadius - this.vector2.length();
            force = force > 0.0f ? (force *= this.forceFactor) : 0.0f;
            this.vector2.normalizeLocal();
            this.vector2.multLocal(force);
            ((PhysicsRigidBody)physicsCollisionObject).applyImpulse(this.vector2, Vector3f.ZERO);
        }
        space.removeTickListener((PhysicsTickListener)this);
        space.remove((Object)this.ghostObject);
    }

    public void update(float tpf) {
        super.update(tpf);
        if (this.enabled) {
            this.timer += tpf;
            if (this.timer > this.maxTime && this.spatial.getParent() != null) {
                this.space.removeCollisionListener((PhysicsCollisionListener)this);
                this.space.remove((Object)this);
                this.spatial.removeFromParent();
            }
        }
        if (this.enabled && this.curTime >= 0.0f) {
            this.curTime += tpf;
            if (this.curTime > this.fxTime) {
                this.curTime = -1.0f;
                this.effect.removeFromParent();
            }
        }
    }

    public float getExplosionRadius() {
        return this.explosionRadius;
    }

    public void setExplosionRadius(float explosionRadius) {
        this.explosionRadius = explosionRadius;
        this.createGhostObject();
    }

    public float getForceFactor() {
        return this.forceFactor;
    }

    public void setForceFactor(float forceFactor) {
        this.forceFactor = forceFactor;
    }

    public void read(JmeImporter im) throws IOException {
        throw new UnsupportedOperationException("Reading not supported.");
    }

    public void write(JmeExporter ex) throws IOException {
        throw new UnsupportedOperationException("Saving not supported.");
    }
}

