/*
 * Decompiled with CFR 0.152.
 */
package jme3test.bullet;

import com.jme3.app.SimpleApplication;
import com.jme3.app.state.AppState;
import com.jme3.bounding.BoundingBox;
import com.jme3.bullet.BulletAppState;
import com.jme3.bullet.PhysicsSpace;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.control.VehicleControl;
import com.jme3.bullet.objects.VehicleWheel;
import com.jme3.bullet.util.CollisionShapeFactory;
import com.jme3.input.controls.ActionListener;
import com.jme3.input.controls.InputListener;
import com.jme3.input.controls.KeyTrigger;
import com.jme3.input.controls.Trigger;
import com.jme3.light.DirectionalLight;
import com.jme3.light.Light;
import com.jme3.math.FastMath;
import com.jme3.math.Matrix3f;
import com.jme3.math.Vector3f;
import com.jme3.post.SceneProcessor;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import com.jme3.shadow.BasicShadowRenderer;
import jme3test.bullet.PhysicsTestHelper;

public class TestFancyCar
extends SimpleApplication
implements ActionListener {
    private BulletAppState bulletAppState;
    private VehicleControl player;
    private VehicleWheel fr;
    private VehicleWheel fl;
    private VehicleWheel br;
    private VehicleWheel bl;
    private Node node_fr;
    private Node node_fl;
    private Node node_br;
    private Node node_bl;
    private float wheelRadius;
    private float steeringValue = 0.0f;
    private float accelerationValue = 0.0f;
    private Node carNode;

    public static void main(String[] args) {
        TestFancyCar app = new TestFancyCar();
        app.start();
    }

    private void setupKeys() {
        this.inputManager.addMapping("Lefts", new Trigger[]{new KeyTrigger(35)});
        this.inputManager.addMapping("Rights", new Trigger[]{new KeyTrigger(37)});
        this.inputManager.addMapping("Ups", new Trigger[]{new KeyTrigger(22)});
        this.inputManager.addMapping("Downs", new Trigger[]{new KeyTrigger(36)});
        this.inputManager.addMapping("Space", new Trigger[]{new KeyTrigger(57)});
        this.inputManager.addMapping("Reset", new Trigger[]{new KeyTrigger(28)});
        this.inputManager.addListener((InputListener)this, new String[]{"Lefts"});
        this.inputManager.addListener((InputListener)this, new String[]{"Rights"});
        this.inputManager.addListener((InputListener)this, new String[]{"Ups"});
        this.inputManager.addListener((InputListener)this, new String[]{"Downs"});
        this.inputManager.addListener((InputListener)this, new String[]{"Space"});
        this.inputManager.addListener((InputListener)this, new String[]{"Reset"});
    }

    public void simpleInitApp() {
        this.bulletAppState = new BulletAppState();
        this.stateManager.attach((AppState)this.bulletAppState);
        if (this.settings.getRenderer().startsWith("LWJGL")) {
            BasicShadowRenderer bsr = new BasicShadowRenderer(this.assetManager, 512);
            bsr.setDirection(new Vector3f(-0.5f, -0.3f, -0.3f).normalizeLocal());
            this.viewPort.addProcessor((SceneProcessor)bsr);
        }
        this.cam.setFrustumFar(150.0f);
        this.flyCam.setMoveSpeed(10.0f);
        this.setupKeys();
        PhysicsTestHelper.createPhysicsTestWorld(this.rootNode, this.assetManager, this.bulletAppState.getPhysicsSpace());
        this.buildPlayer();
        DirectionalLight dl = new DirectionalLight();
        dl.setDirection(new Vector3f(-0.5f, -1.0f, -0.3f).normalizeLocal());
        this.rootNode.addLight((Light)dl);
        dl = new DirectionalLight();
        dl.setDirection(new Vector3f(0.5f, -0.1f, 0.3f).normalizeLocal());
        this.rootNode.addLight((Light)dl);
    }

    private PhysicsSpace getPhysicsSpace() {
        return this.bulletAppState.getPhysicsSpace();
    }

    private Geometry findGeom(Spatial spatial, String name) {
        if (spatial instanceof Node) {
            Node node = (Node)spatial;
            for (int i = 0; i < node.getQuantity(); ++i) {
                Spatial child = node.getChild(i);
                Geometry result = this.findGeom(child, name);
                if (result == null) continue;
                return result;
            }
        } else if (spatial instanceof Geometry && spatial.getName().startsWith(name)) {
            return (Geometry)spatial;
        }
        return null;
    }

    private void buildPlayer() {
        float stiffness = 120.0f;
        float compValue = 0.2f;
        float dampValue = 0.3f;
        float mass = 400.0f;
        this.carNode = (Node)this.assetManager.loadModel("Models/Ferrari/Car.scene");
        this.carNode.setShadowMode(RenderQueue.ShadowMode.Cast);
        Geometry chasis = this.findGeom((Spatial)this.carNode, "Car");
        BoundingBox box = (BoundingBox)chasis.getModelBound();
        CollisionShape carHull = CollisionShapeFactory.createDynamicMeshShape((Spatial)chasis);
        this.player = new VehicleControl(carHull, 400.0f);
        this.carNode.addControl((Control)this.player);
        this.player.setSuspensionCompression(compValue * 2.0f * FastMath.sqrt((float)stiffness));
        this.player.setSuspensionDamping(dampValue * 2.0f * FastMath.sqrt((float)stiffness));
        this.player.setSuspensionStiffness(stiffness);
        this.player.setMaxSuspensionForce(10000.0f);
        Vector3f wheelDirection = new Vector3f(0.0f, -1.0f, 0.0f);
        Vector3f wheelAxle = new Vector3f(-1.0f, 0.0f, 0.0f);
        Geometry wheel_fr = this.findGeom((Spatial)this.carNode, "WheelFrontRight");
        wheel_fr.center();
        box = (BoundingBox)wheel_fr.getModelBound();
        this.wheelRadius = box.getYExtent();
        float back_wheel_h = this.wheelRadius * 1.7f - 1.0f;
        float front_wheel_h = this.wheelRadius * 1.9f - 1.0f;
        this.player.addWheel((Spatial)wheel_fr.getParent(), box.getCenter().add(0.0f, -front_wheel_h, 0.0f), wheelDirection, wheelAxle, 0.2f, this.wheelRadius, true);
        Geometry wheel_fl = this.findGeom((Spatial)this.carNode, "WheelFrontLeft");
        wheel_fl.center();
        box = (BoundingBox)wheel_fl.getModelBound();
        this.player.addWheel((Spatial)wheel_fl.getParent(), box.getCenter().add(0.0f, -front_wheel_h, 0.0f), wheelDirection, wheelAxle, 0.2f, this.wheelRadius, true);
        Geometry wheel_br = this.findGeom((Spatial)this.carNode, "WheelBackRight");
        wheel_br.center();
        box = (BoundingBox)wheel_br.getModelBound();
        this.player.addWheel((Spatial)wheel_br.getParent(), box.getCenter().add(0.0f, -back_wheel_h, 0.0f), wheelDirection, wheelAxle, 0.2f, this.wheelRadius, false);
        Geometry wheel_bl = this.findGeom((Spatial)this.carNode, "WheelBackLeft");
        wheel_bl.center();
        box = (BoundingBox)wheel_bl.getModelBound();
        this.player.addWheel((Spatial)wheel_bl.getParent(), box.getCenter().add(0.0f, -back_wheel_h, 0.0f), wheelDirection, wheelAxle, 0.2f, this.wheelRadius, false);
        this.player.getWheel(2).setFrictionSlip(4.0f);
        this.player.getWheel(3).setFrictionSlip(4.0f);
        this.rootNode.attachChild((Spatial)this.carNode);
        this.getPhysicsSpace().add((Object)this.player);
    }

    public void onAction(String binding, boolean value, float tpf) {
        if (binding.equals("Lefts")) {
            this.steeringValue = value ? (this.steeringValue += 0.5f) : (this.steeringValue += -0.5f);
            this.player.steer(this.steeringValue);
        } else if (binding.equals("Rights")) {
            this.steeringValue = value ? (this.steeringValue += -0.5f) : (this.steeringValue += 0.5f);
            this.player.steer(this.steeringValue);
        } else if (binding.equals("Ups")) {
            this.accelerationValue = value ? (this.accelerationValue -= 800.0f) : (this.accelerationValue += 800.0f);
            this.player.accelerate(this.accelerationValue);
            this.player.setCollisionShape(CollisionShapeFactory.createDynamicMeshShape((Spatial)this.findGeom((Spatial)this.carNode, "Car")));
        } else if (binding.equals("Downs")) {
            if (value) {
                this.player.brake(40.0f);
            } else {
                this.player.brake(0.0f);
            }
        } else if (binding.equals("Reset") && value) {
            System.out.println("Reset");
            this.player.setPhysicsLocation(Vector3f.ZERO);
            this.player.setPhysicsRotation(new Matrix3f());
            this.player.setLinearVelocity(Vector3f.ZERO);
            this.player.setAngularVelocity(Vector3f.ZERO);
            this.player.resetSuspension();
        }
    }

    public void simpleUpdate(float tpf) {
        this.cam.lookAt(this.carNode.getWorldTranslation(), Vector3f.UNIT_Y);
    }
}

