/*
 * Decompiled with CFR 0.152.
 */
package jme3test.bullet;

import com.jme3.app.SimpleApplication;
import com.jme3.app.state.AppState;
import com.jme3.bullet.BulletAppState;
import com.jme3.bullet.PhysicsSpace;
import com.jme3.bullet.collision.shapes.CapsuleCollisionShape;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.control.CharacterControl;
import com.jme3.input.controls.ActionListener;
import com.jme3.input.controls.InputListener;
import com.jme3.input.controls.KeyTrigger;
import com.jme3.input.controls.MouseButtonTrigger;
import com.jme3.input.controls.Trigger;
import com.jme3.math.Vector3f;
import com.jme3.renderer.RenderManager;
import com.jme3.scene.CameraNode;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.CameraControl;
import com.jme3.scene.control.Control;
import jme3test.bullet.PhysicsTestHelper;

public class TestPhysicsCharacter
extends SimpleApplication
implements ActionListener {
    private BulletAppState bulletAppState;
    private CharacterControl physicsCharacter;
    private Node characterNode;
    private CameraNode camNode;
    boolean rotate = false;
    private Vector3f walkDirection = new Vector3f(0.0f, 0.0f, 0.0f);
    private Vector3f viewDirection = new Vector3f(0.0f, 0.0f, 0.0f);
    boolean leftStrafe = false;
    boolean rightStrafe = false;
    boolean forward = false;
    boolean backward = false;
    boolean leftRotate = false;
    boolean rightRotate = false;

    public static void main(String[] args) {
        TestPhysicsCharacter app = new TestPhysicsCharacter();
        app.start();
    }

    private void setupKeys() {
        this.inputManager.addMapping("Strafe Left", new Trigger[]{new KeyTrigger(16), new KeyTrigger(44)});
        this.inputManager.addMapping("Strafe Right", new Trigger[]{new KeyTrigger(18), new KeyTrigger(45)});
        this.inputManager.addMapping("Rotate Left", new Trigger[]{new KeyTrigger(30), new KeyTrigger(203)});
        this.inputManager.addMapping("Rotate Right", new Trigger[]{new KeyTrigger(32), new KeyTrigger(205)});
        this.inputManager.addMapping("Walk Forward", new Trigger[]{new KeyTrigger(17), new KeyTrigger(200)});
        this.inputManager.addMapping("Walk Backward", new Trigger[]{new KeyTrigger(31), new KeyTrigger(208)});
        this.inputManager.addMapping("Jump", new Trigger[]{new KeyTrigger(57), new KeyTrigger(28)});
        this.inputManager.addMapping("Shoot", new Trigger[]{new MouseButtonTrigger(0)});
        this.inputManager.addListener((InputListener)this, new String[]{"Strafe Left", "Strafe Right"});
        this.inputManager.addListener((InputListener)this, new String[]{"Rotate Left", "Rotate Right"});
        this.inputManager.addListener((InputListener)this, new String[]{"Walk Forward", "Walk Backward"});
        this.inputManager.addListener((InputListener)this, new String[]{"Jump", "Shoot"});
    }

    public void simpleInitApp() {
        this.bulletAppState = new BulletAppState();
        this.stateManager.attach((AppState)this.bulletAppState);
        PhysicsTestHelper.createPhysicsTestWorldSoccer(this.rootNode, this.assetManager, this.bulletAppState.getPhysicsSpace());
        this.setupKeys();
        this.physicsCharacter = new CharacterControl((CollisionShape)new CapsuleCollisionShape(0.5f, 1.8f), 0.1f);
        this.physicsCharacter.setPhysicsLocation(new Vector3f(0.0f, 1.0f, 0.0f));
        this.characterNode = new Node("character node");
        Spatial model = this.assetManager.loadModel("Models/Sinbad/Sinbad.mesh.xml");
        model.scale(0.25f);
        this.characterNode.addControl((Control)this.physicsCharacter);
        this.getPhysicsSpace().add((Object)this.physicsCharacter);
        this.rootNode.attachChild((Spatial)this.characterNode);
        this.characterNode.attachChild(model);
        this.camNode = new CameraNode("CamNode", this.cam);
        this.camNode.setControlDir(CameraControl.ControlDirection.SpatialToCamera);
        this.camNode.setLocalTranslation(new Vector3f(0.0f, 1.0f, -5.0f));
        this.camNode.lookAt(model.getLocalTranslation(), Vector3f.UNIT_Y);
        this.characterNode.attachChild((Spatial)this.camNode);
        this.flyCam.setEnabled(false);
    }

    public void simpleUpdate(float tpf) {
        Vector3f camDir = this.cam.getDirection().mult(0.2f);
        Vector3f camLeft = this.cam.getLeft().mult(0.2f);
        camDir.y = 0.0f;
        camLeft.y = 0.0f;
        this.viewDirection.set(camDir);
        this.walkDirection.set(0.0f, 0.0f, 0.0f);
        if (this.leftStrafe) {
            this.walkDirection.addLocal(camLeft);
        } else if (this.rightStrafe) {
            this.walkDirection.addLocal(camLeft.negate());
        }
        if (this.leftRotate) {
            this.viewDirection.addLocal(camLeft.mult(0.02f));
        } else if (this.rightRotate) {
            this.viewDirection.addLocal(camLeft.mult(0.02f).negate());
        }
        if (this.forward) {
            this.walkDirection.addLocal(camDir);
        } else if (this.backward) {
            this.walkDirection.addLocal(camDir.negate());
        }
        this.physicsCharacter.setWalkDirection(this.walkDirection);
        this.physicsCharacter.setViewDirection(this.viewDirection);
    }

    public void onAction(String binding, boolean value, float tpf) {
        if (binding.equals("Strafe Left")) {
            this.leftStrafe = value;
        } else if (binding.equals("Strafe Right")) {
            this.rightStrafe = value;
        } else if (binding.equals("Rotate Left")) {
            this.leftRotate = value;
        } else if (binding.equals("Rotate Right")) {
            this.rightRotate = value;
        } else if (binding.equals("Walk Forward")) {
            this.forward = value;
        } else if (binding.equals("Walk Backward")) {
            this.backward = value;
        } else if (binding.equals("Jump")) {
            this.physicsCharacter.jump();
        }
    }

    private PhysicsSpace getPhysicsSpace() {
        return this.bulletAppState.getPhysicsSpace();
    }

    public void simpleRender(RenderManager rm) {
    }
}

