/*
 * Decompiled with CFR 0.152.
 */
package jme3test.bullet;

import com.jme3.app.SimpleApplication;
import com.jme3.app.state.AppState;
import com.jme3.bullet.BulletAppState;
import com.jme3.bullet.collision.shapes.CapsuleCollisionShape;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.control.RigidBodyControl;
import com.jme3.bullet.joints.ConeJoint;
import com.jme3.bullet.joints.PhysicsJoint;
import com.jme3.bullet.objects.PhysicsRigidBody;
import com.jme3.input.controls.ActionListener;
import com.jme3.input.controls.InputListener;
import com.jme3.input.controls.MouseButtonTrigger;
import com.jme3.input.controls.Trigger;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import jme3test.bullet.PhysicsTestHelper;

public class TestRagDoll
extends SimpleApplication
implements ActionListener {
    private BulletAppState bulletAppState = new BulletAppState();
    private Node ragDoll = new Node();
    private Node shoulders;
    private Vector3f upforce = new Vector3f(0.0f, 200.0f, 0.0f);
    private boolean applyForce = false;

    public static void main(String[] args) {
        TestRagDoll app = new TestRagDoll();
        app.start();
    }

    public void simpleInitApp() {
        this.bulletAppState = new BulletAppState();
        this.stateManager.attach((AppState)this.bulletAppState);
        this.bulletAppState.getPhysicsSpace().enableDebug(this.assetManager);
        this.inputManager.addMapping("Pull ragdoll up", new Trigger[]{new MouseButtonTrigger(0)});
        this.inputManager.addListener((InputListener)this, new String[]{"Pull ragdoll up"});
        PhysicsTestHelper.createPhysicsTestWorld(this.rootNode, this.assetManager, this.bulletAppState.getPhysicsSpace());
        this.createRagDoll();
    }

    private void createRagDoll() {
        this.shoulders = this.createLimb(0.2f, 1.0f, new Vector3f(0.0f, 1.5f, 0.0f), true);
        Node uArmL = this.createLimb(0.2f, 0.5f, new Vector3f(-0.75f, 0.8f, 0.0f), false);
        Node uArmR = this.createLimb(0.2f, 0.5f, new Vector3f(0.75f, 0.8f, 0.0f), false);
        Node lArmL = this.createLimb(0.2f, 0.5f, new Vector3f(-0.75f, -0.2f, 0.0f), false);
        Node lArmR = this.createLimb(0.2f, 0.5f, new Vector3f(0.75f, -0.2f, 0.0f), false);
        Node body = this.createLimb(0.2f, 1.0f, new Vector3f(0.0f, 0.5f, 0.0f), false);
        Node hips = this.createLimb(0.2f, 0.5f, new Vector3f(0.0f, -0.5f, 0.0f), true);
        Node uLegL = this.createLimb(0.2f, 0.5f, new Vector3f(-0.25f, -1.2f, 0.0f), false);
        Node uLegR = this.createLimb(0.2f, 0.5f, new Vector3f(0.25f, -1.2f, 0.0f), false);
        Node lLegL = this.createLimb(0.2f, 0.5f, new Vector3f(-0.25f, -2.2f, 0.0f), false);
        Node lLegR = this.createLimb(0.2f, 0.5f, new Vector3f(0.25f, -2.2f, 0.0f), false);
        this.join(body, this.shoulders, new Vector3f(0.0f, 1.4f, 0.0f));
        this.join(body, hips, new Vector3f(0.0f, -0.5f, 0.0f));
        this.join(uArmL, this.shoulders, new Vector3f(-0.75f, 1.4f, 0.0f));
        this.join(uArmR, this.shoulders, new Vector3f(0.75f, 1.4f, 0.0f));
        this.join(uArmL, lArmL, new Vector3f(-0.75f, 0.4f, 0.0f));
        this.join(uArmR, lArmR, new Vector3f(0.75f, 0.4f, 0.0f));
        this.join(uLegL, hips, new Vector3f(-0.25f, -0.5f, 0.0f));
        this.join(uLegR, hips, new Vector3f(0.25f, -0.5f, 0.0f));
        this.join(uLegL, lLegL, new Vector3f(-0.25f, -1.7f, 0.0f));
        this.join(uLegR, lLegR, new Vector3f(0.25f, -1.7f, 0.0f));
        this.ragDoll.attachChild((Spatial)this.shoulders);
        this.ragDoll.attachChild((Spatial)body);
        this.ragDoll.attachChild((Spatial)hips);
        this.ragDoll.attachChild((Spatial)uArmL);
        this.ragDoll.attachChild((Spatial)uArmR);
        this.ragDoll.attachChild((Spatial)lArmL);
        this.ragDoll.attachChild((Spatial)lArmR);
        this.ragDoll.attachChild((Spatial)uLegL);
        this.ragDoll.attachChild((Spatial)uLegR);
        this.ragDoll.attachChild((Spatial)lLegL);
        this.ragDoll.attachChild((Spatial)lLegR);
        this.rootNode.attachChild((Spatial)this.ragDoll);
        this.bulletAppState.getPhysicsSpace().addAll((Spatial)this.ragDoll);
    }

    private Node createLimb(float width, float height, Vector3f location, boolean rotate) {
        int axis = rotate ? 0 : 1;
        CapsuleCollisionShape shape = new CapsuleCollisionShape(width, height, axis);
        Node node = new Node("Limb");
        RigidBodyControl rigidBodyControl = new RigidBodyControl((CollisionShape)shape, 1.0f);
        node.setLocalTranslation(location);
        node.addControl((Control)rigidBodyControl);
        return node;
    }

    private PhysicsJoint join(Node A, Node B, Vector3f connectionPoint) {
        Vector3f pivotA = A.worldToLocal(connectionPoint, new Vector3f());
        Vector3f pivotB = B.worldToLocal(connectionPoint, new Vector3f());
        ConeJoint joint = new ConeJoint((PhysicsRigidBody)A.getControl(RigidBodyControl.class), (PhysicsRigidBody)B.getControl(RigidBodyControl.class), pivotA, pivotB);
        joint.setLimit(1.0f, 1.0f, 0.0f);
        return joint;
    }

    public void onAction(String string, boolean bln, float tpf) {
        if ("Pull ragdoll up".equals(string)) {
            if (bln) {
                ((RigidBodyControl)this.shoulders.getControl(RigidBodyControl.class)).activate();
                this.applyForce = true;
            } else {
                this.applyForce = false;
            }
        }
    }

    public void simpleUpdate(float tpf) {
        if (this.applyForce) {
            ((RigidBodyControl)this.shoulders.getControl(RigidBodyControl.class)).applyForce(this.upforce, Vector3f.ZERO);
        }
    }
}

