/*
 * Decompiled with CFR 0.152.
 */
package jme3test.helloworld;

import com.jme3.app.SimpleApplication;
import com.jme3.audio.AudioNode;
import com.jme3.input.controls.ActionListener;
import com.jme3.input.controls.InputListener;
import com.jme3.input.controls.MouseButtonTrigger;
import com.jme3.input.controls.Trigger;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Box;

public class HelloAudio
extends SimpleApplication {
    private AudioNode audio_gun;
    private AudioNode audio_nature;
    private Geometry player;
    private ActionListener actionListener = new ActionListener(){

        public void onAction(String name, boolean keyPressed, float tpf) {
            if (name.equals("Shoot") && !keyPressed) {
                HelloAudio.this.audioRenderer.playSource(HelloAudio.this.audio_gun);
            }
        }
    };

    public static void main(String[] args) {
        HelloAudio app = new HelloAudio();
        app.start();
    }

    public void simpleInitApp() {
        this.flyCam.setMoveSpeed(40.0f);
        Box box1 = new Box(Vector3f.ZERO, 1.0f, 1.0f, 1.0f);
        this.player = new Geometry("Player", (Mesh)box1);
        Material mat1 = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        mat1.setColor("Color", ColorRGBA.Blue);
        this.player.setMaterial(mat1);
        this.rootNode.attachChild((Spatial)this.player);
        this.initKeys();
        this.initAudio();
    }

    private void initAudio() {
        this.audio_gun = new AudioNode(this.audioRenderer, this.assetManager, "Sound/Effects/Gun.wav", false);
        this.audio_gun.setLooping(false);
        this.audio_gun.setVolume(2.0f);
        this.audio_nature = new AudioNode(this.audioRenderer, this.assetManager, "Sound/Environment/Nature.ogg", false);
        this.audio_nature.setLooping(true);
        this.audio_nature.setPositional(true);
        this.audio_nature.setLocalTranslation(Vector3f.ZERO.clone());
        this.audio_nature.setVolume(3.0f);
        this.audio_nature.updateGeometricState();
        this.audioRenderer.playSource(this.audio_nature);
    }

    private void initKeys() {
        this.inputManager.addMapping("Shoot", new Trigger[]{new MouseButtonTrigger(0)});
        this.inputManager.addListener((InputListener)this.actionListener, new String[]{"Shoot"});
    }

    public void simpleUpdate(float tpf) {
        this.listener.setLocation(this.cam.getLocation());
        this.listener.setRotation(this.cam.getRotation());
    }
}

