/*
 * Decompiled with CFR 0.152.
 */
package jme3test.light;

import com.jme3.app.SimpleApplication;
import com.jme3.input.controls.ActionListener;
import com.jme3.input.controls.InputListener;
import com.jme3.input.controls.KeyTrigger;
import com.jme3.input.controls.Trigger;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.post.SceneProcessor;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Box;
import com.jme3.scene.shape.Sphere;
import com.jme3.shadow.PssmShadowRenderer;
import java.util.Random;

public class TestPssmShadow
extends SimpleApplication
implements ActionListener {
    private Spatial teapot;
    private boolean renderShadows = true;
    private boolean hardwareShadows = false;
    private PssmShadowRenderer pssmRenderer;

    public static void main(String[] args) {
        TestPssmShadow app = new TestPssmShadow();
        app.start();
    }

    public void loadScene() {
        Material mat = this.assetManager.loadMaterial("Common/Materials/RedColor.j3m");
        Material matSoil = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        matSoil.setColor("Color", ColorRGBA.Cyan);
        this.teapot = new Geometry("sphere", (Mesh)new Sphere(30, 30, 2.0f));
        this.teapot.setLocalTranslation(0.0f, 0.0f, 10.0f);
        this.teapot.setMaterial(mat);
        this.teapot.setShadowMode(RenderQueue.ShadowMode.CastAndReceive);
        this.rootNode.attachChild(this.teapot);
        long seed = 1294719330150L;
        Random random = new Random(seed);
        System.out.println(seed);
        for (int i = 0; i < 30; ++i) {
            Spatial t = this.teapot.clone(false);
            this.rootNode.attachChild(t);
            this.teapot.setLocalTranslation(random.nextFloat() * 3.0f, random.nextFloat() * 3.0f, (float)(i + 2));
        }
        Geometry soil = new Geometry("soil", (Mesh)new Box(new Vector3f(0.0f, -13.0f, 550.0f), 800.0f, 10.0f, 700.0f));
        soil.setMaterial(matSoil);
        soil.setShadowMode(RenderQueue.ShadowMode.Receive);
        this.rootNode.attachChild((Spatial)soil);
        for (int i = 0; i < 30; ++i) {
            Spatial t = this.teapot.clone(false);
            t.setLocalScale(10.0f);
            this.rootNode.attachChild(t);
            this.teapot.setLocalTranslation(random.nextFloat() * 300.0f, random.nextFloat() * 30.0f, (float)(30 * (i + 2)));
        }
    }

    public void simpleInitApp() {
        this.cam.setLocation(new Vector3f(41.59757f, 34.38738f, 11.528807f));
        this.cam.setRotation(new Quaternion(0.2905285f, 0.3816416f, -0.12772122f, 0.86811876f));
        this.flyCam.setMoveSpeed(100.0f);
        this.loadScene();
        this.pssmRenderer = new PssmShadowRenderer(this.assetManager, 1024, 3);
        this.pssmRenderer.setDirection(new Vector3f(-1.0f, -1.0f, -1.0f).normalizeLocal());
        this.pssmRenderer.setLambda(0.55f);
        this.pssmRenderer.setShadowIntensity(0.6f);
        this.pssmRenderer.setCompareMode(PssmShadowRenderer.CompareMode.Software);
        this.pssmRenderer.setFilterMode(PssmShadowRenderer.FilterMode.Bilinear);
        this.pssmRenderer.displayDebug();
        this.viewPort.addProcessor((SceneProcessor)this.pssmRenderer);
        this.initInputs();
    }

    private void initInputs() {
        this.inputManager.addMapping("toggle", new Trigger[]{new KeyTrigger(57)});
        this.inputManager.addMapping("ShadowUp", new Trigger[]{new KeyTrigger(20)});
        this.inputManager.addMapping("ShadowDown", new Trigger[]{new KeyTrigger(34)});
        this.inputManager.addMapping("ThicknessUp", new Trigger[]{new KeyTrigger(21)});
        this.inputManager.addMapping("ThicknessDown", new Trigger[]{new KeyTrigger(35)});
        this.inputManager.addMapping("lambdaUp", new Trigger[]{new KeyTrigger(22)});
        this.inputManager.addMapping("lambdaDown", new Trigger[]{new KeyTrigger(36)});
        this.inputManager.addMapping("toggleHW", new Trigger[]{new KeyTrigger(28)});
        this.inputManager.addListener((InputListener)this, new String[]{"lambdaUp", "lambdaDown", "toggleHW", "toggle", "ShadowUp", "ShadowDown", "ThicknessUp", "ThicknessDown"});
    }

    public void onAction(String name, boolean keyPressed, float tpf) {
        if (name.equals("toggle") && keyPressed) {
            if (this.renderShadows) {
                this.renderShadows = false;
                this.viewPort.removeProcessor((SceneProcessor)this.pssmRenderer);
            } else {
                this.renderShadows = true;
                this.viewPort.addProcessor((SceneProcessor)this.pssmRenderer);
            }
        } else if (name.equals("toggleHW") && keyPressed) {
            this.hardwareShadows = !this.hardwareShadows;
            this.pssmRenderer.setCompareMode(this.hardwareShadows ? PssmShadowRenderer.CompareMode.Hardware : PssmShadowRenderer.CompareMode.Software);
            System.out.println("HW Shadows: " + this.hardwareShadows);
        }
        if (name.equals("lambdaUp") && keyPressed) {
            this.pssmRenderer.setLambda(this.pssmRenderer.getLambda() + 0.01f);
            System.out.println("Lambda : " + this.pssmRenderer.getLambda());
        } else if (name.equals("lambdaDown") && keyPressed) {
            this.pssmRenderer.setLambda(this.pssmRenderer.getLambda() - 0.01f);
            System.out.println("Lambda : " + this.pssmRenderer.getLambda());
        }
        if (name.equals("ShadowUp") && keyPressed) {
            this.pssmRenderer.setShadowIntensity(this.pssmRenderer.getShadowIntensity() + 0.1f);
            System.out.println("Shadow intensity : " + this.pssmRenderer.getShadowIntensity());
        }
        if (name.equals("ShadowDown") && keyPressed) {
            this.pssmRenderer.setShadowIntensity(this.pssmRenderer.getShadowIntensity() - 0.1f);
            System.out.println("Shadow intensity : " + this.pssmRenderer.getShadowIntensity());
        }
        if (name.equals("ThicknessUp") && keyPressed) {
            this.pssmRenderer.setEdgesThickness(this.pssmRenderer.getEdgesThickness() + 1);
            System.out.println("Shadow thickness : " + this.pssmRenderer.getEdgesThickness());
        }
        if (name.equals("ThicknessDown") && keyPressed) {
            this.pssmRenderer.setEdgesThickness(this.pssmRenderer.getEdgesThickness() - 1);
            System.out.println("Shadow thickness : " + this.pssmRenderer.getEdgesThickness());
        }
    }
}

