/*
 * Decompiled with CFR 0.152.
 */
package jme3test.light;

import com.jme3.app.SimpleApplication;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.post.SceneProcessor;
import com.jme3.renderer.Camera;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.debug.WireFrustum;
import com.jme3.scene.shape.Box;
import com.jme3.shadow.BasicShadowRenderer;
import com.jme3.shadow.ShadowUtil;

public class TestShadow
extends SimpleApplication {
    float angle;
    Spatial lightMdl;
    Spatial teapot;
    Geometry frustumMdl;
    WireFrustum frustum;
    private BasicShadowRenderer bsr;
    private Vector3f[] points = new Vector3f[8];

    public TestShadow() {
        for (int i = 0; i < this.points.length; ++i) {
            this.points[i] = new Vector3f();
        }
    }

    public static void main(String[] args) {
        TestShadow app = new TestShadow();
        app.start();
    }

    public void simpleInitApp() {
        this.cam.setLocation(new Vector3f(0.7804813f, 1.7502685f, -2.1556435f));
        this.cam.setRotation(new Quaternion(0.1961598f, -0.7213164f, 0.2266092f, 0.6243975f));
        this.cam.setFrustumFar(10.0f);
        Material mat = this.assetManager.loadMaterial("Common/Materials/WhiteColor.j3m");
        this.rootNode.setShadowMode(RenderQueue.ShadowMode.Off);
        Box floor = new Box(Vector3f.ZERO, 3.0f, 0.1f, 3.0f);
        Geometry floorGeom = new Geometry("Floor", (Mesh)floor);
        floorGeom.setMaterial(mat);
        floorGeom.setLocalTranslation(0.0f, -0.2f, 0.0f);
        floorGeom.setShadowMode(RenderQueue.ShadowMode.Receive);
        this.rootNode.attachChild((Spatial)floorGeom);
        this.teapot = this.assetManager.loadModel("Models/Teapot/Teapot.obj");
        this.teapot.setLocalScale(2.0f);
        this.teapot.setMaterial(mat);
        this.teapot.setShadowMode(RenderQueue.ShadowMode.CastAndReceive);
        this.rootNode.attachChild(this.teapot);
        this.bsr = new BasicShadowRenderer(this.assetManager, 512);
        this.bsr.setDirection(new Vector3f(-1.0f, -1.0f, -1.0f).normalizeLocal());
        this.viewPort.addProcessor((SceneProcessor)this.bsr);
        this.frustum = new WireFrustum(this.bsr.getPoints());
        this.frustumMdl = new Geometry("f", (Mesh)this.frustum);
        this.frustumMdl.setCullHint(Spatial.CullHint.Never);
        this.frustumMdl.setShadowMode(RenderQueue.ShadowMode.Off);
        this.frustumMdl.setMaterial(new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md"));
        this.frustumMdl.getMaterial().getAdditionalRenderState().setWireframe(true);
        this.frustumMdl.getMaterial().setColor("Color", ColorRGBA.Red);
        this.rootNode.attachChild((Spatial)this.frustumMdl);
    }

    public void simpleUpdate(float tpf) {
        Camera shadowCam = this.bsr.getShadowCamera();
        ShadowUtil.updateFrustumPoints2((Camera)shadowCam, (Vector3f[])this.points);
        this.frustum.update(this.points);
        this.teapot.rotate(0.0f, tpf * 0.25f, 0.0f);
    }
}

