/*
 * Decompiled with CFR 0.152.
 */
package jme3test.light;

import com.jme3.app.SimpleApplication;
import com.jme3.light.DirectionalLight;
import com.jme3.light.Light;
import com.jme3.light.PointLight;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.FastMath;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Sphere;
import com.jme3.util.TangentBinormalGenerator;

public class TestTangentGenBadUV
extends SimpleApplication {
    float angle;
    PointLight pl;
    Geometry lightMdl;

    public static void main(String[] args) {
        TestTangentGenBadUV app = new TestTangentGenBadUV();
        app.start();
    }

    public void simpleInitApp() {
        Spatial teapot = this.assetManager.loadModel("Models/Teapot/Teapot.obj");
        if (!(teapot instanceof Geometry)) {
            throw new RuntimeException();
        }
        Geometry g = (Geometry)teapot;
        TangentBinormalGenerator.generate((Mesh)g.getMesh());
        teapot.setLocalScale(2.0f);
        Material mat = this.assetManager.loadMaterial("Textures/BumpMapTest/Tangent.j3m");
        teapot.setMaterial(mat);
        this.rootNode.attachChild(teapot);
        Geometry debug = new Geometry("Debug Teapot", TangentBinormalGenerator.genTbnLines((Mesh)((Geometry)teapot).getMesh(), (float)0.03f));
        Material debugMat = this.assetManager.loadMaterial("Common/Materials/VertexColor.j3m");
        debug.setMaterial(debugMat);
        debug.setCullHint(Spatial.CullHint.Never);
        debug.getLocalTranslation().set(teapot.getLocalTranslation());
        debug.getLocalScale().set(teapot.getLocalScale());
        this.rootNode.attachChild((Spatial)debug);
        DirectionalLight dl = new DirectionalLight();
        dl.setDirection(new Vector3f(1.0f, -1.0f, -1.0f).normalizeLocal());
        dl.setColor(ColorRGBA.White);
        this.rootNode.addLight((Light)dl);
        this.lightMdl = new Geometry("Light", (Mesh)new Sphere(10, 10, 0.1f));
        this.lightMdl.setMaterial(this.assetManager.loadMaterial("Common/Materials/RedColor.j3m"));
        this.lightMdl.getMesh().setStatic();
        this.rootNode.attachChild((Spatial)this.lightMdl);
        this.pl = new PointLight();
        this.pl.setColor(ColorRGBA.White);
        this.rootNode.addLight((Light)this.pl);
    }

    public void simpleUpdate(float tpf) {
        this.angle += tpf;
        this.angle %= (float)Math.PI * 2;
        this.pl.setPosition(new Vector3f(FastMath.cos((float)this.angle) * 2.0f, 0.5f, FastMath.sin((float)this.angle) * 2.0f));
        this.lightMdl.setLocalTranslation(this.pl.getPosition());
    }
}

