/*
 * Decompiled with CFR 0.152.
 */
package jme3test.light;

import com.jme3.app.SimpleApplication;
import com.jme3.effect.ParticleEmitter;
import com.jme3.effect.ParticleMesh;
import com.jme3.light.AmbientLight;
import com.jme3.light.DirectionalLight;
import com.jme3.light.Light;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.post.SceneProcessor;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.SceneGraphVisitor;
import com.jme3.scene.SceneGraphVisitorAdapter;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import com.jme3.scene.control.LodControl;
import com.jme3.scene.shape.Quad;
import com.jme3.shadow.PssmShadowRenderer;

public class TestTransparentShadow
extends SimpleApplication {
    public static void main(String[] args) {
        TestTransparentShadow app = new TestTransparentShadow();
        app.start();
    }

    public void simpleInitApp() {
        this.cam.setLocation(new Vector3f(2.0606942f, 3.20342f, 6.7860126f));
        this.cam.setRotation(new Quaternion(-0.017481906f, 0.98241085f, -0.12393151f, -0.13857932f));
        this.viewPort.setBackgroundColor(ColorRGBA.DarkGray);
        Quad q = new Quad(20.0f, 20.0f);
        q.scaleTextureCoordinates(Vector2f.UNIT_XY.mult(5.0f));
        Geometry geom = new Geometry("floor", (Mesh)q);
        Material mat = this.assetManager.loadMaterial("Textures/Terrain/Pond/Pond.j3m");
        geom.setMaterial(mat);
        geom.rotate(-1.5707964f, 0.0f, 0.0f);
        geom.center();
        geom.setShadowMode(RenderQueue.ShadowMode.Receive);
        this.rootNode.attachChild((Spatial)geom);
        Spatial teaGeom = this.assetManager.loadModel("Models/Tree/Tree2.mesh.xml");
        teaGeom.setQueueBucket(RenderQueue.Bucket.Transparent);
        teaGeom.setShadowMode(RenderQueue.ShadowMode.Cast);
        teaGeom.depthFirstTraversal((SceneGraphVisitor)new SceneGraphVisitorAdapter(){

            public void visit(Geometry geom) {
                LodControl lodCtrl = new LodControl();
                lodCtrl.setTrisPerPixel(0.25f);
                geom.addControl((Control)lodCtrl);
            }
        });
        AmbientLight al = new AmbientLight();
        al.setColor(ColorRGBA.White.mult(2.0f));
        this.rootNode.addLight((Light)al);
        DirectionalLight dl1 = new DirectionalLight();
        dl1.setDirection(new Vector3f(1.0f, -1.0f, 1.0f).normalizeLocal());
        dl1.setColor(new ColorRGBA(0.965f, 0.949f, 0.772f, 1.0f).mult(0.7f));
        this.rootNode.addLight((Light)dl1);
        DirectionalLight dl = new DirectionalLight();
        dl.setDirection(new Vector3f(-1.0f, -1.0f, -1.0f).normalizeLocal());
        dl.setColor(new ColorRGBA(0.965f, 0.949f, 0.772f, 1.0f).mult(0.7f));
        this.rootNode.addLight((Light)dl);
        this.rootNode.attachChild(teaGeom);
        ParticleEmitter fire = new ParticleEmitter("Emitter", ParticleMesh.Type.Triangle, 30);
        Material mat_red = new Material(this.assetManager, "Common/MatDefs/Misc/Particle.j3md");
        mat_red.setTexture("Texture", this.assetManager.loadTexture("Effects/Explosion/flame.png"));
        fire.setMaterial(mat_red);
        fire.setImagesX(2);
        fire.setImagesY(2);
        fire.setEndColor(new ColorRGBA(1.0f, 0.0f, 0.0f, 1.0f));
        fire.setStartColor(new ColorRGBA(1.0f, 1.0f, 0.0f, 0.5f));
        fire.setInitialVelocity(new Vector3f(0.0f, 2.0f, 0.0f));
        fire.setStartSize(0.6f);
        fire.setEndSize(0.1f);
        fire.setGravity(0.0f, 0.0f, 0.0f);
        fire.setLowLife(0.5f);
        fire.setHighLife(1.5f);
        fire.setVelocityVariation(0.3f);
        fire.setLocalTranslation(1.0f, 0.0f, 1.0f);
        fire.setLocalScale(0.3f);
        fire.setQueueBucket(RenderQueue.Bucket.Translucent);
        this.rootNode.attachChild((Spatial)fire);
        PssmShadowRenderer pssmRenderer = new PssmShadowRenderer(this.assetManager, 1024, 1);
        pssmRenderer.setDirection(new Vector3f(0.01f, -1.0f, 0.01f).normalizeLocal());
        pssmRenderer.setLambda(0.55f);
        pssmRenderer.setShadowIntensity(0.6f);
        pssmRenderer.setCompareMode(PssmShadowRenderer.CompareMode.Software);
        pssmRenderer.setFilterMode(PssmShadowRenderer.FilterMode.PCF4);
        pssmRenderer.displayDebug();
        this.viewPort.addProcessor((SceneProcessor)pssmRenderer);
    }
}

