/*
 * Decompiled with CFR 0.152.
 */
package jme3test.model.shape;

import com.jme3.app.SimpleApplication;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.util.BufferUtils;

public class TestCustomMesh
extends SimpleApplication {
    public static void main(String[] args) {
        TestCustomMesh app = new TestCustomMesh();
        app.start();
    }

    public void simpleInitApp() {
        Mesh m = new Mesh();
        Vector3f[] vertices = new Vector3f[]{new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(3.0f, 0.0f, 0.0f), new Vector3f(0.0f, 3.0f, 0.0f), new Vector3f(3.0f, 3.0f, 0.0f)};
        Vector2f[] texCoord = new Vector2f[]{new Vector2f(0.0f, 0.0f), new Vector2f(1.0f, 0.0f), new Vector2f(0.0f, 1.0f), new Vector2f(1.0f, 1.0f)};
        int[] indexes = new int[]{2, 0, 1, 1, 3, 2};
        m.setBuffer(VertexBuffer.Type.Position, 3, BufferUtils.createFloatBuffer((Vector3f[])vertices));
        m.setBuffer(VertexBuffer.Type.TexCoord, 2, BufferUtils.createFloatBuffer((Vector2f[])texCoord));
        m.setBuffer(VertexBuffer.Type.Index, 1, BufferUtils.createIntBuffer((int[])indexes));
        m.updateBound();
        Geometry geom = new Geometry("OurMesh", m);
        Material mat = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        mat.setColor("Color", ColorRGBA.Blue);
        geom.setMaterial(mat);
        this.rootNode.attachChild((Spatial)geom);
        Mesh cMesh = m.clone();
        Geometry coloredMesh = new Geometry("ColoredMesh", cMesh);
        Material matVC = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        matVC.setBoolean("VertexColor", true);
        float[] colorArray = new float[16];
        int colorIndex = 0;
        for (int i = 0; i < 4; ++i) {
            colorArray[colorIndex++] = 0.1f + 0.2f * (float)i;
            colorArray[colorIndex++] = 0.9f - 0.2f * (float)i;
            colorArray[colorIndex++] = 0.5f;
            colorArray[colorIndex++] = 1.0f;
        }
        cMesh.setBuffer(VertexBuffer.Type.Color, 4, colorArray);
        coloredMesh.setMaterial(matVC);
        coloredMesh.setLocalTranslation(4.0f, 0.0f, 0.0f);
        this.rootNode.attachChild((Spatial)coloredMesh);
        Mesh wfMesh = m.clone();
        Geometry wfGeom = new Geometry("wireframeGeometry", wfMesh);
        Material matWireframe = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        matWireframe.setColor("Color", ColorRGBA.Green);
        matWireframe.getAdditionalRenderState().setWireframe(true);
        wfGeom.setMaterial(matWireframe);
        wfGeom.setLocalTranslation(4.0f, 4.0f, 0.0f);
        this.rootNode.attachChild((Spatial)wfGeom);
    }
}

