/*
 * Decompiled with CFR 0.152.
 */
package jme3test.network;

import com.jme3.network.AbstractMessage;
import com.jme3.network.HostedConnection;
import com.jme3.network.Message;
import com.jme3.network.MessageListener;
import com.jme3.network.Network;
import com.jme3.network.Server;
import com.jme3.network.serializing.Serializable;
import com.jme3.network.serializing.Serializer;

public class TestChatServer {
    public static final String NAME = "Test Chat Server";
    public static final int VERSION = 1;
    public static final int PORT = 5110;
    public static final int UDP_PORT = 5110;

    public static void initializeClasses() {
        Serializer.registerClass(ChatMessage.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String ... args) throws Exception {
        TestChatServer.initializeClasses();
        Server server = Network.createServer((String)NAME, (int)1, (int)5110, (int)5110);
        server.start();
        ChatHandler handler = new ChatHandler();
        server.addMessageListener((MessageListener)handler, new Class[]{ChatMessage.class});
        String string = NAME;
        synchronized (NAME) {
            NAME.wait();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    @Serializable
    public static class ChatMessage
    extends AbstractMessage {
        private String name;
        private String message;

        public ChatMessage() {
        }

        public ChatMessage(String name, String message) {
            this.setName(name);
            this.setMessage(message);
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setMessage(String s) {
            this.message = s;
        }

        public String getMessage() {
            return this.message;
        }

        public String toString() {
            return this.name + ":" + this.message;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ChatHandler
    implements MessageListener<HostedConnection> {
        public void messageReceived(HostedConnection source, Message m) {
            if (m instanceof ChatMessage) {
                source.setAttribute("name", (Object)((ChatMessage)m).getName());
                System.out.println("Broadcasting:" + m + "  reliable:" + m.isReliable());
                source.getServer().broadcast(m);
            } else {
                System.err.println("Received odd message:" + m);
            }
        }
    }
}

