/*
 * Decompiled with CFR 0.152.
 */
package jme3test.network;

import com.jme3.network.AbstractMessage;
import com.jme3.network.Client;
import com.jme3.network.HostedConnection;
import com.jme3.network.Message;
import com.jme3.network.MessageListener;
import com.jme3.network.Network;
import com.jme3.network.Server;
import com.jme3.network.serializing.Serializable;
import com.jme3.network.serializing.Serializer;
import java.io.IOException;

public class TestMessages {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException, InterruptedException {
        Object obj;
        Serializer.registerClass(PingMessage.class);
        Serializer.registerClass(PongMessage.class);
        Server server = Network.createServer((int)5110);
        server.start();
        Client client = Network.connectToServer((String)"localhost", (int)5110);
        client.start();
        server.addMessageListener((MessageListener)new ServerPingResponder(), new Class[]{PingMessage.class});
        client.addMessageListener((MessageListener)new ClientPingResponder(), new Class[]{PongMessage.class});
        System.out.println("Client: Sending ping message..");
        client.send((Message)new PingMessage());
        Object object = obj = new Object();
        synchronized (object) {
            obj.wait();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ClientPingResponder
    implements MessageListener<Client> {
        private ClientPingResponder() {
        }

        public void messageReceived(Client source, Message message) {
            if (message instanceof PongMessage) {
                System.out.println("Client: Received pong message!");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ServerPingResponder
    implements MessageListener<HostedConnection> {
        private ServerPingResponder() {
        }

        public void messageReceived(HostedConnection source, Message message) {
            if (message instanceof PingMessage) {
                System.out.println("Server: Received ping message!");
                source.send((Message)new PongMessage());
            }
        }
    }

    @Serializable
    public static class PongMessage
    extends AbstractMessage {
    }

    @Serializable
    public static class PingMessage
    extends AbstractMessage {
    }
}

