/*
 * Decompiled with CFR 0.152.
 */
package jme3test.post;

import com.jme3.input.InputManager;
import com.jme3.input.controls.ActionListener;
import com.jme3.input.controls.AnalogListener;
import com.jme3.input.controls.InputListener;
import com.jme3.input.controls.KeyTrigger;
import com.jme3.input.controls.Trigger;
import com.jme3.post.filters.LightScatteringFilter;

public class LightScatteringUI {
    private LightScatteringFilter filter;

    public LightScatteringUI(InputManager inputManager, LightScatteringFilter proc) {
        this.filter = proc;
        System.out.println("----------------- LightScattering UI Debugger --------------------");
        System.out.println("-- Sample number : press Y to increase, H to decrease");
        System.out.println("-- blur start : press U to increase, J to decrease");
        System.out.println("-- blur width : press I to increase, K to decrease");
        System.out.println("-- Light density : press O to increase, P to decrease");
        System.out.println("-------------------------------------------------------");
        inputManager.addMapping("sampleUp", new Trigger[]{new KeyTrigger(21)});
        inputManager.addMapping("sampleDown", new Trigger[]{new KeyTrigger(35)});
        inputManager.addMapping("blurStartUp", new Trigger[]{new KeyTrigger(22)});
        inputManager.addMapping("blurStartDown", new Trigger[]{new KeyTrigger(36)});
        inputManager.addMapping("blurWidthUp", new Trigger[]{new KeyTrigger(23)});
        inputManager.addMapping("blurWidthDown", new Trigger[]{new KeyTrigger(37)});
        inputManager.addMapping("lightDensityUp", new Trigger[]{new KeyTrigger(24)});
        inputManager.addMapping("lightDensityDown", new Trigger[]{new KeyTrigger(38)});
        inputManager.addMapping("outputConfig", new Trigger[]{new KeyTrigger(25)});
        ActionListener acl = new ActionListener(){

            public void onAction(String name, boolean keyPressed, float tpf) {
                if (name.equals("sampleUp")) {
                    LightScatteringUI.this.filter.setNbSamples(LightScatteringUI.this.filter.getNbSamples() + 1);
                    System.out.println("Nb Samples : " + LightScatteringUI.this.filter.getNbSamples());
                }
                if (name.equals("sampleDown")) {
                    LightScatteringUI.this.filter.setNbSamples(LightScatteringUI.this.filter.getNbSamples() - 1);
                    System.out.println("Nb Samples : " + LightScatteringUI.this.filter.getNbSamples());
                }
                if (name.equals("outputConfig") && keyPressed) {
                    System.out.println("lightScatteringFilter.setNbSamples(" + LightScatteringUI.this.filter.getNbSamples() + ");");
                    System.out.println("lightScatteringFilter.setBlurStart(" + LightScatteringUI.this.filter.getBlurStart() + "f);");
                    System.out.println("lightScatteringFilter.setBlurWidth(" + LightScatteringUI.this.filter.getBlurWidth() + "f);");
                    System.out.println("lightScatteringFilter.setLightDensity(" + LightScatteringUI.this.filter.getLightDensity() + "f);");
                }
            }
        };
        AnalogListener anl = new AnalogListener(){

            public void onAnalog(String name, float value, float tpf) {
                if (name.equals("blurStartUp")) {
                    LightScatteringUI.this.filter.setBlurStart(LightScatteringUI.this.filter.getBlurStart() + 0.001f);
                    System.out.println("Blur start : " + LightScatteringUI.this.filter.getBlurStart());
                }
                if (name.equals("blurStartDown")) {
                    LightScatteringUI.this.filter.setBlurStart(LightScatteringUI.this.filter.getBlurStart() - 0.001f);
                    System.out.println("Blur start : " + LightScatteringUI.this.filter.getBlurStart());
                }
                if (name.equals("blurWidthUp")) {
                    LightScatteringUI.this.filter.setBlurWidth(LightScatteringUI.this.filter.getBlurWidth() + 0.001f);
                    System.out.println("Blur Width : " + LightScatteringUI.this.filter.getBlurWidth());
                }
                if (name.equals("blurWidthDown")) {
                    LightScatteringUI.this.filter.setBlurWidth(LightScatteringUI.this.filter.getBlurWidth() - 0.001f);
                    System.out.println("Blur Width : " + LightScatteringUI.this.filter.getBlurWidth());
                }
                if (name.equals("lightDensityUp")) {
                    LightScatteringUI.this.filter.setLightDensity(LightScatteringUI.this.filter.getLightDensity() + 0.001f);
                    System.out.println("light Density : " + LightScatteringUI.this.filter.getLightDensity());
                }
                if (name.equals("lightDensityDown")) {
                    LightScatteringUI.this.filter.setLightDensity(LightScatteringUI.this.filter.getLightDensity() - 0.001f);
                    System.out.println("light Density : " + LightScatteringUI.this.filter.getLightDensity());
                }
            }
        };
        inputManager.addListener((InputListener)acl, new String[]{"sampleUp", "sampleDown", "outputConfig"});
        inputManager.addListener((InputListener)anl, new String[]{"blurStartUp", "blurStartDown", "blurWidthUp", "blurWidthDown", "lightDensityUp", "lightDensityDown"});
    }
}

