/*
 * Decompiled with CFR 0.152.
 */
package jme3test.post;

import com.jme3.app.SimpleApplication;
import com.jme3.asset.AssetManager;
import com.jme3.input.controls.ActionListener;
import com.jme3.input.controls.InputListener;
import com.jme3.input.controls.KeyTrigger;
import com.jme3.input.controls.Trigger;
import com.jme3.light.DirectionalLight;
import com.jme3.light.Light;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.post.Filter;
import com.jme3.post.FilterPostProcessor;
import com.jme3.post.SceneProcessor;
import com.jme3.post.filters.CrossHatchFilter;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.debug.WireFrustum;
import com.jme3.scene.shape.Box;
import com.jme3.util.SkyFactory;

public class TestCrossHatch
extends SimpleApplication {
    float angle;
    Spatial lightMdl;
    Spatial teapot;
    Geometry frustumMdl;
    WireFrustum frustum;
    boolean active = true;
    FilterPostProcessor fpp;

    public static void main(String[] args) {
        TestCrossHatch app = new TestCrossHatch();
        app.start();
    }

    public void simpleInitApp() {
        this.cam.setLocation(new Vector3f(-2.336393f, 11.91392f, -7.139601f));
        this.cam.setRotation(new Quaternion(0.23602544f, 0.11321983f, -0.027698677f, 0.96473104f));
        Material mat = new Material(this.assetManager, "Common/MatDefs/Light/Lighting.j3md");
        mat.setFloat("Shininess", 15.0f);
        mat.setBoolean("UseMaterialColors", true);
        mat.setColor("Ambient", ColorRGBA.Yellow.mult(0.2f));
        mat.setColor("Diffuse", ColorRGBA.Yellow.mult(0.2f));
        mat.setColor("Specular", ColorRGBA.Yellow.mult(0.8f));
        Material matSoil = new Material(this.assetManager, "Common/MatDefs/Light/Lighting.j3md");
        matSoil.setFloat("Shininess", 15.0f);
        matSoil.setBoolean("UseMaterialColors", true);
        matSoil.setColor("Ambient", ColorRGBA.Gray);
        matSoil.setColor("Diffuse", ColorRGBA.Black);
        matSoil.setColor("Specular", ColorRGBA.Gray);
        this.teapot = this.assetManager.loadModel("Models/Teapot/Teapot.obj");
        this.teapot.setLocalTranslation(0.0f, 0.0f, 10.0f);
        this.teapot.setMaterial(mat);
        this.teapot.setShadowMode(RenderQueue.ShadowMode.CastAndReceive);
        this.teapot.setLocalScale(10.0f);
        this.rootNode.attachChild(this.teapot);
        Geometry soil = new Geometry("soil", (Mesh)new Box(new Vector3f(0.0f, -13.0f, 550.0f), 800.0f, 10.0f, 700.0f));
        soil.setMaterial(matSoil);
        soil.setShadowMode(RenderQueue.ShadowMode.CastAndReceive);
        this.rootNode.attachChild((Spatial)soil);
        DirectionalLight light = new DirectionalLight();
        light.setDirection(new Vector3f(-1.0f, -1.0f, -1.0f).normalizeLocal());
        light.setColor(ColorRGBA.White.mult(1.5f));
        this.rootNode.addLight((Light)light);
        Spatial sky = SkyFactory.createSky((AssetManager)this.assetManager, (String)"Textures/Sky/Bright/FullskiesBlueClear03.dds", (boolean)false);
        sky.setCullHint(Spatial.CullHint.Never);
        this.rootNode.attachChild(sky);
        this.fpp = new FilterPostProcessor(this.assetManager);
        CrossHatchFilter chf = new CrossHatchFilter();
        this.viewPort.addProcessor((SceneProcessor)this.fpp);
        this.fpp.addFilter((Filter)chf);
        this.initInputs();
    }

    private void initInputs() {
        this.inputManager.addMapping("toggle", new Trigger[]{new KeyTrigger(57)});
        ActionListener acl = new ActionListener(){

            public void onAction(String name, boolean keyPressed, float tpf) {
                if (name.equals("toggle") && keyPressed) {
                    if (TestCrossHatch.this.active) {
                        TestCrossHatch.this.active = false;
                        TestCrossHatch.this.viewPort.removeProcessor((SceneProcessor)TestCrossHatch.this.fpp);
                    } else {
                        TestCrossHatch.this.active = true;
                        TestCrossHatch.this.viewPort.addProcessor((SceneProcessor)TestCrossHatch.this.fpp);
                    }
                }
            }
        };
        this.inputManager.addListener((InputListener)acl, new String[]{"toggle"});
    }
}

