/*
 * Decompiled with CFR 0.152.
 */
package jme3test.post;

import com.jme3.app.SimpleApplication;
import com.jme3.app.StatsView;
import com.jme3.asset.AssetManager;
import com.jme3.font.BitmapText;
import com.jme3.light.DirectionalLight;
import com.jme3.light.Light;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.post.Filter;
import com.jme3.post.FilterPostProcessor;
import com.jme3.post.SceneProcessor;
import com.jme3.post.filters.LightScatteringFilter;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.shadow.PssmShadowRenderer;
import com.jme3.util.SkyFactory;
import com.jme3.util.TangentBinormalGenerator;
import jme3test.post.LightScatteringUI;

public class TestLightScattering
extends SimpleApplication {
    public static void main(String[] args) {
        TestLightScattering app = new TestLightScattering();
        app.start();
    }

    public void loadFPSText() {
        this.guiFont = this.assetManager.loadFont("Interface/Fonts/Default.fnt");
        this.fpsText = new BitmapText(this.guiFont, false);
        this.fpsText.setSize((float)this.guiFont.getCharSet().getRenderedSize());
        this.fpsText.setLocalTranslation(0.0f, this.fpsText.getLineHeight(), 0.0f);
        this.fpsText.setText("Frames per second");
        this.guiNode.attachChild((Spatial)this.fpsText);
    }

    public void loadStatsView() {
        this.statsView = new StatsView("Statistics View", this.assetManager, this.renderer.getStatistics());
        this.statsView.setLocalTranslation(0.0f, this.fpsText.getLineHeight(), 0.0f);
        this.guiNode.attachChild((Spatial)this.statsView);
    }

    public void simpleInitApp() {
        this.cam.setLocation(new Vector3f(55.35316f, -0.27061665f, 27.092093f));
        this.cam.setRotation(new Quaternion(0.010414706f, 0.9874893f, 0.13880467f, -0.07409228f));
        this.flyCam.setMoveSpeed(10.0f);
        Material mat = this.assetManager.loadMaterial("Textures/Terrain/Rocky/Rocky.j3m");
        Spatial scene = this.assetManager.loadModel("Models/Terrain/Terrain.mesh.xml");
        TangentBinormalGenerator.generate((Mesh)((Geometry)((Node)scene).getChild(0)).getMesh());
        scene.setMaterial(mat);
        scene.setShadowMode(RenderQueue.ShadowMode.CastAndReceive);
        scene.setLocalScale(400.0f);
        scene.setLocalTranslation(0.0f, -10.0f, -120.0f);
        this.rootNode.attachChild(scene);
        this.rootNode.attachChild(SkyFactory.createSky((AssetManager)this.assetManager, (String)"Textures/Sky/Bright/FullskiesBlueClear03.dds", (boolean)false));
        DirectionalLight sun = new DirectionalLight();
        Vector3f lightDir = new Vector3f(-0.12f, -0.3729129f, 0.74847335f);
        sun.setDirection(lightDir);
        sun.setColor(ColorRGBA.White.clone().multLocal(2.0f));
        scene.addLight((Light)sun);
        PssmShadowRenderer pssmRenderer = new PssmShadowRenderer(this.assetManager, 1024, 4);
        pssmRenderer.setDirection(lightDir);
        pssmRenderer.setShadowIntensity(0.55f);
        FilterPostProcessor fpp = new FilterPostProcessor(this.assetManager);
        Vector3f lightPos = lightDir.multLocal(-3000.0f);
        LightScatteringFilter filter = new LightScatteringFilter(lightPos);
        LightScatteringUI ui = new LightScatteringUI(this.inputManager, filter);
        fpp.addFilter((Filter)filter);
        this.viewPort.addProcessor((SceneProcessor)fpp);
    }

    public void simpleUpdate(float tpf) {
    }
}

