/*
 * Decompiled with CFR 0.152.
 */
package jme3test.terrain;

import com.jme3.app.SimpleApplication;
import com.jme3.app.state.AppState;
import com.jme3.app.state.ScreenshotAppState;
import com.jme3.asset.plugins.HttpZipLocator;
import com.jme3.asset.plugins.ZipLocator;
import com.jme3.bullet.BulletAppState;
import com.jme3.bullet.collision.shapes.CapsuleCollisionShape;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.collision.shapes.HeightfieldCollisionShape;
import com.jme3.bullet.control.CharacterControl;
import com.jme3.bullet.control.RigidBodyControl;
import com.jme3.input.controls.ActionListener;
import com.jme3.input.controls.InputListener;
import com.jme3.input.controls.KeyTrigger;
import com.jme3.input.controls.Trigger;
import com.jme3.light.AmbientLight;
import com.jme3.light.DirectionalLight;
import com.jme3.light.Light;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import com.jme3.terrain.Terrain;
import com.jme3.terrain.geomipmap.TerrainGrid;
import com.jme3.terrain.geomipmap.TerrainGridListener;
import com.jme3.terrain.geomipmap.TerrainLodControl;
import com.jme3.terrain.geomipmap.TerrainQuad;
import com.jme3.terrain.heightmap.FractalHeightMapGrid;
import com.jme3.terrain.heightmap.HeightMapGrid;
import com.jme3.texture.Texture;
import java.io.File;
import java.util.ArrayList;
import org.novyon.noise.Basis;
import org.novyon.noise.Filter;
import org.novyon.noise.ShaderUtils;
import org.novyon.noise.basis.FilteredBasis;
import org.novyon.noise.filter.IterativeFilter;
import org.novyon.noise.filter.OptimizedErode;
import org.novyon.noise.filter.PerturbFilter;
import org.novyon.noise.filter.SmoothFilter;
import org.novyon.noise.fractal.FractalSum;
import org.novyon.noise.modulator.Modulator;
import org.novyon.noise.modulator.NoiseModulator;

public class TerrainGridAlphaMapTest
extends SimpleApplication {
    private TerrainGrid terrain;
    private float grassScale = 64.0f;
    private float dirtScale = 16.0f;
    private float rockScale = 128.0f;
    private boolean usePhysics = true;
    private CharacterControl player3;
    private FractalSum base;
    private PerturbFilter perturb;
    private OptimizedErode therm;
    private SmoothFilter smooth;
    private IterativeFilter iterate;
    private Material matRock;
    private Material matWire;
    private boolean left;
    private boolean right;
    private boolean up;
    private boolean down;
    private final ActionListener actionListener = new ActionListener(){

        public void onAction(String name, boolean keyPressed, float tpf) {
            if (name.equals("Lefts")) {
                if (keyPressed) {
                    TerrainGridAlphaMapTest.this.left = true;
                } else {
                    TerrainGridAlphaMapTest.this.left = false;
                }
            } else if (name.equals("Rights")) {
                if (keyPressed) {
                    TerrainGridAlphaMapTest.this.right = true;
                } else {
                    TerrainGridAlphaMapTest.this.right = false;
                }
            } else if (name.equals("Ups")) {
                if (keyPressed) {
                    TerrainGridAlphaMapTest.this.up = true;
                } else {
                    TerrainGridAlphaMapTest.this.up = false;
                }
            } else if (name.equals("Downs")) {
                if (keyPressed) {
                    TerrainGridAlphaMapTest.this.down = true;
                } else {
                    TerrainGridAlphaMapTest.this.down = false;
                }
            } else if (name.equals("Jumps")) {
                TerrainGridAlphaMapTest.this.player3.jump();
            }
        }
    };
    private final Vector3f walkDirection = new Vector3f();

    public static void main(String[] args) {
        TerrainGridAlphaMapTest app = new TerrainGridAlphaMapTest();
        app.start();
    }

    public void simpleInitApp() {
        DirectionalLight sun = new DirectionalLight();
        sun.setColor(ColorRGBA.White);
        sun.setDirection(new Vector3f(-1.0f, -1.0f, -1.0f).normalizeLocal());
        this.rootNode.addLight((Light)sun);
        AmbientLight al = new AmbientLight();
        al.setColor(ColorRGBA.White.mult(1.3f));
        this.rootNode.addLight((Light)al);
        File file = new File("mountains.zip");
        if (!file.exists()) {
            this.assetManager.registerLocator("http://jmonkeyengine.googlecode.com/files/mountains.zip", HttpZipLocator.class);
        } else {
            this.assetManager.registerLocator("mountains.zip", ZipLocator.class);
        }
        this.flyCam.setMoveSpeed(100.0f);
        ScreenshotAppState state = new ScreenshotAppState();
        this.stateManager.attach((AppState)state);
        this.matRock = new Material(this.assetManager, "Common/MatDefs/Terrain/TerrainLighting.j3md");
        this.matRock.setBoolean("useTriPlanarMapping", false);
        this.matRock.setBoolean("isTerrainGrid", true);
        Texture grass = this.assetManager.loadTexture("Textures/Terrain/splat/grass.jpg");
        grass.setWrap(Texture.WrapMode.Repeat);
        this.matRock.setTexture("DiffuseMap", grass);
        this.matRock.setFloat("DiffuseMap_0_scale", this.grassScale);
        Texture dirt = this.assetManager.loadTexture("Textures/Terrain/splat/dirt.jpg");
        dirt.setWrap(Texture.WrapMode.Repeat);
        this.matRock.setTexture("DiffuseMap_1", dirt);
        this.matRock.setFloat("DiffuseMap_1_scale", this.dirtScale);
        Texture rock = this.assetManager.loadTexture("Textures/Terrain/splat/road.jpg");
        rock.setWrap(Texture.WrapMode.Repeat);
        this.matRock.setTexture("DiffuseMap_2", rock);
        this.matRock.setFloat("DiffuseMap_2_scale", this.rockScale);
        this.matWire = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        this.matWire.getAdditionalRenderState().setWireframe(true);
        this.matWire.setColor("Color", ColorRGBA.Green);
        this.base = new FractalSum();
        this.base.setRoughness(0.7f);
        this.base.setFrequency(1.0f);
        this.base.setAmplitude(1.0f);
        this.base.setLacunarity(2.12f);
        this.base.setOctaves(8.0f);
        this.base.setScale(0.02125f);
        this.base.addModulator((Modulator)new NoiseModulator(){

            public float value(float ... in) {
                return ShaderUtils.clamp((float)(in[0] * 0.5f + 0.5f), (float)0.0f, (float)1.0f);
            }
        });
        FilteredBasis ground = new FilteredBasis((Basis)this.base);
        this.perturb = new PerturbFilter();
        this.perturb.setMagnitude(0.119f);
        this.therm = new OptimizedErode();
        this.therm.setRadius(5);
        this.therm.setTalus(0.011f);
        this.smooth = new SmoothFilter();
        this.smooth.setRadius(1);
        this.smooth.setEffect(0.7f);
        this.iterate = new IterativeFilter();
        this.iterate.addPreFilter((Filter)this.perturb);
        this.iterate.addPostFilter((Filter)this.smooth);
        this.iterate.setFilter((Filter)this.therm);
        this.iterate.setIterations(1);
        ground.addPreFilter((Filter)this.iterate);
        this.terrain = new TerrainGrid("terrain", 33, 257, (HeightMapGrid)new FractalHeightMapGrid((Basis)ground, null, 256.0f));
        this.terrain.setMaterial(this.matRock);
        this.terrain.setLocalTranslation(0.0f, 0.0f, 0.0f);
        this.terrain.setLocalScale(2.0f, 1.0f, 2.0f);
        this.rootNode.attachChild((Spatial)this.terrain);
        ArrayList<Camera> cameras = new ArrayList<Camera>();
        cameras.add(this.getCamera());
        TerrainLodControl control = new TerrainLodControl((Terrain)this.terrain, cameras);
        this.terrain.addControl((Control)control);
        final BulletAppState bulletAppState = new BulletAppState();
        this.stateManager.attach((AppState)bulletAppState);
        this.getCamera().setLocation(new Vector3f(0.0f, 256.0f, 0.0f));
        this.viewPort.setBackgroundColor(new ColorRGBA(0.7f, 0.8f, 1.0f, 1.0f));
        if (this.usePhysics) {
            CapsuleCollisionShape capsuleShape = new CapsuleCollisionShape(0.5f, 1.8f, 1);
            this.player3 = new CharacterControl((CollisionShape)capsuleShape, 0.5f);
            this.player3.setJumpSpeed(20.0f);
            this.player3.setFallSpeed(10.0f);
            this.player3.setGravity(10.0f);
            this.player3.setPhysicsLocation(new Vector3f(this.cam.getLocation().x, 256.0f, this.cam.getLocation().z));
            bulletAppState.getPhysicsSpace().add((Object)this.player3);
        }
        this.terrain.addListener("physicsStartListener", new TerrainGridListener(){

            public void gridMoved(Vector3f newCenter) {
            }

            public Material tileLoaded(Material material, Vector3f cell) {
                return material;
            }

            public void tileAttached(Vector3f cell, TerrainQuad quad) {
                Texture alpha = TerrainGridAlphaMapTest.this.assetManager.loadTexture("Scenes/TerrainAlphaTest/alphamap_" + Math.abs((int)(cell.x % 2.0f)) * 512 + "_" + Math.abs((int)(cell.z % 2.0f) * 512) + ".png");
                quad.getMaterial().setTexture("AlphaMap", alpha);
                if (TerrainGridAlphaMapTest.this.usePhysics) {
                    quad.addControl((Control)new RigidBodyControl((CollisionShape)new HeightfieldCollisionShape(quad.getHeightMap(), TerrainGridAlphaMapTest.this.terrain.getLocalScale()), 0.0f));
                    bulletAppState.getPhysicsSpace().add((Object)quad);
                }
            }

            public void tileDetached(Vector3f cell, TerrainQuad quad) {
                if (TerrainGridAlphaMapTest.this.usePhysics) {
                    bulletAppState.getPhysicsSpace().remove((Object)quad);
                    quad.removeControl(RigidBodyControl.class);
                }
            }
        });
        this.terrain.initialize(this.cam.getLocation());
        this.initKeys();
    }

    private void initKeys() {
        this.inputManager.addMapping("Lefts", new Trigger[]{new KeyTrigger(30)});
        this.inputManager.addMapping("Rights", new Trigger[]{new KeyTrigger(32)});
        this.inputManager.addMapping("Ups", new Trigger[]{new KeyTrigger(17)});
        this.inputManager.addMapping("Downs", new Trigger[]{new KeyTrigger(31)});
        this.inputManager.addMapping("Jumps", new Trigger[]{new KeyTrigger(57)});
        this.inputManager.addListener((InputListener)this.actionListener, new String[]{"Lefts"});
        this.inputManager.addListener((InputListener)this.actionListener, new String[]{"Rights"});
        this.inputManager.addListener((InputListener)this.actionListener, new String[]{"Ups"});
        this.inputManager.addListener((InputListener)this.actionListener, new String[]{"Downs"});
        this.inputManager.addListener((InputListener)this.actionListener, new String[]{"Jumps"});
    }

    public void simpleUpdate(float tpf) {
        Vector3f camDir = this.cam.getDirection().clone().multLocal(0.6f);
        Vector3f camLeft = this.cam.getLeft().clone().multLocal(0.4f);
        this.walkDirection.set(0.0f, 0.0f, 0.0f);
        if (this.left) {
            this.walkDirection.addLocal(camLeft);
        }
        if (this.right) {
            this.walkDirection.addLocal(camLeft.negate());
        }
        if (this.up) {
            this.walkDirection.addLocal(camDir);
        }
        if (this.down) {
            this.walkDirection.addLocal(camDir.negate());
        }
        if (this.usePhysics) {
            this.player3.setWalkDirection(this.walkDirection);
            this.cam.setLocation(this.player3.getPhysicsLocation());
        }
    }
}

