/*
 * Decompiled with CFR 0.152.
 */
package jme3test.terrain;

import com.jme3.app.SimpleApplication;
import com.jme3.app.state.AppState;
import com.jme3.bounding.BoundingBox;
import com.jme3.bounding.BoundingVolume;
import com.jme3.bullet.BulletAppState;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.collision.shapes.SphereCollisionShape;
import com.jme3.bullet.control.RigidBodyControl;
import com.jme3.collision.Collidable;
import com.jme3.collision.CollisionResult;
import com.jme3.collision.CollisionResults;
import com.jme3.font.BitmapText;
import com.jme3.input.controls.ActionListener;
import com.jme3.input.controls.InputListener;
import com.jme3.input.controls.KeyTrigger;
import com.jme3.input.controls.MouseButtonTrigger;
import com.jme3.input.controls.Trigger;
import com.jme3.light.DirectionalLight;
import com.jme3.light.Light;
import com.jme3.light.PointLight;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Ray;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import com.jme3.scene.shape.Box;
import com.jme3.scene.shape.Sphere;
import com.jme3.terrain.Terrain;
import com.jme3.terrain.geomipmap.TerrainLodControl;
import com.jme3.terrain.geomipmap.TerrainQuad;
import com.jme3.terrain.heightmap.ImageBasedHeightMap;
import com.jme3.texture.Texture;
import java.awt.Image;
import jme3tools.converters.ImageToAwt;

public class TerrainTestCollision
extends SimpleApplication {
    TerrainQuad terrain;
    Node terrainPhysicsNode;
    Material matRock;
    Material matWire;
    boolean wireframe = false;
    protected BitmapText hintText;
    PointLight pl;
    Geometry lightMdl;
    Geometry collisionMarker;
    private BulletAppState bulletAppState;
    Geometry collisionSphere;
    Geometry collisionBox;
    Geometry selectedCollisionObject;
    private ActionListener actionListener = new ActionListener(){

        public void onAction(String binding, boolean keyPressed, float tpf) {
            if (binding.equals("wireframe") && !keyPressed) {
                boolean bl = TerrainTestCollision.this.wireframe = !TerrainTestCollision.this.wireframe;
                if (!TerrainTestCollision.this.wireframe) {
                    TerrainTestCollision.this.terrain.setMaterial(TerrainTestCollision.this.matWire);
                } else {
                    TerrainTestCollision.this.terrain.setMaterial(TerrainTestCollision.this.matRock);
                }
            } else if (binding.equals("shoot") && !keyPressed) {
                Vector3f origin = TerrainTestCollision.this.cam.getWorldCoordinates(new Vector2f((float)(TerrainTestCollision.this.settings.getWidth() / 2), (float)(TerrainTestCollision.this.settings.getHeight() / 2)), 0.0f);
                Vector3f direction = TerrainTestCollision.this.cam.getWorldCoordinates(new Vector2f((float)(TerrainTestCollision.this.settings.getWidth() / 2), (float)(TerrainTestCollision.this.settings.getHeight() / 2)), 0.3f);
                direction.subtractLocal(origin).normalizeLocal();
                Ray ray = new Ray(origin, direction);
                CollisionResults results = new CollisionResults();
                int numCollisions = TerrainTestCollision.this.terrain.collideWith((Collidable)ray, results);
                if (numCollisions > 0) {
                    CollisionResult hit = results.getClosestCollision();
                    if (TerrainTestCollision.this.collisionMarker == null) {
                        TerrainTestCollision.this.createCollisionMarker();
                    }
                    Vector2f loc = new Vector2f(hit.getContactPoint().x, hit.getContactPoint().z);
                    float height = TerrainTestCollision.this.terrain.getHeight(loc);
                    System.out.println("collide " + hit.getContactPoint() + ", height: " + height + ", distance: " + hit.getDistance());
                    TerrainTestCollision.this.collisionMarker.setLocalTranslation(new Vector3f(hit.getContactPoint().x, height, hit.getContactPoint().z));
                }
            } else if (binding.equals("cameraDown") && !keyPressed) {
                TerrainTestCollision.this.getCamera().lookAtDirection(new Vector3f(0.0f, -1.0f, 0.0f), Vector3f.UNIT_Y);
            } else if (binding.equals("Lefts") && !keyPressed) {
                Vector3f oldLoc = TerrainTestCollision.this.selectedCollisionObject.getLocalTranslation().clone();
                TerrainTestCollision.this.selectedCollisionObject.move(-0.5f, 0.0f, 0.0f);
                TerrainTestCollision.this.testCollision(oldLoc);
            } else if (binding.equals("Rights") && !keyPressed) {
                Vector3f oldLoc = TerrainTestCollision.this.selectedCollisionObject.getLocalTranslation().clone();
                TerrainTestCollision.this.selectedCollisionObject.move(0.5f, 0.0f, 0.0f);
                TerrainTestCollision.this.testCollision(oldLoc);
            } else if (binding.equals("Forwards") && !keyPressed) {
                Vector3f oldLoc = TerrainTestCollision.this.selectedCollisionObject.getLocalTranslation().clone();
                TerrainTestCollision.this.selectedCollisionObject.move(0.0f, 0.0f, 0.5f);
                TerrainTestCollision.this.testCollision(oldLoc);
            } else if (binding.equals("Backs") && !keyPressed) {
                Vector3f oldLoc = TerrainTestCollision.this.selectedCollisionObject.getLocalTranslation().clone();
                TerrainTestCollision.this.selectedCollisionObject.move(0.0f, 0.0f, -0.5f);
                TerrainTestCollision.this.testCollision(oldLoc);
            } else if (binding.equals("Ups") && !keyPressed) {
                Vector3f oldLoc = TerrainTestCollision.this.selectedCollisionObject.getLocalTranslation().clone();
                TerrainTestCollision.this.selectedCollisionObject.move(0.0f, 0.5f, 0.0f);
                TerrainTestCollision.this.testCollision(oldLoc);
            } else if (binding.equals("Downs") && !keyPressed) {
                Vector3f oldLoc = TerrainTestCollision.this.selectedCollisionObject.getLocalTranslation().clone();
                TerrainTestCollision.this.selectedCollisionObject.move(0.0f, -0.5f, 0.0f);
                TerrainTestCollision.this.testCollision(oldLoc);
            }
        }
    };

    public static void main(String[] args) {
        TerrainTestCollision app = new TerrainTestCollision();
        app.start();
    }

    public void initialize() {
        super.initialize();
        this.loadHintText();
        this.initCrossHairs();
    }

    public void simpleInitApp() {
        this.bulletAppState = new BulletAppState();
        this.bulletAppState.setThreadingType(BulletAppState.ThreadingType.PARALLEL);
        this.stateManager.attach((AppState)this.bulletAppState);
        this.setupKeys();
        this.matRock = new Material(this.assetManager, "Common/MatDefs/Terrain/Terrain.j3md");
        this.matRock.setTexture("Alpha", this.assetManager.loadTexture("Textures/Terrain/splat/alphamap.png"));
        Texture heightMapImage = this.assetManager.loadTexture("Textures/Terrain/splat/mountains512.png");
        Texture grass = this.assetManager.loadTexture("Textures/Terrain/splat/grass.jpg");
        grass.setWrap(Texture.WrapMode.Repeat);
        this.matRock.setTexture("Tex1", grass);
        this.matRock.setFloat("Tex1Scale", 64.0f);
        Texture dirt = this.assetManager.loadTexture("Textures/Terrain/splat/dirt.jpg");
        dirt.setWrap(Texture.WrapMode.Repeat);
        this.matRock.setTexture("Tex2", dirt);
        this.matRock.setFloat("Tex2Scale", 32.0f);
        Texture rock = this.assetManager.loadTexture("Textures/Terrain/splat/road.jpg");
        rock.setWrap(Texture.WrapMode.Repeat);
        this.matRock.setTexture("Tex3", rock);
        this.matRock.setFloat("Tex3Scale", 128.0f);
        this.matWire = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        this.matWire.getAdditionalRenderState().setWireframe(true);
        this.matWire.setColor("Color", ColorRGBA.Green);
        ImageBasedHeightMap heightmap = null;
        try {
            heightmap = new ImageBasedHeightMap((Image)ImageToAwt.convert((com.jme3.texture.Image)heightMapImage.getImage(), (boolean)false, (boolean)true, (int)0), 0.25f);
            heightmap.load();
        }
        catch (Exception e) {
            // empty catch block
        }
        this.terrain = new TerrainQuad("terrain", 65, 513, heightmap.getHeightMap());
        TerrainLodControl control = new TerrainLodControl((Terrain)this.terrain, this.getCamera());
        this.terrain.addControl((Control)control);
        this.terrain.setMaterial(this.matRock);
        this.terrain.setLocalScale(new Vector3f(2.0f, 2.0f, 2.0f));
        this.terrain.setLocked(false);
        this.rootNode.attachChild((Spatial)this.terrain);
        this.terrain.addControl((Control)new RigidBodyControl(0.0f));
        this.bulletAppState.getPhysicsSpace().addAll((Spatial)this.terrain);
        for (int i = 0; i < 5; ++i) {
            float r = (float)(8.0 * Math.random());
            Geometry sphere = new Geometry("cannonball", (Mesh)new Sphere(10, 10, r));
            sphere.setMaterial(this.matWire);
            float x = (float)(20.0 * Math.random()) - 40.0f;
            float y = (float)(20.0 * Math.random()) - 40.0f;
            float z = (float)(20.0 * Math.random()) - 40.0f;
            sphere.setLocalTranslation(new Vector3f(x, 100.0f + y, z));
            sphere.addControl((Control)new RigidBodyControl((CollisionShape)new SphereCollisionShape(r), 2.0f));
            this.rootNode.attachChild((Spatial)sphere);
            this.bulletAppState.getPhysicsSpace().add((Object)sphere);
        }
        this.collisionBox = new Geometry("collisionBox", (Mesh)new Box(2.0f, 2.0f, 2.0f));
        this.collisionBox.setModelBound((BoundingVolume)new BoundingBox());
        this.collisionBox.setLocalTranslation(new Vector3f(20.0f, 95.0f, 30.0f));
        this.collisionBox.setMaterial(this.matWire);
        this.rootNode.attachChild((Spatial)this.collisionBox);
        this.selectedCollisionObject = this.collisionBox;
        DirectionalLight dl = new DirectionalLight();
        dl.setDirection(new Vector3f(1.0f, -0.5f, -0.1f).normalizeLocal());
        dl.setColor(new ColorRGBA(0.5f, 0.4f, 0.5f, 1.0f));
        this.rootNode.addLight((Light)dl);
        this.cam.setLocation(new Vector3f(0.0f, 25.0f, -10.0f));
        this.cam.lookAtDirection(new Vector3f(0.0f, -1.0f, 0.0f).normalizeLocal(), Vector3f.UNIT_Y);
    }

    public void loadHintText() {
        this.hintText = new BitmapText(this.guiFont, false);
        this.hintText.setSize((float)this.guiFont.getCharSet().getRenderedSize());
        this.hintText.setLocalTranslation(0.0f, (float)this.getCamera().getHeight(), 0.0f);
        this.hintText.setText("");
        this.guiNode.attachChild((Spatial)this.hintText);
    }

    protected void initCrossHairs() {
        BitmapText ch = new BitmapText(this.guiFont, false);
        ch.setSize((float)(this.guiFont.getCharSet().getRenderedSize() * 2));
        ch.setText("+");
        ch.setLocalTranslation((float)(this.settings.getWidth() / 2 - this.guiFont.getCharSet().getRenderedSize() / 3 * 2), (float)(this.settings.getHeight() / 2) + ch.getLineHeight() / 2.0f, 0.0f);
        this.guiNode.attachChild((Spatial)ch);
    }

    private void setupKeys() {
        this.flyCam.setMoveSpeed(50.0f);
        this.inputManager.addMapping("wireframe", new Trigger[]{new KeyTrigger(20)});
        this.inputManager.addListener((InputListener)this.actionListener, new String[]{"wireframe"});
        this.inputManager.addMapping("Lefts", new Trigger[]{new KeyTrigger(35)});
        this.inputManager.addMapping("Rights", new Trigger[]{new KeyTrigger(37)});
        this.inputManager.addMapping("Ups", new Trigger[]{new KeyTrigger(22)});
        this.inputManager.addMapping("Downs", new Trigger[]{new KeyTrigger(36)});
        this.inputManager.addMapping("Forwards", new Trigger[]{new KeyTrigger(21)});
        this.inputManager.addMapping("Backs", new Trigger[]{new KeyTrigger(23)});
        this.inputManager.addListener((InputListener)this.actionListener, new String[]{"Lefts"});
        this.inputManager.addListener((InputListener)this.actionListener, new String[]{"Rights"});
        this.inputManager.addListener((InputListener)this.actionListener, new String[]{"Ups"});
        this.inputManager.addListener((InputListener)this.actionListener, new String[]{"Downs"});
        this.inputManager.addListener((InputListener)this.actionListener, new String[]{"Forwards"});
        this.inputManager.addListener((InputListener)this.actionListener, new String[]{"Backs"});
        this.inputManager.addMapping("shoot", new Trigger[]{new MouseButtonTrigger(0)});
        this.inputManager.addListener((InputListener)this.actionListener, new String[]{"shoot"});
        this.inputManager.addMapping("cameraDown", new Trigger[]{new MouseButtonTrigger(1)});
        this.inputManager.addListener((InputListener)this.actionListener, new String[]{"cameraDown"});
    }

    public void update() {
        super.update();
    }

    private void createCollisionMarker() {
        Sphere s = new Sphere(6, 6, 1.0f);
        this.collisionMarker = new Geometry("collisionMarker");
        this.collisionMarker.setMesh((Mesh)s);
        Material mat = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        mat.setColor("Color", ColorRGBA.Orange);
        this.collisionMarker.setMaterial(mat);
        this.rootNode.attachChild((Spatial)this.collisionMarker);
    }

    private void testCollision(Vector3f oldLoc) {
        if (this.terrain.collideWith((Collidable)this.selectedCollisionObject.getWorldBound(), new CollisionResults()) > 0) {
            this.selectedCollisionObject.setLocalTranslation(oldLoc);
        }
    }
}

