/*
 * Decompiled with CFR 0.152.
 */
package jme3test.water;

import com.jme3.app.SimpleApplication;
import com.jme3.asset.AssetManager;
import com.jme3.asset.plugins.HttpZipLocator;
import com.jme3.asset.plugins.ZipLocator;
import com.jme3.light.DirectionalLight;
import com.jme3.light.Light;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Plane;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.post.SceneProcessor;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Quad;
import com.jme3.scene.shape.Sphere;
import com.jme3.util.SkyFactory;
import com.jme3.water.SimpleWaterProcessor;
import java.io.File;
import jme3test.water.WaterUI;

public class TestSceneWater
extends SimpleApplication {
    private static boolean useHttp = true;

    public static void main(String[] args) {
        TestSceneWater app = new TestSceneWater();
        app.start();
    }

    public void simpleInitApp() {
        this.flyCam.setMoveSpeed(10.0f);
        Node mainScene = new Node();
        this.cam.setLocation(new Vector3f(-27.0f, 1.0f, 75.0f));
        this.cam.setRotation(new Quaternion(0.03f, 0.9f, 0.0f, 0.4f));
        mainScene.attachChild(SkyFactory.createSky((AssetManager)this.assetManager, (String)"Textures/Sky/Bright/BrightSky.dds", (boolean)false));
        File file = new File("wildhouse.zip");
        if (file.exists()) {
            useHttp = false;
        }
        if (useHttp) {
            this.assetManager.registerLocator("http://jmonkeyengine.googlecode.com/files/wildhouse.zip", HttpZipLocator.class.getName());
        } else {
            this.assetManager.registerLocator("wildhouse.zip", ZipLocator.class.getName());
        }
        Spatial scene = this.assetManager.loadModel("main.scene");
        DirectionalLight sun = new DirectionalLight();
        Vector3f lightDir = new Vector3f(-0.37352666f, -0.50444174f, -0.7784704f);
        sun.setDirection(lightDir);
        sun.setColor(ColorRGBA.White.clone().multLocal(2.0f));
        scene.addLight((Light)sun);
        Material mat = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        mat.setTexture("ColorMap", this.assetManager.loadTexture("Interface/Logo/Monkey.jpg"));
        Sphere lite = new Sphere(8, 8, 3.0f);
        Geometry lightSphere = new Geometry("lightsphere", (Mesh)lite);
        lightSphere.setMaterial(mat);
        Vector3f lightPos = lightDir.multLocal(-400.0f);
        lightSphere.setLocalTranslation(lightPos);
        this.rootNode.attachChild((Spatial)lightSphere);
        SimpleWaterProcessor waterProcessor = new SimpleWaterProcessor(this.assetManager);
        waterProcessor.setReflectionScene((Spatial)mainScene);
        waterProcessor.setDebug(false);
        waterProcessor.setLightPosition(lightPos);
        waterProcessor.setRefractionClippingOffset(1.0f);
        Vector3f waterLocation = new Vector3f(0.0f, -20.0f, 0.0f);
        waterProcessor.setPlane(new Plane(Vector3f.UNIT_Y, waterLocation.dot(Vector3f.UNIT_Y)));
        WaterUI waterUi = new WaterUI(this.inputManager, waterProcessor);
        waterProcessor.setWaterColor(ColorRGBA.Brown);
        waterProcessor.setDebug(true);
        Quad quad = new Quad(400.0f, 400.0f);
        quad.scaleTextureCoordinates(new Vector2f(6.0f, 6.0f));
        Geometry water = new Geometry("water", (Mesh)quad);
        water.setShadowMode(RenderQueue.ShadowMode.Receive);
        water.setLocalRotation(new Quaternion().fromAngleAxis(-1.5707964f, Vector3f.UNIT_X));
        water.setMaterial(waterProcessor.getMaterial());
        water.setLocalTranslation(-200.0f, -20.0f, 250.0f);
        this.rootNode.attachChild((Spatial)water);
        this.viewPort.addProcessor((SceneProcessor)waterProcessor);
        mainScene.attachChild(scene);
        this.rootNode.attachChild((Spatial)mainScene);
    }
}

